/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OCommit37Response;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.tx.IndexChange;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializerDelta;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OCommit38Request
implements OBinaryRequest<OCommit37Response> {
    private int txId;
    private boolean hasContent;
    private boolean usingLog;
    private List<ORecordOperationRequest> operations;
    private List<IndexChange> indexChanges;

    public OCommit38Request() {
    }

    public OCommit38Request(int txId, boolean hasContent, boolean usingLong, Iterable<ORecordOperation> operations, Map<String, OTransactionIndexChanges> indexChanges) {
        this.txId = txId;
        this.hasContent = hasContent;
        this.usingLog = usingLong;
        if (hasContent) {
            this.indexChanges = new ArrayList<IndexChange>();
            ArrayList<ORecordOperationRequest> netOperations = new ArrayList<ORecordOperationRequest>();
            for (ORecordOperation oRecordOperation : operations) {
                if (oRecordOperation.type == 0) continue;
                ORecordOperationRequest request = new ORecordOperationRequest();
                request.setType(oRecordOperation.type);
                request.setVersion(oRecordOperation.getRecord().getVersion());
                request.setId(oRecordOperation.getRecord().getIdentity());
                switch (oRecordOperation.type) {
                    case 3: {
                        request.setRecordType(ORecordInternal.getRecordType((ORecord)oRecordOperation.getRecord()));
                        request.setRecord(ORecordSerializerNetworkV37.INSTANCE.toStream(oRecordOperation.getRecord()));
                        request.setContentChanged(ORecordInternal.isContentChanged((ORecord)oRecordOperation.getRecord()));
                        break;
                    }
                    case 1: {
                        if (100 == ORecordInternal.getRecordType((ORecord)oRecordOperation.getRecord())) {
                            request.setRecordType((byte)10);
                            ODocumentSerializerDelta delta = ODocumentSerializerDelta.instance();
                            request.setRecord(delta.serializeDelta((ODocument)oRecordOperation.getRecord()));
                            request.setContentChanged(ORecordInternal.isContentChanged((ORecord)oRecordOperation.getRecord()));
                            break;
                        }
                        request.setRecordType(ORecordInternal.getRecordType((ORecord)oRecordOperation.getRecord()));
                        request.setRecord(ORecordSerializerNetworkV37.INSTANCE.toStream(oRecordOperation.getRecord()));
                        request.setContentChanged(ORecordInternal.isContentChanged((ORecord)oRecordOperation.getRecord()));
                    }
                }
                netOperations.add(request);
            }
            this.operations = netOperations;
            for (Map.Entry entry : indexChanges.entrySet()) {
                this.indexChanges.add(new IndexChange((String)entry.getKey(), (OTransactionIndexChanges)entry.getValue()));
            }
        }
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        ORecordSerializerNetworkV37 serializer = ORecordSerializerNetworkV37.INSTANCE;
        network.writeInt(this.txId);
        network.writeBoolean(this.hasContent);
        network.writeBoolean(this.usingLog);
        if (this.hasContent) {
            for (ORecordOperationRequest txEntry : this.operations) {
                OMessageHelper.writeTransactionEntry(network, txEntry, (ORecordSerializer)serializer);
            }
            network.writeByte((byte)0);
            OMessageHelper.writeTransactionIndexChanges(network, serializer, this.indexChanges);
        }
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.txId = channel.readInt();
        this.hasContent = channel.readBoolean();
        this.usingLog = channel.readBoolean();
        if (this.hasContent) {
            byte hasEntry;
            this.operations = new ArrayList<ORecordOperationRequest>();
            do {
                if ((hasEntry = channel.readByte()) != 1) continue;
                ORecordOperationRequest entry = OMessageHelper.readTransactionEntry(channel, serializer);
                this.operations.add(entry);
            } while (hasEntry == 1);
            this.indexChanges = OMessageHelper.readTransactionIndexChanges(channel, (ORecordSerializerNetworkV37)serializer);
        }
    }

    @Override
    public byte getCommand() {
        return 60;
    }

    @Override
    public OCommit37Response createResponse() {
        return new OCommit37Response();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeCommit38(this);
    }

    @Override
    public String getDescription() {
        return "Commit";
    }

    public int getTxId() {
        return this.txId;
    }

    public List<IndexChange> getIndexChanges() {
        return this.indexChanges;
    }

    public List<ORecordOperationRequest> getOperations() {
        return this.operations;
    }

    public boolean isUsingLog() {
        return this.usingLog;
    }

    public boolean isHasContent() {
        return this.hasContent;
    }
}

