/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OBeginTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.client.remote.message.tx.IndexChange;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializerDelta;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OBeginTransaction38Request
implements OBinaryRequest<OBeginTransactionResponse> {
    private int txId;
    private boolean usingLog;
    private boolean hasContent;
    private List<ORecordOperationRequest> operations;
    private List<IndexChange> indexChanges;

    public OBeginTransaction38Request(int txId, boolean hasContent, boolean usingLog, Iterable<ORecordOperation> operations, Map<String, OTransactionIndexChanges> indexChanges) {
        this.txId = txId;
        this.hasContent = hasContent;
        this.usingLog = usingLog;
        this.indexChanges = new ArrayList<IndexChange>();
        this.operations = new ArrayList<ORecordOperationRequest>();
        if (hasContent) {
            for (ORecordOperation oRecordOperation : operations) {
                if (oRecordOperation.type == 0) continue;
                ORecordOperationRequest request = new ORecordOperationRequest();
                request.setType(oRecordOperation.type);
                request.setVersion(oRecordOperation.getRecord().getVersion());
                request.setId(oRecordOperation.getRecord().getIdentity());
                request.setRecordType(ORecordInternal.getRecordType((ORecord)oRecordOperation.getRecord()));
                switch (oRecordOperation.type) {
                    case 3: {
                        request.setRecord(ORecordSerializerNetworkV37.INSTANCE.toStream(oRecordOperation.getRecord()));
                        request.setContentChanged(ORecordInternal.isContentChanged((ORecord)oRecordOperation.getRecord()));
                        break;
                    }
                    case 1: {
                        if (100 == ORecordInternal.getRecordType((ORecord)oRecordOperation.getRecord())) {
                            request.setRecordType((byte)10);
                            ODocumentSerializerDelta delta = ODocumentSerializerDelta.instance();
                            request.setRecord(delta.serializeDelta((ODocument)oRecordOperation.getRecord()));
                        } else {
                            request.setRecord(ORecordSerializerNetworkV37.INSTANCE.toStream(oRecordOperation.getRecord()));
                        }
                        request.setContentChanged(ORecordInternal.isContentChanged((ORecord)oRecordOperation.getRecord()));
                    }
                }
                this.operations.add(request);
            }
            for (Map.Entry entry : indexChanges.entrySet()) {
                this.indexChanges.add(new IndexChange((String)entry.getKey(), (OTransactionIndexChanges)entry.getValue()));
            }
        }
    }

    public OBeginTransaction38Request() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        ORecordSerializerNetworkV37 serializer = ORecordSerializerNetworkV37.INSTANCE;
        network.writeInt(this.txId);
        network.writeBoolean(this.hasContent);
        network.writeBoolean(this.usingLog);
        if (this.hasContent) {
            for (ORecordOperationRequest txEntry : this.operations) {
                OBeginTransaction38Request.writeTransactionEntry(network, txEntry);
            }
            network.writeByte((byte)0);
            OMessageHelper.writeTransactionIndexChanges(network, serializer, this.indexChanges);
        }
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.txId = channel.readInt();
        this.hasContent = channel.readBoolean();
        this.usingLog = channel.readBoolean();
        this.operations = new ArrayList<ORecordOperationRequest>();
        if (this.hasContent) {
            byte hasEntry;
            do {
                if ((hasEntry = channel.readByte()) != 1) continue;
                ORecordOperationRequest entry = OBeginTransaction38Request.readTransactionEntry(channel);
                this.operations.add(entry);
            } while (hasEntry == 1);
            this.indexChanges = OMessageHelper.readTransactionIndexChanges(channel, (ORecordSerializerNetworkV37)serializer);
        } else {
            this.indexChanges = new ArrayList<IndexChange>();
        }
    }

    @Override
    public byte getCommand() {
        return 61;
    }

    @Override
    public OBeginTransactionResponse createResponse() {
        return new OBeginTransactionResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeBeginTransaction38(this);
    }

    @Override
    public String getDescription() {
        return "Begin Transaction";
    }

    public List<ORecordOperationRequest> getOperations() {
        return this.operations;
    }

    public List<IndexChange> getIndexChanges() {
        return this.indexChanges;
    }

    public int getTxId() {
        return this.txId;
    }

    public boolean isUsingLog() {
        return this.usingLog;
    }

    public boolean isHasContent() {
        return this.hasContent;
    }

    static ORecordOperationRequest readTransactionEntry(OChannelDataInput channel) throws IOException {
        ORecordOperationRequest entry = new ORecordOperationRequest();
        entry.setType(channel.readByte());
        entry.setId((ORID)channel.readRID());
        entry.setRecordType(channel.readByte());
        switch (entry.getType()) {
            case 3: {
                entry.setRecord(channel.readBytes());
                break;
            }
            case 1: {
                entry.setVersion(channel.readVersion());
                entry.setRecord(channel.readBytes());
                entry.setContentChanged(channel.readBoolean());
                break;
            }
            case 2: {
                entry.setVersion(channel.readVersion());
                break;
            }
        }
        return entry;
    }

    static void writeTransactionEntry(OChannelDataOutput iNetwork, ORecordOperationRequest txEntry) throws IOException {
        iNetwork.writeByte((byte)1);
        iNetwork.writeByte(txEntry.getType());
        iNetwork.writeRID(txEntry.getId());
        iNetwork.writeByte(txEntry.getRecordType());
        switch (txEntry.getType()) {
            case 3: {
                iNetwork.writeBytes(txEntry.getRecord());
                break;
            }
            case 1: {
                iNetwork.writeVersion(txEntry.getVersion());
                iNetwork.writeBytes(txEntry.getRecord());
                iNetwork.writeBoolean(txEntry.isContentChanged());
                break;
            }
            case 2: {
                iNetwork.writeVersion(txEntry.getVersion());
            }
        }
    }
}

