/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.Bits;
import com.orangesignal.jlha.Factory;
import com.orangesignal.jlha.HashMethod;
import com.orangesignal.jlha.HashShort;
import com.orangesignal.jlha.LzssOutputStream;
import com.orangesignal.jlha.LzssSearchMethod;
import java.lang.reflect.InvocationTargetException;

public class TwoLevelHashSearch
implements LzssSearchMethod {
    private int dictionarySize;
    private int maxMatch;
    private int threshold;
    private byte[] textBuffer;
    private int dictionaryLimit;
    private HashMethod primaryHash;
    private int[] primaryHashTable;
    private int[] primaryCount;
    private int[] secondaryHashRequires;
    private int[] secondaryHashTable;
    private int[] dummy;
    private int[] prev;

    public TwoLevelHashSearch(int dictionarySize, int maxMatch, int threshold, byte[] textBuffer) {
        this(dictionarySize, maxMatch, threshold, textBuffer, HashShort.class.getName());
    }

    public TwoLevelHashSearch(int dictionarySize, int maxMatch, int threshold, byte[] textBuffer, String hashMethodClassName) {
        int i;
        this.dictionarySize = dictionarySize;
        this.maxMatch = maxMatch;
        this.threshold = threshold;
        this.textBuffer = textBuffer;
        this.dictionaryLimit = this.dictionarySize;
        try {
            this.primaryHash = (HashMethod)Factory.createInstance(hashMethodClassName, new Object[]{textBuffer});
        }
        catch (ClassNotFoundException exception) {
            throw new NoClassDefFoundError(exception.getMessage());
        }
        catch (InvocationTargetException exception) {
            throw new Error(exception.getTargetException().getMessage());
        }
        catch (NoSuchMethodException exception) {
            throw new NoSuchMethodError(exception.getMessage());
        }
        catch (InstantiationException exception) {
            throw new InstantiationError(exception.getMessage());
        }
        this.primaryHashTable = new int[this.primaryHash.tableSize()];
        this.secondaryHashTable = new int[this.primaryHash.tableSize() + this.dictionarySize / 4];
        for (i = 0; i < this.primaryHashTable.length; ++i) {
            this.primaryHashTable[i] = i;
            this.secondaryHashTable[i] = -1;
        }
        this.primaryCount = new int[this.primaryHash.tableSize()];
        this.secondaryHashRequires = new int[this.primaryHash.tableSize()];
        this.dummy = new int[this.secondaryHashTable.length];
        this.prev = new int[this.dictionarySize];
        for (i = 0; i < this.prev.length; ++i) {
            this.prev[i] = -1;
        }
    }

    @Override
    public void put(int position) {
        int phash = this.primaryHash.hash(position);
        int base = this.primaryHashTable[phash];
        int shash = this.secondaryHash(position, this.secondaryHashRequires[phash]);
        int n = phash;
        this.primaryCount[n] = this.primaryCount[n] + 1;
        this.prev[position & this.dictionarySize - 1] = this.secondaryHashTable[base + shash];
        this.secondaryHashTable[base + shash] = position;
    }

    @Override
    public int searchAndPut(int position) {
        int matchlen = this.threshold - 1;
        int matchpos = position;
        int scanlimit = Math.max(this.dictionaryLimit, position - this.dictionarySize);
        int phash = this.primaryHash.hash(position);
        int base = this.primaryHashTable[phash];
        int requires = this.secondaryHashRequires[phash];
        int shash = this.secondaryHash(position, requires);
        int scanpos = this.secondaryHashTable[base + shash];
        byte[] buf = this.textBuffer;
        int max = position + this.maxMatch;
        int s = 0;
        int p = 0;
        int len = 0;
        while (scanlimit <= scanpos) {
            if (buf[scanpos + matchlen] == buf[position + matchlen]) {
                s = scanpos;
                p = position;
                while (buf[s] == buf[p]) {
                    ++s;
                    if (max > ++p) continue;
                }
                if (matchlen < (len = p - position)) {
                    matchpos = scanpos;
                    matchlen = len;
                    if (max <= p) break;
                }
            }
            scanpos = this.prev[scanpos & this.dictionarySize - 1];
        }
        int revbits = 1;
        int loopend = requires - Math.max(0, this.threshold - this.primaryHash.hashRequires());
        int maxmatch = this.primaryHash.hashRequires() + requires - 1;
        int i = 1;
        int send = 4;
        while (i <= loopend && matchlen <= maxmatch) {
            max += position + maxmatch;
            while (revbits < send) {
                scanpos = this.secondaryHashTable[base + (shash ^ revbits)];
                while (scanlimit <= scanpos) {
                    if (buf[scanpos] == buf[position]) {
                        s = scanpos + 1;
                        p = position + 1;
                        while (buf[s] == buf[p]) {
                            ++s;
                            if (max > ++p) continue;
                        }
                        if (matchlen < (len = p - position) || matchlen == len && matchpos < scanpos) {
                            matchpos = scanpos;
                            matchlen = len;
                            if (max <= p) {
                                scanlimit = scanpos;
                                break;
                            }
                        }
                    }
                    scanpos = this.prev[scanpos & this.dictionarySize - 1];
                }
                ++revbits;
            }
            maxmatch = this.primaryHash.hashRequires() + requires - i - 1;
            ++i;
            send <<= 2;
        }
        int n = phash;
        this.primaryCount[n] = this.primaryCount[n] + 1;
        this.prev[position & this.dictionarySize - 1] = this.secondaryHashTable[base + shash];
        this.secondaryHashTable[base + shash] = position;
        if (this.threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    @Override
    public int search(int position, int lastPutPos) {
        int scanpos;
        int matchlen = this.threshold - 1;
        int matchpos = position;
        int scanlimit = Math.max(this.dictionaryLimit, lastPutPos);
        byte[] buf = this.textBuffer;
        int max = Math.min(this.textBuffer.length, position + this.maxMatch);
        int s = 0;
        int p = 0;
        int len = 0;
        for (scanpos = position - 1; scanlimit < scanpos; --scanpos) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max > ++p) continue;
            }
            if (matchlen >= len) continue;
            matchpos = scanpos;
            matchlen = len;
        }
        int phashRequires = this.primaryHash.hashRequires();
        if (phashRequires < this.textBuffer.length - position) {
            int start;
            int shash;
            int phash = this.primaryHash.hash(position);
            int base = this.primaryHashTable[phash];
            int requires = this.secondaryHashRequires[phash];
            if (phashRequires + requires < this.textBuffer.length - position) {
                shash = this.secondaryHash(position, requires);
                start = 0;
            } else {
                int avail = this.textBuffer.length - position - phashRequires;
                shash = this.secondaryHash(position, avail) << (requires - avail) * 2;
                start = requires - avail;
            }
            int revbits = 0;
            int maxmatch = this.maxMatch;
            int i = start;
            int send = 1 << i * 2;
            while (i <= requires) {
                max += position + maxmatch;
                while (revbits < send) {
                    scanpos = this.secondaryHashTable[base + (shash ^ revbits)];
                    while (scanlimit <= scanpos) {
                        if (buf[scanpos] == buf[position]) {
                            s = scanpos + 1;
                            p = position + 1;
                            while (buf[s] == buf[p]) {
                                ++s;
                                if (max > ++p) continue;
                            }
                            if (matchlen < (len = p - position) || matchlen == len && matchpos < scanpos) {
                                matchpos = scanpos;
                                matchlen = len;
                                if (max <= p) {
                                    scanlimit = scanpos;
                                    break;
                                }
                            }
                        }
                        scanpos = this.prev[scanpos & this.dictionarySize - 1];
                    }
                    ++revbits;
                }
                maxmatch = this.primaryHash.hashRequires() + requires - i - 1;
                ++i;
                send <<= 2;
            }
        }
        if (this.threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    @Override
    public void slide() {
        this.dictionaryLimit = Math.max(0, this.dictionaryLimit - this.dictionarySize);
        int secondaryIndex = 0;
        int dummyIndex = 0;
        for (int i = 0; i < this.primaryHashTable.length; ++i) {
            int j;
            this.primaryHashTable[i] = dummyIndex;
            int bits = this.secondaryHashRequires[i] * 2;
            if (1 << 5 + bits <= this.primaryCount[i]) {
                for (j = 0; j < 1 << bits; ++j) {
                    this.divide(dummyIndex, secondaryIndex, this.primaryHash.hashRequires() + this.secondaryHashRequires[i]);
                    dummyIndex += 4;
                    ++secondaryIndex;
                }
                int n = i;
                this.secondaryHashRequires[n] = this.secondaryHashRequires[n] + 1;
            } else if (0 < bits && this.primaryCount[i] < 1 << 2 + bits) {
                for (j = 0; j < 1 << bits - 2; ++j) {
                    this.merge(dummyIndex, secondaryIndex);
                    ++dummyIndex;
                    secondaryIndex += 4;
                }
                int n = i;
                this.secondaryHashRequires[n] = this.secondaryHashRequires[n] - 1;
            } else {
                for (j = 0; j < 1 << bits; ++j) {
                    int pos = this.secondaryHashTable[secondaryIndex++] - this.dictionarySize;
                    this.dummy[dummyIndex++] = 0 <= pos ? pos : -1;
                }
            }
            this.primaryCount[i] = 0;
        }
        int[] temp = this.secondaryHashTable;
        this.secondaryHashTable = this.dummy;
        this.dummy = temp;
        for (int i = 0; i < this.prev.length; ++i) {
            int pos = this.prev[i] - this.dictionarySize;
            this.prev[i] = 0 <= pos ? pos : -1;
        }
    }

    @Override
    public int putRequires() {
        return this.primaryHash.hashRequires() + Math.max(Bits.len(this.dictionarySize) - 5, 0) / 2;
    }

    private int secondaryHash(int position, int hashRequires) {
        int hash = 0;
        int pos = position + this.primaryHash.hashRequires();
        while (0 < hashRequires--) {
            hash <<= 2;
            hash |= this.textBuffer[pos++] & 3;
        }
        return hash;
    }

    private void divide(int dbase, int sbase, int divoff) {
        int limit = this.dictionarySize;
        int position = this.secondaryHashTable[sbase];
        int[] current = new int[]{-1, -1, -1, -1};
        while (limit < position) {
            int shash = this.textBuffer[position + divoff] & 3;
            if (0 < current[shash]) {
                this.prev[current[shash] & this.dictionarySize - 1] = position;
            } else {
                this.dummy[dbase + shash] = position - this.dictionarySize;
            }
            current[shash] = position;
            position = this.prev[position & this.dictionarySize - 1];
        }
        for (int i = 0; i < current.length; ++i) {
            if (0 < current[i]) {
                this.prev[current[i] & this.dictionarySize - 1] = -1;
                continue;
            }
            this.dummy[dbase + i] = -1;
        }
    }

    private void merge(int dbase, int sbase) {
        int limit = this.dictionarySize;
        int position = -1;
        while (true) {
            int shash = 0;
            int max = this.secondaryHashTable[sbase];
            for (int i = 1; i < 4; ++i) {
                if (max >= this.secondaryHashTable[sbase + i]) continue;
                shash = i;
                max = this.secondaryHashTable[sbase + i];
            }
            if (limit >= max) break;
            this.secondaryHashTable[sbase + shash] = this.prev[max & this.dictionarySize - 1];
            if (0 < position) {
                this.prev[position & this.dictionarySize - 1] = max;
            } else {
                this.dummy[dbase] = max - this.dictionarySize;
            }
            position = max;
        }
        if (0 < position) {
            this.prev[position & this.dictionarySize - 1] = -1;
        } else {
            this.dummy[dbase] = -1;
        }
    }
}

