/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.LzssOutputStream;
import com.orangesignal.jlha.LzssSearchMethod;

public class SimpleSearch
implements LzssSearchMethod {
    private int dictionarySize;
    private int maxMatch;
    private int threshold;
    private byte[] textBuffer;
    private int dictionaryLimit;

    public SimpleSearch(int dictionarySize, int maxMatch, int threshold, byte[] textBuffer) {
        this.dictionarySize = dictionarySize;
        this.maxMatch = maxMatch;
        this.threshold = threshold;
        this.textBuffer = textBuffer;
        this.dictionaryLimit = this.dictionarySize;
    }

    @Override
    public void put(int position) {
    }

    @Override
    public int searchAndPut(int position) {
        int matchlen = this.threshold - 1;
        int matchpos = position;
        int scanlimit = Math.max(this.dictionaryLimit, position - this.dictionarySize);
        byte[] buf = this.textBuffer;
        int max = position + this.maxMatch;
        int p = 0;
        int s = 0;
        int len = 0;
        for (int scanpos = position - 1; scanlimit < scanpos; --scanpos) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max > ++p) continue;
            }
            if (matchlen >= (len = p - position)) continue;
            matchpos = scanpos;
            matchlen = len;
            if (this.maxMatch == len) break;
        }
        if (this.threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    @Override
    public int search(int position, int lastPutPos) {
        int matchlen = this.threshold - 1;
        int matchpos = position;
        int scanlimit = Math.max(this.dictionaryLimit, position - this.dictionarySize);
        byte[] buf = this.textBuffer;
        int max = Math.min(position + this.maxMatch, this.textBuffer.length);
        int p = 0;
        int s = 0;
        int len = 0;
        for (int scanpos = position - 1; scanlimit < scanpos; --scanpos) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max > ++p) continue;
            }
            if (matchlen >= (len = p - position)) continue;
            matchpos = scanpos;
            matchlen = len;
            if (this.maxMatch == len) break;
        }
        if (this.threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    @Override
    public void slide() {
        this.dictionaryLimit = Math.max(0, this.dictionaryLimit - this.dictionarySize);
    }

    @Override
    public int putRequires() {
        return 0;
    }
}

