/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.BitDataBrokenException;
import com.orangesignal.jlha.BitInputStream;
import com.orangesignal.jlha.DynamicHuffman;
import com.orangesignal.jlha.PreLzssDecoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class PreLh2Decoder
implements PreLzssDecoder {
    private static final int DICTIONARY_SIZE = 8192;
    private static final int MAX_MATCH = 256;
    private static final int THRESHOLD = 3;
    private static final int CODE_SIZE = 286;
    private BitInputStream in;
    private DynamicHuffman codeHuffman;
    private DynamicHuffman offHiHuffman;
    private int position;
    private int nextPosition;
    private int matchLength;
    private DynamicHuffman markCodeHuffman;
    private DynamicHuffman markOffHiHuffman;
    private int markPosition;
    private int markNextPosition;
    private int markMatchLength;

    public PreLh2Decoder(InputStream in) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        this.in = in instanceof BitInputStream ? (BitInputStream)in : new BitInputStream(in);
        this.codeHuffman = new DynamicHuffman(286);
        this.offHiHuffman = new DynamicHuffman(128, 1);
        this.position = 0;
        this.nextPosition = 64;
        this.matchLength = 0;
    }

    @Override
    public int readCode() throws IOException {
        int CodeMax = 285;
        int node = this.codeHuffman.childNode(0);
        while (0 <= node) {
            node = this.codeHuffman.childNode(node - (this.in.readBoolean() ? 1 : 0));
        }
        int code = ~node;
        this.codeHuffman.update(code);
        if (code < 256) {
            ++this.position;
        } else {
            block6: {
                if (code == 285) {
                    try {
                        code += this.in.readBits(8);
                    }
                    catch (BitDataBrokenException exception) {
                        if (!(exception.getCause() instanceof EOFException)) break block6;
                        throw (EOFException)exception.getCause();
                    }
                }
            }
            this.matchLength = code - 256 + 3;
        }
        return code;
    }

    @Override
    public int readOffset() throws IOException {
        if (this.nextPosition < 8192) {
            while (this.nextPosition < this.position) {
                this.offHiHuffman.addLeaf(this.nextPosition >> 6);
                this.nextPosition += 64;
                if (8192 > this.nextPosition) continue;
            }
        }
        this.position += this.matchLength;
        int node = this.offHiHuffman.childNode(0);
        while (0 <= node) {
            node = this.offHiHuffman.childNode(node - (this.in.readBoolean() ? 1 : 0));
        }
        int offHi = ~node;
        this.offHiHuffman.update(offHi);
        return offHi << 6 | this.in.readBits(6);
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit * 18 / 8 + 4);
        this.markCodeHuffman = (DynamicHuffman)this.codeHuffman.clone();
        this.markOffHiHuffman = (DynamicHuffman)this.offHiHuffman.clone();
        this.markPosition = this.position;
        this.markNextPosition = this.nextPosition;
        this.markMatchLength = this.matchLength;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.codeHuffman = (DynamicHuffman)this.markCodeHuffman.clone();
        this.offHiHuffman = (DynamicHuffman)this.markOffHiHuffman.clone();
        this.position = this.markPosition;
        this.nextPosition = this.markNextPosition;
        this.matchLength = this.markMatchLength;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int available() throws IOException {
        return Math.max(this.in.availableBits() / 18 - 4, 0);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.codeHuffman = null;
        this.offHiHuffman = null;
        this.markCodeHuffman = null;
        this.markOffHiHuffman = null;
    }

    @Override
    public int getDictionarySize() {
        return 8192;
    }

    @Override
    public int getMaxMatch() {
        return 256;
    }

    @Override
    public int getThreshold() {
        return 3;
    }
}

