/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.Factory;
import com.orangesignal.jlha.HashAndChainedListSearch;
import com.orangesignal.jlha.LzssSearchMethod;
import com.orangesignal.jlha.PostLzssEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;

public class LzssOutputStream
extends OutputStream {
    private static final int NEEDSEARCH = 0;
    public static final int NOMATCH = -1;
    private PostLzssEncoder encoder;
    private int dictionarySize;
    private int threshold;
    private int maxMatch;
    private byte[] textBuffer;
    private int dictionaryLimit;
    private int writtenPos;
    private int putPos;
    private int searchPos;
    private int lastsearchret;
    private LzssSearchMethod method;

    public LzssOutputStream(PostLzssEncoder encoder) {
        this(encoder, HashAndChainedListSearch.class.getName(), new Object[0]);
    }

    public LzssOutputStream(PostLzssEncoder encoder, String LzssSearchMethodClassName) {
        this(encoder, LzssSearchMethodClassName, new Object[0]);
    }

    public LzssOutputStream(PostLzssEncoder encoder, String LzssSearchMethodClassName, Object[] LzssSearchMethodExtraArguments) {
        this.dictionarySize = encoder.getDictionarySize();
        this.maxMatch = encoder.getMaxMatch();
        this.threshold = encoder.getThreshold();
        this.encoder = encoder;
        this.textBuffer = new byte[this.dictionarySize * 2 + this.maxMatch];
        this.writtenPos = this.dictionarySize;
        this.putPos = this.dictionarySize;
        this.searchPos = this.dictionarySize;
        this.dictionaryLimit = this.dictionarySize;
        this.lastsearchret = 0;
        Object[] arguments = new Object[LzssSearchMethodExtraArguments.length + 4];
        arguments[0] = new Integer(this.dictionarySize);
        arguments[1] = new Integer(this.maxMatch);
        arguments[2] = new Integer(this.threshold);
        arguments[3] = this.textBuffer;
        for (int i = 0; i < LzssSearchMethodExtraArguments.length; ++i) {
            arguments[4 + i] = LzssSearchMethodExtraArguments[i];
        }
        try {
            this.method = (LzssSearchMethod)Factory.createInstance(LzssSearchMethodClassName, arguments);
        }
        catch (ClassNotFoundException exception) {
            throw new NoClassDefFoundError(exception.getMessage());
        }
        catch (InvocationTargetException exception) {
            throw new Error(exception.getTargetException().getMessage());
        }
        catch (NoSuchMethodException exception) {
            throw new NoSuchMethodError(exception.getMessage());
        }
        catch (InstantiationException exception) {
            throw new InstantiationError(exception.getMessage());
        }
    }

    @Override
    public void write(int data) throws IOException {
        this.textBuffer[this.writtenPos++] = (byte)data;
        if (this.textBuffer.length <= this.writtenPos) {
            this.encode(false);
            this.slide();
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int index, int length) throws IOException {
        int pos = index;
        int end = index + length;
        while (pos < end) {
            int space = this.textBuffer.length - this.writtenPos;
            if (end - pos < space) {
                System.arraycopy(buffer, pos, this.textBuffer, this.writtenPos, end - pos);
                this.writtenPos += end - pos;
                pos = end;
                continue;
            }
            System.arraycopy(buffer, pos, this.textBuffer, this.writtenPos, space);
            this.writtenPos += space;
            pos += space;
            this.encode(false);
            this.slide();
        }
    }

    @Override
    public void flush() throws IOException {
        this.encode(false);
        if (this.dictionarySize * 2 <= this.putPos) {
            this.slide();
            if (this.searchPos < this.writtenPos) {
                this.encode(false);
            }
        }
        this.encoder.flush();
    }

    @Override
    public void close() throws IOException {
        while (this.dictionarySize <= this.writtenPos) {
            this.encode(true);
            if (this.writtenPos <= this.searchPos) break;
            this.slide();
        }
        this.encoder.close();
        this.encoder = null;
        this.textBuffer = null;
        this.method = null;
    }

    private void encode(boolean last) throws IOException {
        int lastmatchoff;
        int lastmatchlen;
        int matchpos;
        int matchlen;
        int searchret;
        int end;
        block18: {
            end = Math.min(this.textBuffer.length - this.maxMatch, this.writtenPos - (last ? 0 : this.method.putRequires()));
            if (this.searchPos < end) {
                if (this.lastsearchret == 0) {
                    while (this.putPos < this.searchPos - 1) {
                        this.method.put(++this.putPos);
                        if (this.dictionarySize * 2 > this.putPos) continue;
                        return;
                    }
                    this.lastsearchret = this.method.searchAndPut(this.searchPos);
                }
                searchret = this.lastsearchret;
                matchlen = LzssOutputStream.getMatchLen(searchret);
                matchpos = LzssOutputStream.getMatchPos(searchret);
                if (this.writtenPos - this.searchPos < matchlen) {
                    matchlen = this.writtenPos - this.searchPos;
                }
                while (true) {
                    lastmatchlen = matchlen;
                    lastmatchoff = this.searchPos - matchpos - 1;
                    searchret = this.method.searchAndPut(++this.searchPos);
                    matchlen = LzssOutputStream.getMatchLen(searchret);
                    matchpos = LzssOutputStream.getMatchPos(searchret);
                    if (this.writtenPos - this.searchPos < matchlen) {
                        matchlen = this.writtenPos - this.searchPos;
                    }
                    if (lastmatchlen < matchlen || lastmatchlen < this.threshold) {
                        this.encoder.writeCode(0xFF & this.textBuffer[this.searchPos - 1]);
                        if (end > this.searchPos) continue;
                        this.putPos = this.searchPos;
                        this.lastsearchret = searchret;
                        break block18;
                    }
                    this.encoder.writeCode(256 + lastmatchlen - this.threshold);
                    this.encoder.writeOffset(lastmatchoff);
                    if (this.searchPos + --lastmatchlen >= end) break;
                    while (0 < --lastmatchlen) {
                        this.method.put(++this.searchPos);
                    }
                    searchret = this.method.searchAndPut(++this.searchPos);
                    matchlen = LzssOutputStream.getMatchLen(searchret);
                    matchpos = LzssOutputStream.getMatchPos(searchret);
                    if (this.writtenPos - this.searchPos >= matchlen) continue;
                    matchlen = this.writtenPos - this.searchPos;
                }
                if (end < this.searchPos + lastmatchlen) {
                    this.putPos = this.searchPos;
                    while (this.putPos < end) {
                        this.method.put(++this.putPos);
                    }
                    this.searchPos += lastmatchlen;
                    this.lastsearchret = 0;
                } else {
                    this.putPos = this.searchPos;
                    while (this.putPos < end - 1) {
                        this.method.put(++this.putPos);
                    }
                    ++this.putPos;
                    this.searchPos += lastmatchlen;
                    this.lastsearchret = this.method.searchAndPut(this.searchPos);
                }
            }
        }
        end = Math.min(this.textBuffer.length - this.maxMatch, this.writtenPos);
        if (!last && this.searchPos < end) {
            if (this.lastsearchret == 0) {
                this.lastsearchret = this.method.search(this.searchPos, this.putPos);
            }
            searchret = this.lastsearchret;
            matchlen = LzssOutputStream.getMatchLen(searchret);
            matchpos = LzssOutputStream.getMatchPos(searchret);
            if (this.writtenPos - this.searchPos < matchlen) {
                matchlen = this.writtenPos - this.searchPos;
            }
            while (this.searchPos < end) {
                lastmatchlen = matchlen;
                lastmatchoff = this.searchPos - matchpos - 1;
                searchret = this.method.search(++this.searchPos, this.putPos);
                matchlen = LzssOutputStream.getMatchLen(searchret);
                matchpos = LzssOutputStream.getMatchPos(searchret);
                if (this.writtenPos - this.searchPos < matchlen) {
                    matchlen = this.writtenPos - this.searchPos;
                }
                if (lastmatchlen < matchlen || lastmatchlen < this.threshold) {
                    this.encoder.writeCode(0xFF & this.textBuffer[this.searchPos - 1]);
                    continue;
                }
                this.encoder.writeCode(256 + lastmatchlen - this.threshold);
                this.encoder.writeOffset(lastmatchoff);
                this.searchPos += lastmatchlen - 1;
                searchret = this.method.search(this.searchPos, this.putPos);
                matchlen = LzssOutputStream.getMatchLen(searchret);
                matchpos = LzssOutputStream.getMatchPos(searchret);
                if (this.writtenPos - this.searchPos >= matchlen) continue;
                matchlen = this.writtenPos - this.searchPos;
            }
            this.lastsearchret = 0;
        }
    }

    private void slide() {
        this.dictionaryLimit = Math.max(0, this.dictionaryLimit - this.dictionarySize);
        this.method.slide();
        if (this.lastsearchret != 0) {
            int matchlen = LzssOutputStream.getMatchLen(this.lastsearchret);
            int matchpos = LzssOutputStream.getMatchPos(this.lastsearchret);
            this.lastsearchret = LzssOutputStream.createSearchReturn(matchlen, matchpos - this.dictionarySize);
        }
        this.writtenPos -= this.dictionarySize;
        this.searchPos -= this.dictionarySize;
        this.putPos -= this.dictionarySize;
        for (int i = this.dictionaryLimit; i < this.writtenPos; ++i) {
            this.textBuffer[i] = this.textBuffer[i + this.dictionarySize];
        }
    }

    public static final int createSearchReturn(int matchlen, int matchpos) {
        return matchlen << 22 | matchpos;
    }

    public static final int getMatchLen(int searchret) {
        return searchret >> 22;
    }

    public static final int getMatchPos(int searchret) {
        if (0 <= searchret) {
            return searchret & 0x3FFFFF;
        }
        return -1;
    }
}

