/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class LittleEndian {
    private LittleEndian() {
    }

    public static final int readShort(byte[] ByteArray, int index) {
        return ByteArray[index] & 0xFF | (ByteArray[index + 1] & 0xFF) << 8;
    }

    public static final int readInt(byte[] ByteArray, int index) {
        return ByteArray[index] & 0xFF | (ByteArray[index + 1] & 0xFF) << 8 | (ByteArray[index + 2] & 0xFF) << 16 | ByteArray[index + 3] << 24;
    }

    public static final long readLong(byte[] ByteArray, int index) {
        return (long)LittleEndian.readInt(ByteArray, index) & 0xFFFFFFFFL | (long)LittleEndian.readInt(ByteArray, index + 4) << 32;
    }

    public static final int readShort(InputStream in) throws IOException {
        int byte1 = in.read();
        int byte2 = in.read();
        if (0 <= byte1 && 0 <= byte2) {
            return byte1 & 0xFF | (byte2 & 0xFF) << 8;
        }
        throw new EOFException();
    }

    public static final int readInt(InputStream in) throws IOException {
        int byte1 = in.read();
        int byte2 = in.read();
        int byte3 = in.read();
        int byte4 = in.read();
        if (0 <= byte1 && 0 <= byte2 && 0 <= byte3 && 0 <= byte4) {
            return byte1 & 0xFF | (byte2 & 0xFF) << 8 | (byte3 & 0xFF) << 16 | byte4 << 24;
        }
        throw new EOFException();
    }

    public static final long readLong(InputStream in) throws IOException {
        return (long)LittleEndian.readInt(in) & 0xFFFFFFFFL | (long)LittleEndian.readInt(in) << 32;
    }

    public static final void writeShort(byte[] bytes, int index, int value) {
        if (0 > index || index + 1 >= bytes.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        bytes[index] = (byte)value;
        bytes[index + 1] = (byte)(value >> 8);
    }

    public static final void writeInt(byte[] bytes, int index, int value) {
        if (0 > index || index + 3 >= bytes.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        bytes[index] = (byte)value;
        bytes[index + 1] = (byte)(value >> 8);
        bytes[index + 2] = (byte)(value >> 16);
        bytes[index + 3] = (byte)(value >> 24);
    }

    public static final void writeLong(byte[] bytes, int index, long value) {
        if (0 > index || index + 7 >= bytes.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        LittleEndian.writeInt(bytes, index, (int)value);
        LittleEndian.writeInt(bytes, index + 4, (int)(value >> 32));
    }

    public static final void writeShort(OutputStream out, int value) throws IOException {
        out.write(value & 0xFF);
        out.write(value >> 8 & 0xFF);
    }

    public static final void writeInt(OutputStream out, int value) throws IOException {
        out.write(value & 0xFF);
        out.write(value >> 8 & 0xFF);
        out.write(value >> 16 & 0xFF);
        out.write(value >>> 24);
    }

    public static final void writeLong(OutputStream out, long value) throws IOException {
        int low = (int)value;
        int hi = (int)(value >> 32);
        out.write(low & 0xFF);
        out.write(low >> 8 & 0xFF);
        out.write(low >> 16 & 0xFF);
        out.write(low >>> 24);
        out.write(hi & 0xFF);
        out.write(hi >> 8 & 0xFF);
        out.write(hi >> 16 & 0xFF);
        out.write(hi >>> 24);
    }
}

