/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.CRC16;
import com.orangesignal.jlha.CompressMethod;
import com.orangesignal.jlha.LhaHeader;
import com.orangesignal.jlha.LhaProperty;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Properties;
import java.util.Vector;

public class LhaRetainedOutputStream
extends OutputStream {
    private RandomAccessFile archive;
    private OutputStream out;
    private RandomAccessFileOutputStream rafo;
    private LhaHeader header;
    private String encoding;
    private long headerpos;
    private CRC16 crc;
    private Properties property;

    public LhaRetainedOutputStream(String filename) throws FileNotFoundException {
        if (filename == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        Properties property = LhaProperty.getProperties();
        this.constructerHelper(file, property);
    }

    public LhaRetainedOutputStream(String filename, Properties property) throws FileNotFoundException {
        if (filename == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        this.constructerHelper(file, property);
    }

    public LhaRetainedOutputStream(File filename) throws IOException {
        if (filename == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        Properties property = LhaProperty.getProperties();
        this.constructerHelper(file, property);
    }

    public LhaRetainedOutputStream(File filename, Properties property) throws IOException {
        if (filename == null) {
            throw new NullPointerException("filename");
        }
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        this.constructerHelper(file, property);
    }

    public LhaRetainedOutputStream(RandomAccessFile file) {
        if (file == null) {
            throw new NullPointerException("out");
        }
        Properties property = LhaProperty.getProperties();
        this.constructerHelper(file, property);
    }

    public LhaRetainedOutputStream(RandomAccessFile file, Properties property) {
        if (file == null || property == null) {
            if (file == null) {
                throw new NullPointerException("null");
            }
            throw new NullPointerException("property");
        }
        this.constructerHelper(file, property);
    }

    private void constructerHelper(RandomAccessFile file, Properties property) {
        this.archive = file;
        this.out = null;
        this.header = null;
        this.headerpos = -1L;
        this.crc = new CRC16();
        this.property = property;
    }

    @Override
    public void write(int data) throws IOException {
        if (this.out != null) {
            if (this.header != null) {
                this.crc.update(data);
            }
        } else {
            throw new IOException("no entry");
        }
        this.out.write(data);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int index, int length) throws IOException {
        if (this.out != null) {
            if (this.header != null) {
                this.crc.update(buffer, index, length);
            }
        } else {
            throw new IOException("no entry");
        }
        this.out.write(buffer, index, length);
    }

    @Override
    public void flush() throws IOException {
        if (this.out == null) {
            throw new IOException("no entry");
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.closeEntry();
        }
        this.archive.write(0);
        try {
            this.archive.setLength(this.archive.getFilePointer());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.archive.close();
        this.archive = null;
        this.header = null;
        this.crc = null;
        this.property = null;
        this.rafo = null;
    }

    public void putNextEntry(LhaHeader header) throws IOException {
        if (header.getCompressedSize() == -1L || header.getCrc() == -1) {
            this.putNextEntryNotYetCompressed(header);
        } else {
            this.putNextEntryAlreadyCompressed(header);
        }
    }

    public void putNextEntryAlreadyCompressed(LhaHeader header) throws IOException {
        if (header.getOriginalSize() != -1L && header.getCompressedSize() != -1L && header.getCrc() != -1) {
            if (this.out != null) {
                this.closeEntry();
            }
            this.headerpos = this.archive.getFilePointer();
            this.encoding = this.property.getProperty("lha.encoding");
            if (this.encoding == null) {
                this.encoding = LhaProperty.getProperty("lha.encoding");
            }
        } else {
            if (header.getOriginalSize() == -1L) {
                throw new IllegalArgumentException("OriginalSize must not \"LhaHeader.UNKNOWN\".");
            }
            if (header.getCompressedSize() == -1L) {
                throw new IllegalArgumentException("CompressedSize must not \"LhaHeader.UNKNOWN\".");
            }
            throw new IllegalArgumentException("CRC must not \"LhaHeader.UNKNOWN\".");
        }
        this.archive.write(header.getBytes(this.encoding));
        this.out = new RandomAccessFileOutputStream(this.archive, header.getCompressedSize());
    }

    public void putNextEntryNotYetCompressed(LhaHeader header) throws IOException {
        if (header.getOriginalSize() != -1L) {
            if (this.out != null) {
                this.closeEntry();
            }
            this.crc.reset();
            this.headerpos = this.archive.getFilePointer();
            this.header = (LhaHeader)header.clone();
            this.header.setCompressedSize(0L);
            this.header.setCrc(0);
            this.encoding = this.property.getProperty("lha.encoding");
            if (this.encoding == null) {
                this.encoding = LhaProperty.getProperty("lha.encoding");
            }
        } else {
            throw new IllegalArgumentException("OriginalSize must not \"LhaHeader.UNKNOWN\".");
        }
        this.archive.write(this.header.getBytes(this.encoding));
        this.rafo = new RandomAccessFileOutputStream(this.archive, header.getOriginalSize());
        this.out = CompressMethod.connectEncoder(this.rafo, header.getCompressMethod(), this.property);
    }

    public void closeEntry() throws IOException {
        if (this.header != null) {
            this.out.close();
            if (!this.rafo.cache.isEmpty()) {
                int length;
                long pos = this.rafo.start;
                RandomAccessFileInputStream rafi = new RandomAccessFileInputStream(this.archive, this.rafo);
                InputStream in = CompressMethod.connectDecoder(rafi, this.header.getCompressMethod(), this.property, this.header.getOriginalSize());
                byte[] buffer = new byte[8192];
                while (0 <= (length = in.read(buffer))) {
                    rafi.cache(pos + (long)length);
                    this.archive.seek(pos);
                    this.archive.write(buffer, 0, length);
                    pos += (long)length;
                }
                in.close();
                this.header.setCompressMethod("-lh0-");
            }
            long pos = this.archive.getFilePointer();
            long size = pos - this.headerpos - (long)this.header.getBytes(this.encoding).length;
            this.header.setCompressedSize(size);
            if (this.header.getCrc() != -2) {
                this.header.setCrc((int)this.crc.getValue());
            }
            this.archive.seek(this.headerpos);
            this.archive.write(this.header.getBytes(this.encoding));
            this.archive.seek(pos);
        }
        this.header = null;
        this.out = null;
    }

    private static class Cache {
        private final Vector<byte[]> cache = new Vector();
        private byte[] current = null;
        private int position = 0;

        public int read() {
            if (null != this.current) {
                int ret = this.current[this.position++] & 0xFF;
                if (this.current.length <= this.position) {
                    if (0 < this.cache.size()) {
                        this.current = this.cache.firstElement();
                        this.cache.removeElementAt(0);
                    } else {
                        this.current = null;
                    }
                    this.position = 0;
                }
                return ret;
            }
            return -1;
        }

        public int read(byte[] buffer, int index, int length) {
            int count = 0;
            while (null != this.current && count < length) {
                int copylen = Math.min(this.current.length - this.position, length - count);
                System.arraycopy(this.current, this.position, buffer, index + count, copylen);
                this.position += copylen;
                count += copylen;
                if (this.current.length > this.position) continue;
                if (0 < this.cache.size()) {
                    this.current = this.cache.firstElement();
                    this.cache.removeElementAt(0);
                } else {
                    this.current = null;
                }
                this.position = 0;
            }
            if (count == 0) {
                return -1;
            }
            return count;
        }

        public void add(byte[] buffer) {
            if (this.current == null) {
                this.current = buffer;
            } else {
                this.cache.addElement(buffer);
            }
        }

        public void add(byte[] buffer, int index, int length) {
            byte[] buf = new byte[length];
            System.arraycopy(buffer, index, buf, 0, length);
            if (this.current == null) {
                this.current = buf;
            } else {
                this.cache.addElement(buf);
            }
        }

        public boolean isEmpty() {
            return this.current == null;
        }
    }

    private static class RandomAccessFileInputStream
    extends InputStream {
        private RandomAccessFile archive;
        private Cache front;
        private Cache rear;
        private long pos;
        private final long limit;

        public RandomAccessFileInputStream(RandomAccessFile archive, RandomAccessFileOutputStream out) {
            this.archive = archive;
            this.pos = out.start;
            this.limit = out.pos;
            this.front = new Cache();
            this.rear = out.cache;
        }

        @Override
        public int read() throws IOException {
            int return_value = this.front.read();
            if (return_value < 0) {
                if (this.pos < this.limit) {
                    this.archive.seek(this.pos++);
                    return_value = this.archive.read();
                } else {
                    return_value = this.rear.read();
                }
            }
            return return_value;
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public int read(byte[] buffer, int index, int length) throws IOException {
            int count = 0;
            int ret = this.front.read(buffer, index, length);
            if (0 <= ret) {
                count += ret;
            }
            this.archive.seek(this.pos);
            ret = Math.min(length - count, Math.max((int)(this.limit - this.pos), 0));
            this.archive.readFully(buffer, index + count, ret);
            if (0 <= ret) {
                this.pos += (long)ret;
                count += ret;
            }
            if (0 <= (ret = this.rear.read(buffer, index + count, length - count))) {
                count += ret;
            }
            if (0 < count) {
                return count;
            }
            return -1;
        }

        @Override
        public void close() {
            this.front = null;
            this.rear = null;
            this.archive = null;
        }

        public void cache(long pos) throws IOException {
            int length = (int)Math.min(this.limit - this.pos, pos - this.pos);
            byte[] buffer = new byte[length];
            if (0 < length) {
                this.archive.seek(this.pos);
                this.archive.readFully(buffer);
                this.front.add(buffer);
                this.pos += (long)length;
            }
        }
    }

    private static class RandomAccessFileOutputStream
    extends OutputStream {
        private RandomAccessFile archive;
        private final Cache cache;
        private final long start;
        private long pos;
        private final long limit;

        public RandomAccessFileOutputStream(RandomAccessFile archive, long length) throws IOException {
            this.archive = archive;
            this.pos = this.start = this.archive.getFilePointer();
            this.limit = this.start + length;
            this.cache = new Cache();
        }

        @Override
        public void write(int data) throws IOException {
            if (this.pos < this.limit && this.cache.isEmpty()) {
                ++this.pos;
                this.archive.write(data);
            } else {
                this.cache.add(new byte[]{(byte)data});
            }
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void write(byte[] buffer, int index, int length) throws IOException {
            if (this.pos + (long)length < this.limit && this.cache.isEmpty()) {
                this.pos += (long)length;
                this.archive.write(buffer, index, length);
            } else {
                this.cache.add(buffer, index, length);
            }
        }

        @Override
        public void close() {
            this.archive = null;
        }
    }
}

