/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.Factory;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;

final class LhaProperty {
    public static final String ENCODING;
    private static final Properties properties;

    private LhaProperty() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getProperty(String key) {
        String def = properties.getProperty(key);
        if (!key.equals("lha.encoding") || !System.getProperty(key, def).equals("ShiftJISAuto")) return System.getProperty(key, def);
        try {
            String encoding = System.getProperty("file.encoding");
            if (!LhaProperty.isCategoryOfShiftJIS(encoding)) return "SJIS";
            return encoding;
        }
        catch (SecurityException exception) {
            try {
                return "SJIS";
            }
            catch (SecurityException securityException) {
                return def;
            }
        }
    }

    static Properties getProperties() {
        Properties property = (Properties)properties.clone();
        Enumeration<?> enumkey = property.propertyNames();
        while (enumkey.hasMoreElements()) {
            String key = (String)enumkey.nextElement();
            try {
                String val = System.getProperty(key);
                if (null == val) continue;
                property.put(key, val);
            }
            catch (SecurityException securityException) {}
        }
        if (property.getProperty("lha.encoding").equals("ShiftJISAuto")) {
            try {
                String encoding = System.getProperty("file.encoding");
                if (LhaProperty.isCategoryOfShiftJIS(encoding)) {
                    property.put("lha.encoding", encoding);
                } else {
                    property.put("lha.encoding", "SJIS");
                }
            }
            catch (SecurityException exception) {
                property.put("lha.encoding", "SJIS");
            }
        }
        return property;
    }

    static Object parse(String source, Hashtable<String, Object> substitute, String packages) {
        StringTokenizer tokenizer = new StringTokenizer(packages, ",");
        String[] packageArray = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            packageArray[i++] = tokenizer.nextToken().trim();
        }
        return LhaProperty.parse(source, substitute, packageArray);
    }

    private static Object parse(String source, Hashtable<String, Object> substitute, String[] packages) {
        source = source.trim();
        int casearcpos = source.indexOf("(");
        int bracepos = source.indexOf("[");
        if (0 <= casearcpos && (bracepos < 0 || casearcpos < bracepos)) {
            return LhaProperty.parseConstructor(source, substitute, packages);
        }
        if (0 <= bracepos && (casearcpos < 0 || bracepos < casearcpos)) {
            return LhaProperty.parseArray(source, substitute, packages);
        }
        if (substitute.containsKey(source)) {
            return substitute.get(source);
        }
        return LhaProperty.applyPackages(source, packages);
    }

    private static Object parseConstructor(String source, Hashtable<String, Object> substitute, String[] packages) {
        Object[] args;
        String classname = source.substring(0, source.indexOf(40)).trim();
        String arguments = source.substring(source.indexOf(40) + 1, source.lastIndexOf(41)).trim();
        classname = LhaProperty.applyPackages(classname, packages);
        if (!arguments.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(arguments, ",()[]", true);
            Stack<Object> stack = new Stack<Object>();
            int pos = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("(")) {
                    stack.push("(");
                } else if (token.equals(")")) {
                    if (!stack.empty() && stack.peek().equals("(")) {
                        stack.pop();
                    }
                } else if (token.equals("[")) {
                    stack.push("[");
                } else if (token.equals("]")) {
                    if (!stack.empty() && stack.peek().equals("[")) {
                        stack.pop();
                    }
                } else if (token.equals(",") && (stack.empty() || !stack.peek().equals("(") && !stack.peek().equals("["))) {
                    stack.push(new Integer(pos));
                }
                pos += token.length();
            }
            pos = 0;
            args = new Object[stack.size() + 1];
            for (int i = 0; i < stack.size() + 1; ++i) {
                String arg = i < stack.size() ? arguments.substring(pos, (Integer)stack.elementAt(i)) : arguments.substring(pos);
                pos += arg.length() + 1;
                args[i] = LhaProperty.parse(arg, substitute, packages);
            }
        } else {
            args = new Object[]{};
        }
        try {
            return Factory.createInstance(classname, args);
        }
        catch (InstantiationException exception) {
            throw new InstantiationError(exception.getMessage());
        }
        catch (InvocationTargetException exception) {
            if (exception.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)exception.getTargetException();
            }
            if (exception.getTargetException() instanceof Error) {
                throw (Error)exception.getTargetException();
            }
            throw new Error(exception.getTargetException().getMessage());
        }
        catch (ClassNotFoundException exception) {
            throw new NoClassDefFoundError(exception.getMessage());
        }
        catch (NoSuchMethodException exception) {
            throw new NoSuchMethodError(exception.getMessage());
        }
    }

    private static Object[] parseArray(String source, Hashtable<String, Object> substitute, String[] packages) {
        String arguments = source.substring(source.indexOf(91) + 1, source.lastIndexOf(93)).trim();
        if (!arguments.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(arguments, ",()[]", true);
            Stack<Object> stack = new Stack<Object>();
            int pos = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("(")) {
                    stack.push("(");
                } else if (token.equals(")")) {
                    if (!stack.empty() && stack.peek().equals("(")) {
                        stack.pop();
                    }
                } else if (token.equals("[")) {
                    stack.push("[");
                } else if (token.equals("]")) {
                    if (!stack.empty() && stack.peek().equals("[")) {
                        stack.pop();
                    }
                } else if (token.equals(",") && (stack.empty() || !stack.peek().equals("(") && !stack.peek().equals("["))) {
                    stack.push(new Integer(pos));
                }
                pos += token.length();
            }
            pos = 0;
            Object[] array = new Object[stack.size() + 1];
            for (int i = 0; i < stack.size() + 1; ++i) {
                String arg = i < stack.size() ? arguments.substring(pos, (Integer)stack.elementAt(i)) : arguments.substring(pos);
                pos += arg.length() + 1;
                array[i] = LhaProperty.parse(arg, substitute, packages);
            }
            return array;
        }
        return new Object[0];
    }

    private static String applyPackages(String str, String[] packages) {
        for (String package1 : packages) {
            String classname = package1.equals("") ? str : package1 + "." + str;
            try {
                Class.forName(classname);
                return classname;
            }
            catch (ClassNotFoundException exception) {
            }
            catch (LinkageError error) {
                // empty catch block
            }
        }
        return str;
    }

    private static final Properties createLhaProperty() {
        Properties property = LhaProperty.createDefaultProperty();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("orangesignal-jlha");
            Enumeration<String> enumkey = bundle.getKeys();
            while (enumkey.hasMoreElements()) {
                String key = enumkey.nextElement();
                property.put(key, bundle.getString(key));
            }
        }
        catch (MissingResourceException exception) {
            // empty catch block
        }
        if (property.getProperty("lha.encoding").equals("ShiftJISAuto")) {
            try {
                String encoding = System.getProperty("file.encoding");
                if (LhaProperty.isCategoryOfShiftJIS(encoding)) {
                    property.put("lha.encoding", encoding);
                } else {
                    property.put("lha.encoding", "SJIS");
                }
            }
            catch (SecurityException exception) {
                property.put("lha.encoding", "SJIS");
            }
        }
        return property;
    }

    private static final Properties createDefaultProperty() {
        Properties results = new Properties();
        results.put("lha.encoding", LhaProperty.getSystemEncoding());
        results.put("lha.packages", LhaProperty.class.getPackage().getName());
        results.put("lha.lzs.encoder", "LzssOutputStream( PostLzsEncoder( out ), HashAndChainedListSearch, [ HashShort ] )");
        results.put("lha.lz4.encoder", "out");
        results.put("lha.lz5.encoder", "LzssOutputStream( PostLz5Encoder( out ), HashAndChainedListSearch )");
        results.put("lha.lhd.encoder", "out");
        results.put("lha.lh0.encoder", "out");
        results.put("lha.lh1.encoder", "LzssOutputStream( PostLh1Encoder( out ), HashAndChainedListSearch )");
        results.put("lha.lh2.encoder", "LzssOutputStream( PostLh2Encoder( out ), HashAndChainedListSearch )");
        results.put("lha.lh3.encoder", "LzssOutputStream( PostLh3Encoder( out ), HashAndChainedListSearch )");
        results.put("lha.lh4.encoder", "LzssOutputStream( PostLh5Encoder( out, -lh4- ), HashAndChainedListSearch )");
        results.put("lha.lh5.encoder", "LzssOutputStream( PostLh5Encoder( out, -lh5- ), HashAndChainedListSearch )");
        results.put("lha.lh6.encoder", "LzssOutputStream( PostLh5Encoder( out, -lh6- ), HashAndChainedListSearch )");
        results.put("lha.lh7.encoder", "LzssOutputStream( PostLh5Encoder( out, -lh7- ), HashAndChainedListSearch )");
        results.put("lha.lzs.decoder", "LzssInputStream( PreLzsDecoder( in ), length )");
        results.put("lha.lz4.decoder", "in");
        results.put("lha.lz5.decoder", "LzssInputStream( PreLz5Decoder( in ), length )");
        results.put("lha.lhd.decoder", "in");
        results.put("lha.lh0.decoder", "in");
        results.put("lha.lh1.decoder", "LzssInputStream( PreLh1Decoder( in ), length )");
        results.put("lha.lh2.decoder", "LzssInputStream( PreLh2Decoder( in ), length )");
        results.put("lha.lh3.decoder", "LzssInputStream( PreLh3Decoder( in ), length )");
        results.put("lha.lh4.decoder", "LzssInputStream( PreLh5Decoder( in, -lh4- ), length )");
        results.put("lha.lh5.decoder", "LzssInputStream( PreLh5Decoder( in, -lh5- ), length )");
        results.put("lha.lh6.decoder", "LzssInputStream( PreLh5Decoder( in, -lh6- ), length )");
        results.put("lha.lh7.decoder", "LzssInputStream( PreLh5Decoder( in, -lh7- ), length )");
        results.put("lha.header", "LhaHeader( data, encoding )");
        return results;
    }

    private static final String getSystemEncoding() {
        try {
            String encoding = System.getProperty("file.encoding");
            if (LhaProperty.isJapanese(encoding) && !LhaProperty.isCategoryOfShiftJIS(encoding)) {
                return "SJIS";
            }
            return encoding;
        }
        catch (SecurityException exception) {
            String encoding = "ISO8859_1";
            return encoding;
        }
    }

    private static final boolean isJapanese(String encoding) {
        String[] Aliases;
        String[] Coverters;
        for (String coverter : Coverters = new String[]{"Cp930", "Cp939", "Cp942", "Cp942C", "Cp943", "Cp943C", "Cp33722", "MS932", "SJIS", "EUC_JP", "ISO2022JP", "JIS0201", "JIS0208", "JIS0212", "JISAutoDetect"}) {
            if (!encoding.equals(coverter)) continue;
            return true;
        }
        for (String aliase : Aliases = new String[]{"eucjis", "euc-jp", "eucjp", "x-euc-jp", "x-eucjp", "csEUCPkdFmtJapanese", "extended_unix_code_packed_format_for_japanese ", "shift_jis", "ms_kanji", "csShiftJIS", "csWindows31J", "windows-31j", "x-sjis", "jis", "iso-2022-jp", "csISO2022JP", "jis_encoding", "csJISEncoding", "jis auto detect", "cp930", "ibm-930", "ibm930", "930", "cp939", "ibm-939", "ibm939", "939", "cp942", "ibm-942", "ibm942", "942", "cp942c", "cp943", "ibm-943", "ibm943", "943", "cp943c", "cp33722", "ibm-33722", "ibm33722", "33722"}) {
            if (!encoding.equalsIgnoreCase(aliase)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isCategoryOfShiftJIS(String encoding) {
        String[] Aliases;
        String[] Coverters;
        for (String coverter : Coverters = new String[]{"Cp942", "Cp942C", "Cp943", "Cp943C", "MS932", "SJIS"}) {
            if (!encoding.equals(coverter)) continue;
            return true;
        }
        for (String aliase : Aliases = new String[]{"shift_jis", "ms_kanji", "csShiftJIS", "csWindows31J", "windows-31j", "x-sjis", "cp942", "ibm-942", "ibm942", "942", "cp942c", "cp943", "ibm-943", "ibm943", "943", "cp943c"}) {
            if (!encoding.equalsIgnoreCase(aliase)) continue;
            return true;
        }
        return false;
    }

    static {
        properties = LhaProperty.createLhaProperty();
        ENCODING = properties.getProperty("lha.encoding");
    }
}

