/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.Factory;
import com.orangesignal.jlha.HashDefault;
import com.orangesignal.jlha.HashMethod;
import com.orangesignal.jlha.LzssOutputStream;
import com.orangesignal.jlha.LzssSearchMethod;
import java.lang.reflect.InvocationTargetException;

public class HashAndChainedListSearch
implements LzssSearchMethod {
    private int dictionarySize;
    private int maxMatch;
    private int threshold;
    private byte[] textBuffer;
    private int dictionaryLimit;
    private HashMethod hashMethod;
    private int[] hashTable;
    private char[] tooBigFlag;
    private int[] prev;
    private int searchLimitCount;

    public HashAndChainedListSearch(int dictionarySize, int maxMatch, int threshold, byte[] textBuffer) {
        this(dictionarySize, maxMatch, threshold, textBuffer, HashDefault.class.getName(), 256);
    }

    public HashAndChainedListSearch(int dictionarySize, int maxMatch, int threshold, byte[] textBuffer, int searchLimitCount) {
        this(dictionarySize, maxMatch, threshold, textBuffer, HashDefault.class.getName(), searchLimitCount);
    }

    public HashAndChainedListSearch(int dictionarySize, int maxMatch, int threshold, byte[] textBuffer, String hashMethodClassName) {
        this(dictionarySize, maxMatch, threshold, textBuffer, hashMethodClassName, 256);
    }

    public HashAndChainedListSearch(int dictionarySize, int maxMatch, int threshold, byte[] textBuffer, String HashMethodClassName, int SearchLimitCount) {
        if (0 < SearchLimitCount) {
            int i;
            this.dictionarySize = dictionarySize;
            this.maxMatch = maxMatch;
            this.threshold = threshold;
            this.textBuffer = textBuffer;
            this.dictionaryLimit = this.dictionarySize;
            this.searchLimitCount = SearchLimitCount;
            try {
                this.hashMethod = (HashMethod)Factory.createInstance(HashMethodClassName, new Object[]{textBuffer});
            }
            catch (ClassNotFoundException exception) {
                throw new NoClassDefFoundError(exception.getMessage());
            }
            catch (InvocationTargetException exception) {
                throw new Error(exception.getTargetException().getMessage());
            }
            catch (NoSuchMethodException exception) {
                throw new NoSuchMethodError(exception.getMessage());
            }
            catch (InstantiationException exception) {
                throw new InstantiationError(exception.getMessage());
            }
            this.hashTable = new int[this.hashMethod.tableSize()];
            for (i = 0; i < this.hashTable.length; ++i) {
                this.hashTable[i] = -1;
            }
            this.prev = new int[this.dictionarySize];
            for (i = 0; i < this.prev.length; ++i) {
                this.prev[i] = -1;
            }
        } else {
            throw new IllegalArgumentException("SearchLimitCount must be 1 or more.");
        }
        this.tooBigFlag = new char[this.hashMethod.tableSize() >> 4];
    }

    @Override
    public void put(int position) {
        int hash = this.hashMethod.hash(position);
        this.prev[position & this.dictionarySize - 1] = this.hashTable[hash];
        this.hashTable[hash] = position;
    }

    @Override
    public int searchAndPut(int position) {
        int poshash;
        int matchlen = this.threshold - 1;
        int matchpos = position;
        int maxmatch = this.maxMatch;
        int scanlimit = Math.max(this.dictionaryLimit, position - this.dictionarySize);
        int offhash = poshash = this.hashMethod.hash(position);
        int offset = 0;
        while (this.isTooBig(offhash) && offset < this.maxMatch - this.hashMethod.hashRequires()) {
            offhash = this.hashMethod.hash(position + ++offset);
        }
        byte[] buf = this.textBuffer;
        int max = position + this.maxMatch;
        int s = 0;
        int p = 0;
        int len = 0;
        while (true) {
            int scanpos = this.hashTable[offhash];
            int searchCount = this.searchLimitCount;
            while (scanlimit <= scanpos - offset && 0 < --searchCount) {
                if (buf[scanpos + matchlen - offset] == buf[position + matchlen]) {
                    s = scanpos - offset;
                    p = position;
                    while (buf[s] == buf[p]) {
                        ++s;
                        if (max > ++p) continue;
                    }
                    if (matchlen < (len = p - position)) {
                        matchpos = scanpos - offset;
                        matchlen = len;
                        if (max <= p) break;
                    }
                }
                scanpos = this.prev[scanpos & this.dictionarySize - 1];
            }
            if (searchCount <= 0) {
                this.setTooBigFlag(offhash);
            } else if (scanpos < scanlimit) {
                this.clearTooBigFlag(offhash);
            }
            if (0 >= offset || matchlen >= this.hashMethod.hashRequires() + offset) break;
            offset = 0;
            maxmatch = this.hashMethod.hashRequires() + offset - 1;
            max = position + maxmatch;
            offhash = poshash;
        }
        this.prev[position & this.dictionarySize - 1] = this.hashTable[poshash];
        this.hashTable[poshash] = position;
        if (this.threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    @Override
    public int search(int position, int lastPutPos) {
        int scanpos;
        int matchlen = this.threshold - 1;
        int matchpos = position;
        int scanlimit = Math.max(this.dictionaryLimit, lastPutPos);
        byte[] buf = this.textBuffer;
        int max = Math.min(this.textBuffer.length, position + this.maxMatch);
        int s = 0;
        int p = 0;
        int len = 0;
        for (scanpos = position - 1; scanlimit < scanpos; --scanpos) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max > ++p) continue;
            }
            if (matchlen >= len) continue;
            matchpos = scanpos;
            matchlen = len;
        }
        if (this.hashMethod.hashRequires() < this.textBuffer.length - position) {
            int poshash;
            int maxmatch = this.maxMatch;
            scanlimit = Math.max(this.dictionaryLimit, position - this.dictionarySize);
            int offhash = poshash = this.hashMethod.hash(position);
            int offset = 0;
            while (this.isTooBig(offhash) && offset < this.maxMatch - this.hashMethod.hashRequires()) {
                offhash = this.hashMethod.hash(position + ++offset);
            }
            while (true) {
                int searchCount = this.searchLimitCount;
                scanpos = this.hashTable[offhash];
                while (scanlimit <= scanpos - offset && 0 < --searchCount) {
                    if (buf[scanpos + matchlen - offset] == buf[position + matchlen]) {
                        s = scanpos - offset;
                        p = position;
                        while (buf[s] == buf[p]) {
                            ++s;
                            if (max > ++p) continue;
                        }
                        if (matchlen < (len = p - position)) {
                            matchpos = scanpos - offset;
                            matchlen = len;
                            if (max <= p) break;
                        }
                    }
                    scanpos = this.prev[scanpos & this.dictionarySize - 1];
                }
                if (searchCount <= 0) {
                    this.setTooBigFlag(offhash);
                } else if (scanpos < scanlimit) {
                    this.clearTooBigFlag(offhash);
                }
                if (0 >= offset || matchlen >= this.hashMethod.hashRequires() + offset) break;
                offset = 0;
                maxmatch = this.hashMethod.hashRequires() + offset - 1;
                max = Math.min(this.textBuffer.length, position + maxmatch);
                offhash = poshash;
            }
        }
        if (this.threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    @Override
    public void slide() {
        int pos;
        int i;
        this.dictionaryLimit = Math.max(0, this.dictionaryLimit - this.dictionarySize);
        for (i = 0; i < this.hashTable.length; ++i) {
            pos = this.hashTable[i] - this.dictionarySize;
            this.hashTable[i] = 0 <= pos ? pos : -1;
        }
        for (i = 0; i < this.prev.length; ++i) {
            pos = this.prev[i] - this.dictionarySize;
            this.prev[i] = 0 <= pos ? pos : -1;
        }
    }

    @Override
    public int putRequires() {
        return this.hashMethod.hashRequires();
    }

    public int searchAndPut(int position, int[] matchposs) {
        int matchlen = this.threshold - 1;
        int matchpos = position;
        int maxmatch = this.maxMatch;
        int scanlimit = Math.max(this.dictionaryLimit, position - this.dictionarySize);
        int searchCount = this.searchLimitCount;
        for (int i = 0; i < matchposs.length; ++i) {
            matchposs[i] = -1;
        }
        int scanpos = this.hashTable[this.hashMethod.hash(position)];
        while (scanlimit < scanpos && 0 < searchCount--) {
            if (this.textBuffer[scanpos + matchlen] == this.textBuffer[position + matchlen]) {
                int len = 0;
                while (this.textBuffer[scanpos + len] == this.textBuffer[position + len] && maxmatch > ++len) {
                }
                if (matchlen < len) {
                    int i = matchlen + 1 - this.threshold;
                    int end = Math.min(len + 1 - this.threshold, matchposs.length);
                    while (i < end) {
                        matchposs[i++] = scanpos;
                    }
                    matchpos = scanpos;
                    matchlen = len;
                    if (maxmatch <= len) break;
                }
            }
            scanpos = this.prev[scanpos & this.dictionarySize - 1];
        }
        this.put(position);
        if (matchpos < position) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    private boolean isTooBig(int hash) {
        return 0 != (this.tooBigFlag[hash >> 4] & 1 << (hash & 0xF));
    }

    private void setTooBigFlag(int hash) {
        int n = hash >> 4;
        this.tooBigFlag[n] = (char)(this.tooBigFlag[n] | 1 << (hash & 0xF));
    }

    private void clearTooBigFlag(int hash) {
        int n = hash >> 4;
        this.tooBigFlag[n] = (char)(this.tooBigFlag[n] & ~(1 << (hash & 0xF)));
    }
}

