/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.jlha;

import com.orangesignal.jlha.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

final class Factory {
    private Factory() {
    }

    public static Object createInstance(String classname, Object[] args) throws InvocationTargetException, InstantiationException, ClassNotFoundException, NoSuchMethodException {
        return Factory.createInstance(Class.forName(classname), args);
    }

    private static Object createInstance(Class<?> type, Object[] args) throws InvocationTargetException, InstantiationException, NoSuchMethodException {
        Constructor<?> constructor = Factory.getMatchFullConstructor(type, args);
        if (constructor == null && (constructor = Factory.getConstructor(type, args)) != null) {
            args = Type.parseAll(constructor.getParameterTypes(), args);
        }
        if (constructor != null) {
            try {
                return constructor.newInstance(args);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalAccessError(exception.toString());
            }
        }
        throw new NoSuchMethodException();
    }

    private static Constructor<?> getConstructor(Class<?> type, Object[] args) {
        return Factory.getConstructor(type, args, false);
    }

    private static Constructor<?> getConstructor(Class<?> type, Object[] args, boolean all) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = all ? type.getDeclaredConstructors() : type.getConstructors()) {
            if (!Type.matchFullAll(constructor.getParameterTypes(), args)) continue;
            return constructor;
        }
        for (Constructor<?> constructor : constructors) {
            if (!Type.matchRestrictAll(constructor.getParameterTypes(), args)) continue;
            return constructor;
        }
        for (Constructor<?> constructor : constructors) {
            if (!Type.matchAll(constructor.getParameterTypes(), args)) continue;
            return constructor;
        }
        return null;
    }

    private static Constructor<?> getMatchFullConstructor(Class<?> type, Object[] args) {
        return Factory.getMatchFullConstructor(type, args, false);
    }

    private static Constructor<?> getMatchFullConstructor(Class<?> type, Object[] args, boolean all) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = all ? type.getDeclaredConstructors() : type.getConstructors()) {
            if (!Type.matchFullAll(constructor.getParameterTypes(), args)) continue;
            return constructor;
        }
        return null;
    }
}

