/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.io;

import com.orangesignal.csv.CsvWriter;
import com.orangesignal.csv.bean.CsvColumnPositionMappingBeanTemplate;
import com.orangesignal.csv.bean.FieldUtils;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CsvColumnPositionMappingBeanWriter<T>
implements Closeable,
Flushable {
    private CsvWriter writer;
    private final CsvColumnPositionMappingBeanTemplate<T> template;
    private final boolean header;
    private List<String> columnNames;
    private int columnCount = -1;

    public static <T> CsvColumnPositionMappingBeanWriter<T> newInstance(CsvWriter writer, Class<T> type) {
        return new CsvColumnPositionMappingBeanWriter<T>(writer, type);
    }

    public static <T> CsvColumnPositionMappingBeanWriter<T> newInstance(CsvWriter writer, Class<T> type, boolean header) {
        return new CsvColumnPositionMappingBeanWriter<T>(writer, type, header);
    }

    public static <T> CsvColumnPositionMappingBeanWriter<T> newInstance(CsvWriter writer, CsvColumnPositionMappingBeanTemplate<T> template) {
        return new CsvColumnPositionMappingBeanWriter<T>(writer, template);
    }

    public static <T> CsvColumnPositionMappingBeanWriter<T> newInstance(CsvWriter writer, CsvColumnPositionMappingBeanTemplate<T> template, boolean header) {
        return new CsvColumnPositionMappingBeanWriter<T>(writer, template, header);
    }

    public CsvColumnPositionMappingBeanWriter(CsvWriter writer, Class<T> type) {
        this(writer, new CsvColumnPositionMappingBeanTemplate<T>(type), true);
    }

    public CsvColumnPositionMappingBeanWriter(CsvWriter writer, Class<T> type, boolean header) {
        this(writer, new CsvColumnPositionMappingBeanTemplate<T>(type), header);
    }

    public CsvColumnPositionMappingBeanWriter(CsvWriter writer, CsvColumnPositionMappingBeanTemplate<T> template) {
        this(writer, template, true);
    }

    public CsvColumnPositionMappingBeanWriter(CsvWriter writer, CsvColumnPositionMappingBeanTemplate<T> template, boolean header) {
        if (writer == null) {
            throw new IllegalArgumentException("CsvWriter must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("CsvColumnPositionMappingBeanTemplate must not be null");
        }
        this.writer = writer;
        this.template = template;
        this.header = header;
    }

    private void ensureOpen() throws IOException {
        if (this.writer == null) {
            throw new IOException("CsvWriter closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureHeader() throws IOException {
        CsvColumnPositionMappingBeanWriter csvColumnPositionMappingBeanWriter = this;
        synchronized (csvColumnPositionMappingBeanWriter) {
            if (this.columnNames == null) {
                if (this.template.getMaxColumnPosition() == -1) {
                    for (Field f : this.template.getType().getDeclaredFields()) {
                        this.template.column(f.getName());
                    }
                }
                this.columnCount = this.template.getMaxColumnPosition() + 1;
                List<String> names = Collections.unmodifiableList(this.template.createColumnNames());
                if (this.header) {
                    this.writer.writeValues(names);
                }
                this.columnNames = names;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        CsvColumnPositionMappingBeanWriter csvColumnPositionMappingBeanWriter = this;
        synchronized (csvColumnPositionMappingBeanWriter) {
            this.ensureOpen();
            this.writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvColumnPositionMappingBeanWriter csvColumnPositionMappingBeanWriter = this;
        synchronized (csvColumnPositionMappingBeanWriter) {
            this.ensureOpen();
            this.writer.close();
            this.writer = null;
            this.columnNames = null;
            this.columnCount = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeader() throws IOException {
        CsvColumnPositionMappingBeanWriter csvColumnPositionMappingBeanWriter = this;
        synchronized (csvColumnPositionMappingBeanWriter) {
            this.ensureOpen();
            this.ensureHeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(T bean) throws IOException {
        CsvColumnPositionMappingBeanWriter csvColumnPositionMappingBeanWriter = this;
        synchronized (csvColumnPositionMappingBeanWriter) {
            this.ensureOpen();
            this.ensureHeader();
            if (bean == null) {
                this.writer.writeValues(null);
                return true;
            }
            List<String> values = this.toValues(bean);
            if (this.template.isAccept(values)) {
                return false;
            }
            this.writer.writeValues(values);
            return true;
        }
    }

    private List<String> toValues(T bean) throws IOException {
        Class<?> type = bean.getClass();
        String[] values = new String[this.columnCount];
        for (Map.Entry<Integer, String> e : this.template.columnMappingEntrySet()) {
            int pos = e.getKey();
            if (pos == -1) continue;
            Field f = FieldUtils.getField(type, e.getValue());
            values[pos] = this.template.objectToString(pos, FieldUtils.getFieldValue(bean, f));
        }
        return Arrays.asList(values);
    }

    public CsvColumnPositionMappingBeanTemplate<T> getTemplate() {
        return this.template;
    }
}

