/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.io;

import com.orangesignal.csv.CsvReader;
import com.orangesignal.csv.bean.CsvColumnPositionMappingBeanTemplate;
import com.orangesignal.csv.bean.FieldUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CsvColumnPositionMappingBeanReader<T>
implements Closeable {
    private CsvReader reader;
    private final CsvColumnPositionMappingBeanTemplate<T> template;
    private List<String> columnNames;
    private Field[] fields;
    private Map<String, Object[]> fieldColumnsMap;

    public static <T> CsvColumnPositionMappingBeanReader<T> newInstance(CsvReader reader, Class<T> type) {
        return new CsvColumnPositionMappingBeanReader<T>(reader, type);
    }

    public static <T> CsvColumnPositionMappingBeanReader<T> newInstance(CsvReader reader, CsvColumnPositionMappingBeanTemplate<T> template) {
        return new CsvColumnPositionMappingBeanReader<T>(reader, template);
    }

    public CsvColumnPositionMappingBeanReader(CsvReader reader, Class<T> type) {
        this(reader, new CsvColumnPositionMappingBeanTemplate<T>(type));
    }

    public CsvColumnPositionMappingBeanReader(CsvReader reader, CsvColumnPositionMappingBeanTemplate<T> template) {
        if (reader == null) {
            throw new IllegalArgumentException("CsvReader must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("CsvColumnPositionMappingBeanTemplate must not be null");
        }
        this.reader = reader;
        this.template = template;
    }

    private void ensureOpen() throws IOException {
        if (this.reader == null) {
            throw new IOException("CsvReader closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureHeader() throws IOException {
        CsvColumnPositionMappingBeanReader csvColumnPositionMappingBeanReader = this;
        synchronized (csvColumnPositionMappingBeanReader) {
            if (this.columnNames == null) {
                if (this.template.getMaxColumnPosition() == -1) {
                    List<String> names = this.reader.readValues();
                    if (names == null) {
                        throw new IOException("No header is available");
                    }
                    for (String name : names) {
                        this.template.column(name);
                    }
                }
                this.columnNames = Collections.unmodifiableList(this.template.createColumnNames());
                this.fields = this.template.getType().getDeclaredFields();
                this.fieldColumnsMap = this.template.createFieldAndColumnsMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvColumnPositionMappingBeanReader csvColumnPositionMappingBeanReader = this;
        synchronized (csvColumnPositionMappingBeanReader) {
            this.ensureOpen();
            this.reader.close();
            this.reader = null;
            this.columnNames = null;
            this.fields = null;
            this.fieldColumnsMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getHeader() throws IOException {
        CsvColumnPositionMappingBeanReader csvColumnPositionMappingBeanReader = this;
        synchronized (csvColumnPositionMappingBeanReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.columnNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read() throws IOException {
        CsvColumnPositionMappingBeanReader csvColumnPositionMappingBeanReader = this;
        synchronized (csvColumnPositionMappingBeanReader) {
            this.ensureOpen();
            this.ensureHeader();
            List<String> values = this.nextValues();
            if (values == null) {
                return null;
            }
            return this.convert(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readValues() throws IOException {
        CsvColumnPositionMappingBeanReader csvColumnPositionMappingBeanReader = this;
        synchronized (csvColumnPositionMappingBeanReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.nextValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T toBean(List<String> values) throws IOException {
        CsvColumnPositionMappingBeanReader csvColumnPositionMappingBeanReader = this;
        synchronized (csvColumnPositionMappingBeanReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.convert(values);
        }
    }

    private List<String> nextValues() throws IOException {
        List<String> values;
        while ((values = this.reader.readValues()) != null) {
            if (this.template.isAccept(values)) continue;
            return values;
        }
        return null;
    }

    private T convert(List<String> values) throws IOException {
        Object bean = this.template.createBean();
        for (Field f : this.fields) {
            Object[] columns = this.fieldColumnsMap.get(f.getName());
            int count = columns == null ? 0 : columns.length;
            Object o = null;
            if (count == 1) {
                int pos = (Integer)columns[0];
                if (pos >= 0) {
                    o = this.template.stringToObject(f, values.get(pos));
                }
            } else if (count > 1) {
                StringBuilder sb = new StringBuilder();
                for (Object column : columns) {
                    String s;
                    int pos = (Integer)column;
                    if (pos < 0 || (s = values.get(pos)) == null) continue;
                    sb.append(s);
                }
                o = this.template.stringToObject(f, sb.toString());
            }
            if (o == null) continue;
            FieldUtils.setFieldValue(bean, f, o);
        }
        return bean;
    }

    public CsvColumnPositionMappingBeanTemplate<T> getTemplate() {
        return this.template;
    }
}

