/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.io;

import com.orangesignal.csv.CsvReader;
import com.orangesignal.csv.bean.CsvColumnNameMappingBeanTemplate;
import com.orangesignal.csv.bean.FieldUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CsvColumnNameMappingBeanReader<T>
implements Closeable {
    private CsvReader reader;
    private final CsvColumnNameMappingBeanTemplate<T> template;
    private List<String> columnNames;
    private Field[] fields;
    private Map<String, Object[]> fieldColumnsMap;

    public static <T> CsvColumnNameMappingBeanReader<T> newInstance(CsvReader reader, Class<T> type) {
        return new CsvColumnNameMappingBeanReader<T>(reader, type);
    }

    public static <T> CsvColumnNameMappingBeanReader<T> newInstance(CsvReader reader, CsvColumnNameMappingBeanTemplate<T> template) {
        return new CsvColumnNameMappingBeanReader<T>(reader, template);
    }

    public CsvColumnNameMappingBeanReader(CsvReader reader, Class<T> type) {
        this(reader, new CsvColumnNameMappingBeanTemplate<T>(type));
    }

    public CsvColumnNameMappingBeanReader(CsvReader reader, CsvColumnNameMappingBeanTemplate<T> template) {
        if (reader == null) {
            throw new IllegalArgumentException("CsvReader must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("CsvColumnNameMappingBeanTemplate must not be null");
        }
        this.reader = reader;
        this.template = template;
    }

    private void ensureOpen() throws IOException {
        if (this.reader == null) {
            throw new IOException("CsvReader closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureHeader() throws IOException {
        CsvColumnNameMappingBeanReader csvColumnNameMappingBeanReader = this;
        synchronized (csvColumnNameMappingBeanReader) {
            if (this.columnNames == null) {
                this.columnNames = Collections.unmodifiableList(this.reader.readValues());
                if (this.columnNames == null) {
                    throw new IOException("No header is available");
                }
                this.template.setupColumnMappingIfNeed();
                this.fields = this.template.getType().getDeclaredFields();
                this.fieldColumnsMap = this.template.createFieldAndColumnsMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvColumnNameMappingBeanReader csvColumnNameMappingBeanReader = this;
        synchronized (csvColumnNameMappingBeanReader) {
            this.ensureOpen();
            this.reader.close();
            this.reader = null;
            this.columnNames = null;
            this.fields = null;
            this.fieldColumnsMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getHeader() throws IOException {
        CsvColumnNameMappingBeanReader csvColumnNameMappingBeanReader = this;
        synchronized (csvColumnNameMappingBeanReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.columnNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read() throws IOException {
        CsvColumnNameMappingBeanReader csvColumnNameMappingBeanReader = this;
        synchronized (csvColumnNameMappingBeanReader) {
            this.ensureOpen();
            this.ensureHeader();
            List<String> values = this.nextValues();
            if (values == null) {
                return null;
            }
            return this.convert(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readValues() throws IOException {
        CsvColumnNameMappingBeanReader csvColumnNameMappingBeanReader = this;
        synchronized (csvColumnNameMappingBeanReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.nextValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T toBean(List<String> values) throws IOException {
        CsvColumnNameMappingBeanReader csvColumnNameMappingBeanReader = this;
        synchronized (csvColumnNameMappingBeanReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.convert(values);
        }
    }

    private List<String> nextValues() throws IOException {
        List<String> values;
        while ((values = this.reader.readValues()) != null) {
            if (this.template.isAccept(this.columnNames, values)) continue;
            return values;
        }
        return null;
    }

    private T convert(List<String> values) throws IOException {
        Object bean = this.template.createBean();
        for (Field f : this.fields) {
            Object[] columns = this.fieldColumnsMap.get(f.getName());
            int count = columns == null ? 0 : columns.length;
            Object o = null;
            if (count == 1) {
                int pos = this.columnNames.indexOf(columns[0]);
                if (pos != -1) {
                    o = this.template.stringToObject(f, values.get(pos));
                }
            } else if (count > 1) {
                StringBuilder sb = new StringBuilder();
                for (Object column : columns) {
                    String s;
                    int pos = this.columnNames.indexOf(column);
                    if (pos == -1 || (s = values.get(pos)) == null) continue;
                    sb.append(s);
                }
                o = this.template.stringToObject(f, sb.toString());
            }
            if (o == null) continue;
            FieldUtils.setFieldValue(bean, f, o);
        }
        return bean;
    }

    public CsvColumnNameMappingBeanTemplate<T> getTemplate() {
        return this.template;
    }
}

