/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.handlers;

import com.orangesignal.csv.CsvReader;
import com.orangesignal.csv.CsvWriter;
import com.orangesignal.csv.filters.CsvValueFilter;
import com.orangesignal.csv.handlers.AbstractCsvListHandler;
import com.orangesignal.csv.io.CsvColumnPositionMapReader;
import com.orangesignal.csv.io.CsvColumnPositionMapWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ColumnPositionMapListHandler
extends AbstractCsvListHandler<Map<Integer, String>, ColumnPositionMapListHandler> {
    private CsvValueFilter valueFilter;

    public ColumnPositionMapListHandler filter(CsvValueFilter filter) {
        this.valueFilter = filter;
        return this;
    }

    @Override
    public List<Map<Integer, String>> load(CsvReader reader, boolean ignoreScalar) throws IOException {
        List<String> values;
        CsvColumnPositionMapReader r = new CsvColumnPositionMapReader(reader);
        r.setFilter(this.valueFilter);
        ArrayList<Map<Integer, String>> results = new ArrayList<Map<Integer, String>>();
        int offset = 0;
        while ((values = r.readValues()) != null && (ignoreScalar || this.limit <= 0 || results.size() < this.limit)) {
            if (!ignoreScalar && offset < this.offset) {
                ++offset;
                continue;
            }
            results.add(r.toMap(values));
        }
        return results;
    }

    @Override
    public void save(List<Map<Integer, String>> list, CsvWriter writer) throws IOException {
        CsvColumnPositionMapWriter w = new CsvColumnPositionMapWriter(writer);
        w.setFilter(this.valueFilter);
        for (Map<Integer, String> map : list) {
            w.write(map);
        }
    }
}

