/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.bean;

import com.orangesignal.csv.annotation.CsvColumn;
import com.orangesignal.csv.annotation.CsvColumns;
import com.orangesignal.csv.annotation.CsvEntity;
import com.orangesignal.csv.bean.AbstractCsvBeanTemplate;
import com.orangesignal.csv.bean.CsvEntityOperation;
import com.orangesignal.csv.filters.CsvNamedValueFilter;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class CsvEntityTemplate<T>
extends AbstractCsvBeanTemplate<T, CsvEntityTemplate<T>>
implements CsvEntityOperation<CsvEntityTemplate<T>> {
    private CsvNamedValueFilter filter;

    public static <T> CsvEntityTemplate<T> newInstance(Class<T> entityClass) {
        return new CsvEntityTemplate<T>(entityClass);
    }

    public CsvEntityTemplate(Class<T> entityClass) {
        super(entityClass);
        if (entityClass.getAnnotation(CsvEntity.class) == null) {
            throw new IllegalArgumentException(String.format("No CsvEntity is available %s", entityClass.getName()));
        }
    }

    @Override
    public CsvEntityTemplate<T> filter(CsvNamedValueFilter filter) {
        this.filter = filter;
        return this;
    }

    public boolean isAccept(List<String> columnNames, List<String> values) {
        return this.filter != null && !this.filter.accept(columnNames, values);
    }

    public List<String> createColumnNames() {
        TreeMap<Integer, String> positionMap = new TreeMap<Integer, String>();
        ArrayList<String> adding = new ArrayList<String>();
        for (Field f : this.getType().getDeclaredFields()) {
            CsvColumn column;
            CsvColumns columns = f.getAnnotation(CsvColumns.class);
            if (columns != null) {
                for (CsvColumn column2 : columns.value()) {
                    int pos = column2.position();
                    String name = CsvEntityTemplate.defaultIfEmpty(column2.name(), f.getName());
                    if (pos >= 0) {
                        if (positionMap.containsKey(pos)) continue;
                        positionMap.put(pos, name);
                        continue;
                    }
                    adding.add(name);
                }
            }
            if ((column = f.getAnnotation(CsvColumn.class)) == null) continue;
            int pos = column.position();
            String name = CsvEntityTemplate.defaultIfEmpty(column.name(), f.getName());
            if (pos >= 0) {
                if (positionMap.containsKey(pos)) continue;
                positionMap.put(pos, name);
                continue;
            }
            adding.add(name);
        }
        int max = positionMap.size() > 0 ? (Integer)positionMap.lastKey() + 1 : 0;
        String[] names = new String[max];
        for (Map.Entry entry : positionMap.entrySet()) {
            names[((Integer)entry.getKey()).intValue()] = (String)entry.getValue();
        }
        ArrayList<String> results = new ArrayList<String>(Arrays.asList(names));
        if (adding.size() > 0) {
            results.addAll(adding);
        }
        return results;
    }

    public List<String> createWritableColumnNames() {
        TreeMap<Integer, String> positionMap = new TreeMap<Integer, String>();
        ArrayList<String> adding = new ArrayList<String>();
        for (Field f : this.getType().getDeclaredFields()) {
            CsvColumn column;
            CsvColumns columns = f.getAnnotation(CsvColumns.class);
            if (columns != null) {
                for (CsvColumn column2 : columns.value()) {
                    if (!column2.access().isWriteable()) continue;
                    int pos = column2.position();
                    String name = CsvEntityTemplate.defaultIfEmpty(column2.name(), f.getName());
                    if (pos >= 0) {
                        if (positionMap.containsKey(pos)) continue;
                        positionMap.put(pos, name);
                        continue;
                    }
                    adding.add(name);
                }
            }
            if ((column = f.getAnnotation(CsvColumn.class)) == null || !column.access().isWriteable()) continue;
            int pos = column.position();
            String name = CsvEntityTemplate.defaultIfEmpty(column.name(), f.getName());
            if (pos >= 0) {
                if (positionMap.containsKey(pos)) continue;
                positionMap.put(pos, name);
                continue;
            }
            adding.add(name);
        }
        int max = positionMap.size() > 0 ? (Integer)positionMap.lastKey() + 1 : 0;
        String[] names = new String[max];
        for (Map.Entry entry : positionMap.entrySet()) {
            names[((Integer)entry.getKey()).intValue()] = (String)entry.getValue();
        }
        ArrayList<String> results = new ArrayList<String>(Arrays.asList(names));
        if (adding.size() > 0) {
            results.addAll(adding);
        }
        return results;
    }

    public void prepare(List<String> names, Field[] fields) {
        super.valueParserMapping(new HashMap<String, Format>(0));
        super.valueFormatterMapping(new HashMap<Object, Format>(0));
        for (Field f : fields) {
            Format format;
            CsvColumn column;
            CsvColumns columns = f.getAnnotation(CsvColumns.class);
            if (columns != null) {
                for (CsvColumn column2 : columns.value()) {
                    Format format2 = CsvEntityTemplate.createFormat(column2, f);
                    if (format2 == null) continue;
                    this.setValueParser(f.getName(), format2);
                    this.setValueFormatter(CsvEntityTemplate.getPosition(column2, f, names), format2);
                }
            }
            if ((column = f.getAnnotation(CsvColumn.class)) == null || (format = CsvEntityTemplate.createFormat(column, f)) == null) continue;
            this.setValueParser(f.getName(), format);
            this.setValueFormatter(CsvEntityTemplate.getPosition(column, f, names), format);
        }
    }

    public static int getPosition(CsvColumn column, Field f, List<String> names) {
        int pos = column.position();
        if (pos < 0 && names != null) {
            pos = names.indexOf(CsvEntityTemplate.defaultIfEmpty(column.name(), f.getName()));
        }
        if (pos == -1) {
            throw new IllegalStateException(String.format("Invalid CsvColumn field %s", f.getName()));
        }
        return pos;
    }

    public static String defaultIfEmpty(String str, String defaultStr) {
        return str == null || str.isEmpty() ? defaultStr : str;
    }

    private static Format createFormat(CsvColumn column, Field f) {
        Locale locale;
        String pattern = column.format();
        if (pattern.isEmpty()) {
            return null;
        }
        Locale locale2 = locale = column.language().isEmpty() ? Locale.getDefault() : new Locale(column.language(), column.country());
        if (Date.class.isAssignableFrom(f.getType())) {
            SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
            if (!column.timezone().isEmpty()) {
                format.setTimeZone(TimeZone.getTimeZone(column.timezone()));
            }
            return format;
        }
        DecimalFormat format = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(locale));
        if (!column.currency().isEmpty()) {
            format.setCurrency(Currency.getInstance(column.currency()));
        }
        return format;
    }
}

