/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv;

import com.orangesignal.csv.Csv;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

abstract class SerializationUtils {
    protected SerializationUtils() {
    }

    public static Object clone(Serializable object) {
        return SerializationUtils.deserialize(SerializationUtils.serialize(object));
    }

    public static void serialize(Serializable obj, OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(outputStream);
            out.writeObject(obj);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Csv.closeQuietly(out);
                throw throwable;
            }
        }
        Csv.closeQuietly(out);
    }

    public static byte[] serialize(Serializable obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(obj, baos);
        return baos.toByteArray();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(InputStream inputStream) {
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(inputStream);
            object = in.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                throw new IllegalStateException(e.getMessage(), e);
                catch (IOException e2) {
                    throw new IllegalStateException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                Csv.closeQuietly(in);
                throw throwable;
            }
        }
        Csv.closeQuietly(in);
        return object;
    }

    public static Object deserialize(byte[] objectData) {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        return SerializationUtils.deserialize(new ByteArrayInputStream(objectData));
    }
}

