/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv;

import com.orangesignal.csv.CsvConfig;
import com.orangesignal.csv.CsvToken;
import com.orangesignal.csv.CsvTokenException;
import com.orangesignal.csv.SimpleCsvToken;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CsvReader
implements Closeable {
    private Reader in;
    private CsvConfig cfg;
    private final StringBuilder line = new StringBuilder();
    private int nextChar = -1;
    private int pos;
    private boolean skiped;
    private int startTokenLineNumber = 0;
    private int endTokenLineNumber = 0;
    private int startLineNumber = 0;
    private int endLineNumber = 0;
    private int lineNumber = 0;
    private boolean endOfFile;
    private boolean endOfLine;
    private boolean cr = false;
    private final boolean utf8bom;
    private int countNumberOfColumns = -1;
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final int BOM = 65279;
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private int arraySize = 3;
    private final StringBuilder buf = new StringBuilder();
    private boolean inQuote = false;
    private boolean enclosed = false;
    private boolean escaped = false;
    private boolean _escaped = false;

    public CsvReader(Reader in, int sz, CsvConfig cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException("CsvConfig must not be null");
        }
        cfg.validate();
        this.in = new BufferedReader(in, sz);
        this.cfg = cfg;
        String s = in instanceof InputStreamReader ? ((InputStreamReader)in).getEncoding() : Charset.defaultCharset().name();
        this.utf8bom = s.toLowerCase().matches("^utf\\-{0,1}8$");
    }

    public CsvReader(Reader in, CsvConfig cfg) {
        this(in, 8192, cfg);
    }

    public CsvReader(Reader in, int sz) {
        this(in, sz, new CsvConfig());
    }

    public CsvReader(Reader in) {
        this(in, 8192, new CsvConfig());
    }

    public int getStartLineNumber() {
        return this.startLineNumber;
    }

    public int getEndLineNumber() {
        return this.endLineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isEndOfFile() {
        return this.endOfFile;
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Reader closed");
        }
    }

    private int cacheLine() throws IOException {
        int c;
        this.line.setLength(0);
        if (this.nextChar != -1) {
            c = this.nextChar;
            this.nextChar = -1;
        } else {
            c = this.in.read();
            if (this.lineNumber == 0 && this.utf8bom && c == 65279) {
                c = this.in.read();
            }
        }
        int result = -1;
        while (c != -1) {
            this.line.append((char)c);
            if (c == 13) {
                result = this.line.length();
                this.nextChar = this.in.read();
                if (this.nextChar != 10) break;
                this.line.append((char)this.nextChar);
                this.nextChar = -1;
                break;
            }
            if (c == 10) {
                result = this.line.length();
                break;
            }
            c = this.in.read();
        }
        this.pos = 0;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read() throws IOException {
        CsvReader csvReader = this;
        synchronized (csvReader) {
            this.ensureOpen();
            if (this.endOfFile) {
                return -1;
            }
            if (this.line.length() == 0 || this.line.length() <= this.pos) {
                this.cacheLine();
            }
            if (this.line.length() == 0) {
                return -1;
            }
            return this.line.charAt(this.pos++);
        }
    }

    public List<String> readValues() throws IOException {
        List<CsvToken> tokens = this.readTokens();
        if (tokens == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>(tokens.size());
        for (CsvToken token : tokens) {
            results.add(token.getValue());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CsvToken> readTokens() throws IOException {
        CsvReader csvReader = this;
        synchronized (csvReader) {
            this.ensureOpen();
            if (this.endOfFile) {
                return null;
            }
            if (!this.skiped) {
                for (int i = 0; i < this.cfg.getSkipLines(); ++i) {
                    this.cacheLine();
                    ++this.endTokenLineNumber;
                    ++this.lineNumber;
                }
                this.line.setLength(0);
                this.skiped = true;
            }
            return this.readCsvTokens();
        }
    }

    private List<CsvToken> readCsvTokens() throws IOException {
        ArrayList<CsvToken> results = new ArrayList<CsvToken>(this.arraySize);
        ++this.endTokenLineNumber;
        this.startLineNumber = this.endTokenLineNumber;
        this.endOfLine = false;
        do {
            if (this.line.length() == 0 || this.line.length() <= this.pos) {
                boolean ignore;
                int breakLine = this.cacheLine();
                if (this.cfg.isIgnoreEmptyLines()) {
                    ignore = true;
                    while (ignore && this.line.length() > 0) {
                        ignore = false;
                        if (!CsvReader.isWhitespaces(breakLine == -1 ? this.line : this.line.substring(0, breakLine - 1))) continue;
                        ignore = true;
                        this.startLineNumber = ++this.endTokenLineNumber;
                        ++this.lineNumber;
                        breakLine = this.cacheLine();
                    }
                }
                if (this.cfg.getIgnoreLinePatterns() != null) {
                    ignore = true;
                    block2: while (ignore && this.line.length() > 0) {
                        ignore = false;
                        for (Pattern p : this.cfg.getIgnoreLinePatterns()) {
                            if (p == null || !p.matcher(breakLine == -1 ? this.line : this.line.substring(0, breakLine - 1)).matches()) continue;
                            ignore = true;
                            this.startLineNumber = ++this.endTokenLineNumber;
                            ++this.lineNumber;
                            breakLine = this.cacheLine();
                            continue block2;
                        }
                    }
                }
            }
            this.startTokenLineNumber = this.endTokenLineNumber;
            results.add(this.readCsvToken());
        } while (!this.endOfLine);
        this.endLineNumber = this.endTokenLineNumber;
        ++this.lineNumber;
        this.arraySize = results.size();
        if (this.arraySize == 1) {
            if (this.endOfFile) {
                String value = ((CsvToken)results.get(0)).getValue();
                if (this.cfg.isIgnoreEmptyLines() && CsvReader.isWhitespaces(value)) {
                    return null;
                }
                if (this.cfg.getIgnoreLinePatterns() != null) {
                    for (Pattern p : this.cfg.getIgnoreLinePatterns()) {
                        if (p == null || !p.matcher(value).matches()) continue;
                        return null;
                    }
                }
            } else if (this.cfg.isIgnoreEmptyLines() && (this.line.length() == 0 || CsvReader.isWhitespaces(this.line))) {
                return null;
            }
        }
        if (!this.cfg.isVariableColumns()) {
            if (this.countNumberOfColumns >= 0 && this.countNumberOfColumns != this.arraySize) {
                throw new CsvTokenException(String.format("Invalid column count in CSV input on line %d.", this.startLineNumber), results);
            }
            this.countNumberOfColumns = this.arraySize;
        }
        return results;
    }

    private CsvToken readCsvToken() throws IOException {
        this.buf.setLength(0);
        this.inQuote = false;
        this.enclosed = false;
        this.escaped = false;
        this._escaped = false;
        this.endTokenLineNumber = this.startTokenLineNumber;
        while (true) {
            int c = this.read();
            if (this.cr) {
                this.cr = false;
                this.escaped = false;
                if (c == 10) {
                    if (!this.inQuote) continue;
                    this.buf.append((char)c);
                    continue;
                }
            } else if (this._escaped && c == this.cfg.getSeparator()) {
                this.buf.append((char)c);
                this._escaped = false;
                continue;
            }
            this._escaped = false;
            if (c == -1) {
                this.endOfLine = true;
                this.endOfFile = true;
                break;
            }
            if (!this.inQuote) {
                if (c == this.cfg.getSeparator()) break;
                if (c == 13) {
                    this.endOfLine = true;
                    this.cr = true;
                    break;
                }
                if (c == 10) {
                    this.endOfLine = true;
                    break;
                }
                if (!this.cfg.isQuoteDisabled() && !this.enclosed && c == this.cfg.getQuote()) {
                    if (CsvReader.isWhitespaces(this.buf)) {
                        this.inQuote = true;
                    }
                } else if (this.cfg.isQuoteDisabled() && !this.cfg.isEscapeDisabled() && c == this.cfg.getEscape()) {
                    this._escaped = true;
                }
            } else {
                if (!this.cfg.isEscapeDisabled() && this.cfg.getQuote() == this.cfg.getEscape()) {
                    if (this.escaped) {
                        if (c == this.cfg.getSeparator()) break;
                        if (c == 13) {
                            this.endOfLine = true;
                            this.cr = true;
                            break;
                        }
                        if (c == 10) {
                            this.endOfLine = true;
                            break;
                        }
                        if (c == this.cfg.getEscape()) {
                            this.escaped = false;
                            this.buf.append((char)c);
                            continue;
                        }
                    } else if (c == this.cfg.getEscape()) {
                        this.escaped = true;
                        this.buf.append((char)c);
                        continue;
                    }
                }
                if (c == this.cfg.getQuote()) {
                    if (this.escaped) {
                        this.escaped = false;
                    } else {
                        this.inQuote = false;
                        this.enclosed = true;
                    }
                } else if (c == 13) {
                    this.cr = true;
                    ++this.endTokenLineNumber;
                } else if (c == 10) {
                    ++this.endTokenLineNumber;
                }
                this.escaped = !this.cfg.isEscapeDisabled() && c == this.cfg.getEscape();
            }
            this.buf.append((char)c);
        }
        if (this.escaped) {
            this.enclosed = true;
        }
        String value = this.buf.toString();
        if (this.enclosed) {
            int i = value.lastIndexOf(this.cfg.getQuote()) + 1;
            assert (i > 0);
            if (i < value.length() && !CsvReader.isWhitespaces(value.substring(i + 1))) {
                this.enclosed = false;
            }
        }
        if (this.cfg.isIgnoreLeadingWhitespaces() || this.enclosed) {
            value = CsvReader.removeLeadingWhitespaces(value);
        }
        if (this.cfg.isIgnoreTrailingWhitespaces() || this.enclosed) {
            value = CsvReader.removeTrailingWhitespaces(value);
        }
        if (this.enclosed) {
            value = value.substring(1, value.length() - 1);
            if (this.cfg.getBreakString() != null) {
                value = value.replaceAll("\r\n|\r|\n", this.cfg.getBreakString());
            }
            if (!this.cfg.isEscapeDisabled()) {
                value = this.unescapeQuote(value);
            }
        } else {
            if (this.cfg.getNullString() != null) {
                if (this.cfg.isIgnoreCaseNullString()) {
                    if (this.cfg.getNullString().equalsIgnoreCase(value)) {
                        value = null;
                    }
                } else if (this.cfg.getNullString().equals(value)) {
                    value = null;
                }
            }
            if (value != null && !this.cfg.isEscapeDisabled()) {
                value = this.unescapeSeparator(value);
            }
        }
        return new SimpleCsvToken(value, this.startTokenLineNumber, this.endTokenLineNumber, this.enclosed);
    }

    private String unescapeQuote(String value) {
        return value.replace(new StringBuilder(2).append(this.cfg.getEscape()).append(this.cfg.getQuote()), new StringBuilder(1).append(this.cfg.getQuote()));
    }

    private String unescapeSeparator(String value) {
        return value.replace(new StringBuilder(2).append(this.cfg.getEscape()).append(this.cfg.getSeparator()), new StringBuilder(1).append(this.cfg.getSeparator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvReader csvReader = this;
        synchronized (csvReader) {
            this.in.close();
            this.in = null;
            this.cfg = null;
            this.line.setLength(0);
        }
    }

    private static boolean isWhitespaces(CharSequence value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String removeLeadingWhitespaces(String value) {
        int len = value.length();
        int pos = -1;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            return "";
        }
        if (pos > 0) {
            return value.substring(pos);
        }
        return value;
    }

    private static String removeTrailingWhitespaces(String value) {
        int start = value.length() - 1;
        int pos = -1;
        for (int i = start; i >= 0; --i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            return "";
        }
        if (pos != start) {
            return value.substring(0, pos + 1);
        }
        return value;
    }
}

