/*
 * Decompiled with CFR 0.152.
 */
package com.opencastsoftware.prettier4j.ansi;

import com.opencastsoftware.prettier4j.ansi.Color;
import com.opencastsoftware.prettier4j.ansi.Color16;
import com.opencastsoftware.prettier4j.ansi.ColorRgb;
import com.opencastsoftware.prettier4j.ansi.ColorXterm;
import java.util.Objects;
import java.util.function.LongUnaryOperator;

public class Styles {
    private Styles() {
    }

    public static StylesOperator fg(Color color) {
        return new Fg(color);
    }

    public static StylesOperator bg(Color color) {
        return new Bg(color);
    }

    public static StylesOperator bold() {
        return Bold.getInstance();
    }

    public static StylesOperator faint() {
        return Faint.getInstance();
    }

    public static StylesOperator italic() {
        return Italic.getInstance();
    }

    public static StylesOperator underline() {
        return Underline.getInstance();
    }

    public static StylesOperator blink() {
        return Blink.getInstance();
    }

    public static StylesOperator inverse() {
        return Inverse.getInstance();
    }

    public static StylesOperator strikethrough() {
        return Strikethrough.getInstance();
    }

    static class Strikethrough
    extends DisplayStylesOperator {
        private static final Strikethrough INSTANCE = new Strikethrough();

        static Strikethrough getInstance() {
            return INSTANCE;
        }

        Strikethrough() {
            super(6);
        }

        public String toString() {
            return "Strikethrough []";
        }
    }

    static class Inverse
    extends DisplayStylesOperator {
        private static final Inverse INSTANCE = new Inverse();

        static Inverse getInstance() {
            return INSTANCE;
        }

        Inverse() {
            super(5);
        }

        public String toString() {
            return "Inverse []";
        }
    }

    static class Blink
    extends DisplayStylesOperator {
        private static final Blink INSTANCE = new Blink();

        static Blink getInstance() {
            return INSTANCE;
        }

        Blink() {
            super(4);
        }

        public String toString() {
            return "Blink []";
        }
    }

    static class Underline
    extends DisplayStylesOperator {
        private static final Underline INSTANCE = new Underline();

        static Underline getInstance() {
            return INSTANCE;
        }

        Underline() {
            super(3);
        }

        public String toString() {
            return "Underline []";
        }
    }

    static class Italic
    extends DisplayStylesOperator {
        private static final Italic INSTANCE = new Italic();

        static Italic getInstance() {
            return INSTANCE;
        }

        Italic() {
            super(2);
        }

        public String toString() {
            return "Italic []";
        }
    }

    static class Faint
    extends DisplayStylesOperator {
        private static final Faint INSTANCE = new Faint();

        static Faint getInstance() {
            return INSTANCE;
        }

        Faint() {
            super(1);
        }

        public String toString() {
            return "Faint []";
        }
    }

    static class Bold
    extends DisplayStylesOperator {
        private static final Bold INSTANCE = new Bold();

        static Bold getInstance() {
            return INSTANCE;
        }

        Bold() {
            super(0);
        }

        public String toString() {
            return "Bold []";
        }
    }

    static abstract class DisplayStylesOperator
    implements StylesOperator {
        private final int shiftValue;

        DisplayStylesOperator(int shiftValue) {
            this.shiftValue = shiftValue;
        }

        @Override
        public long applyAsLong(long attrs) {
            return attrs | 1L << this.shiftValue;
        }
    }

    static class Bg
    extends ColorStylesOperator {
        Bg(Color color) {
            super(color, 0xF000000FFFFFFFFL, 32L, 60L);
        }

        public String toString() {
            return "Bg [color=" + this.color + ']';
        }
    }

    static class Fg
    extends ColorStylesOperator {
        Fg(Color color) {
            super(color, -1080863914863886081L, 8L, 56L);
        }

        public String toString() {
            return "Fg [color=" + this.color + ']';
        }
    }

    static abstract class ColorStylesOperator
    implements StylesOperator {
        protected final Color color;
        private final long colorMask;
        private final long colorShift;
        private final long colorTypeShift;

        ColorStylesOperator(Color color, long colorMask, long colorShift, long colorTypeShift) {
            this.color = color;
            this.colorMask = colorMask;
            this.colorShift = colorShift;
            this.colorTypeShift = colorTypeShift;
        }

        private long withColorType(long attrs) {
            int colorTypeCode = this.color.colorType().code();
            long newColorType = (long)colorTypeCode << (int)this.colorTypeShift;
            return attrs | newColorType;
        }

        private long withColor(long attrs) {
            long newColor = 0L;
            switch (this.color.colorType()) {
                case COLOR_16: {
                    Color16 color16 = (Color16)this.color;
                    newColor = color16.code();
                    break;
                }
                case COLOR_XTERM: {
                    ColorXterm colorXterm = (ColorXterm)this.color;
                    newColor = colorXterm.color();
                    break;
                }
                case COLOR_RGB: {
                    ColorRgb colorRgb = (ColorRgb)this.color;
                    newColor = colorRgb.packed();
                }
            }
            return attrs | newColor << (int)this.colorShift;
        }

        @Override
        public long applyAsLong(long attrs) {
            long noColorInfo = attrs & this.colorMask;
            if (this.color == null) {
                return noColorInfo;
            }
            long withColorType = this.withColorType(noColorInfo);
            return this.withColor(withColorType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColorStylesOperator that = (ColorStylesOperator)o;
            return this.colorMask == that.colorMask && this.colorShift == that.colorShift && this.colorTypeShift == that.colorTypeShift && Objects.equals(this.color, that.color);
        }

        public int hashCode() {
            return Objects.hash(this.color, this.colorMask, this.colorShift, this.colorTypeShift);
        }
    }

    public static interface StylesOperator
    extends LongUnaryOperator {
    }
}

