/*
 * Decompiled with CFR 0.152.
 */
package com.opencastsoftware.prettier4j.ansi;

import com.opencastsoftware.prettier4j.ansi.Color;
import com.opencastsoftware.prettier4j.ansi.ColorType;
import java.util.Objects;

class ColorXterm
implements Color {
    private final int color;

    ColorXterm(int color) {
        this.color = color & 0xFF;
    }

    public int color() {
        return this.color;
    }

    @Override
    public int[] fgParams() {
        return new int[]{38, 5, this.color()};
    }

    @Override
    public int[] bgParams() {
        return new int[]{48, 5, this.color()};
    }

    @Override
    public ColorType colorType() {
        return ColorType.COLOR_XTERM;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorXterm colorXterm = (ColorXterm)o;
        return this.color == colorXterm.color;
    }

    public int hashCode() {
        return Objects.hashCode(this.color);
    }

    public String toString() {
        return "ColorXterm [color=" + this.color + ']';
    }
}

