/*
 * Decompiled with CFR 0.152.
 */
package com.opencastsoftware.prettier4j.ansi;

import com.opencastsoftware.prettier4j.ansi.Color;
import com.opencastsoftware.prettier4j.ansi.ColorType;
import java.util.Objects;

class ColorRgb
implements Color {
    private final int red;
    private final int green;
    private final int blue;

    ColorRgb(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public int red() {
        return this.red;
    }

    public int green() {
        return this.green;
    }

    public int blue() {
        return this.blue;
    }

    static ColorRgb fromPacked(int packed) {
        int r = packed & 0xFF;
        int g = packed >>> 8 & 0xFF;
        int b = packed >>> 16 & 0xFF;
        return new ColorRgb(r, g, b);
    }

    int packed() {
        int r = this.red & 0xFF;
        int g = (this.green & 0xFF) << 8;
        int b = (this.blue & 0xFF) << 16;
        return r | g | b;
    }

    @Override
    public int[] fgParams() {
        return new int[]{38, 2, this.red(), this.green(), this.blue()};
    }

    @Override
    public int[] bgParams() {
        return new int[]{48, 2, this.red(), this.green(), this.blue()};
    }

    @Override
    public ColorType colorType() {
        return ColorType.COLOR_RGB;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorRgb colorRgb = (ColorRgb)o;
        return this.red == colorRgb.red && this.green == colorRgb.green && this.blue == colorRgb.blue;
    }

    public int hashCode() {
        return Objects.hash(this.red, this.green, this.blue);
    }

    public String toString() {
        return "ColorRgb [red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ']';
    }
}

