/*
 * Decompiled with CFR 0.152.
 */
package com.opencastsoftware.prettier4j.ansi;

import com.opencastsoftware.prettier4j.ansi.Color;
import com.opencastsoftware.prettier4j.ansi.ColorType;

enum Color16 implements Color
{
    BLACK(0),
    RED(1),
    GREEN(2),
    YELLOW(3),
    BLUE(4),
    MAGENTA(5),
    CYAN(6),
    WHITE(7),
    DEFAULT(9),
    BRIGHT_BLACK(60),
    BRIGHT_RED(61),
    BRIGHT_GREEN(62),
    BRIGHT_YELLOW(63),
    BRIGHT_BLUE(64),
    BRIGHT_MAGENTA(65),
    BRIGHT_CYAN(66),
    BRIGHT_WHITE(67);

    private final int code;

    private Color16(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public int fgCode() {
        return this.code + 30;
    }

    @Override
    public int[] fgParams() {
        return new int[]{this.fgCode()};
    }

    public int bgCode() {
        return this.code + 40;
    }

    @Override
    public int[] bgParams() {
        return new int[]{this.bgCode()};
    }

    @Override
    public ColorType colorType() {
        return ColorType.COLOR_16;
    }

    static Color16 withCode(int code) {
        for (Color16 value : Color16.values()) {
            if (value.code() != code) continue;
            return value;
        }
        return null;
    }
}

