/*
 * Decompiled with CFR 0.152.
 */
package com.opencastsoftware.prettier4j.ansi;

import com.opencastsoftware.prettier4j.ansi.Color16;
import com.opencastsoftware.prettier4j.ansi.ColorRgb;
import com.opencastsoftware.prettier4j.ansi.ColorType;
import com.opencastsoftware.prettier4j.ansi.ColorXterm;
import org.apiguardian.api.API;

public interface Color {
    @API(status=API.Status.INTERNAL)
    public int[] fgParams();

    @API(status=API.Status.INTERNAL)
    public int[] bgParams();

    public ColorType colorType();

    public static Color none() {
        return Color16.DEFAULT;
    }

    public static Color black() {
        return Color16.BLACK;
    }

    public static Color red() {
        return Color16.RED;
    }

    public static Color green() {
        return Color16.GREEN;
    }

    public static Color yellow() {
        return Color16.YELLOW;
    }

    public static Color blue() {
        return Color16.BLUE;
    }

    public static Color magenta() {
        return Color16.MAGENTA;
    }

    public static Color cyan() {
        return Color16.CYAN;
    }

    public static Color white() {
        return Color16.WHITE;
    }

    public static Color brightBlack() {
        return Color16.BRIGHT_BLACK;
    }

    public static Color brightRed() {
        return Color16.BRIGHT_RED;
    }

    public static Color brightGreen() {
        return Color16.BRIGHT_GREEN;
    }

    public static Color brightYellow() {
        return Color16.BRIGHT_YELLOW;
    }

    public static Color brightBlue() {
        return Color16.BRIGHT_BLUE;
    }

    public static Color brightMagenta() {
        return Color16.BRIGHT_MAGENTA;
    }

    public static Color brightCyan() {
        return Color16.BRIGHT_CYAN;
    }

    public static Color brightWhite() {
        return Color16.BRIGHT_WHITE;
    }

    public static Color xterm(int color) {
        return new ColorXterm(color);
    }

    public static Color rgb(int r, int g, int b) {
        return new ColorRgb(r, g, b);
    }
}

