/*
 * Decompiled with CFR 0.152.
 */
package com.opencastsoftware.prettier4j.ansi;

import java.util.Arrays;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, consumers={"com.opencastsoftware.prettier4j"})
public class AttrsStack {
    private static final int INITIAL_CAPACITY = 16;
    private long[] stack;
    private int size;

    public AttrsStack(int initialCapacity) {
        this.stack = new long[initialCapacity];
        this.size = 0;
    }

    public AttrsStack() {
        this(16);
    }

    private void ensureCapacity() {
        if (this.size == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stack.length * 2);
        }
    }

    public long peekLast() {
        if (this.size > 0) {
            return this.stack[this.size - 1];
        }
        return -1L;
    }

    public void pushLast(long attrs) {
        this.ensureCapacity();
        this.stack[this.size++] = attrs;
    }

    public long popLast() {
        if (this.size > 0) {
            return this.stack[--this.size];
        }
        return -1L;
    }
}

