/*
 * Decompiled with CFR 0.152.
 */
package com.opencastsoftware.prettier4j.ansi;

import com.opencastsoftware.prettier4j.ansi.Color;
import com.opencastsoftware.prettier4j.ansi.Color16;
import com.opencastsoftware.prettier4j.ansi.ColorRgb;
import com.opencastsoftware.prettier4j.ansi.ColorType;
import com.opencastsoftware.prettier4j.ansi.ColorXterm;
import com.opencastsoftware.prettier4j.ansi.DisplayStyle;
import com.opencastsoftware.prettier4j.ansi.Styles;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, consumers={"com.opencastsoftware.prettier4j"})
public class Attrs {
    private static final int MAX_SGR_PARAMS = 16;
    static final long FG_COLOR_TYPE_SHIFT = 56L;
    static final long FG_COLOR_SHIFT = 8L;
    static final long FG_COLOR_MASK = -1080863914863886081L;
    static final long BG_COLOR_TYPE_SHIFT = 60L;
    static final long BG_COLOR_SHIFT = 32L;
    static final long BG_COLOR_MASK = 0xF000000FFFFFFFFL;
    public static final long EMPTY = 0L;
    public static final long NULL = -1L;

    private Attrs() {
    }

    public static long withStyles(long attrs, Styles.StylesOperator ... styles) {
        for (Styles.StylesOperator style : styles) {
            attrs = style.applyAsLong(attrs);
        }
        return attrs;
    }

    public static String transition(long prev, long next) {
        if (next == -1L) {
            return Attrs.isEmpty(prev) ? "" : "\u001b[0m";
        }
        int[] sgrParams = new int[16];
        int sgrParamsCount = 0;
        if ((Attrs.isBold(next) || Attrs.isFaint(next)) ^ (Attrs.isBold(prev) || Attrs.isFaint(prev))) {
            sgrParams[sgrParamsCount++] = Attrs.isBold(next) ? DisplayStyle.BOLD.code() : (Attrs.isFaint(next) ? DisplayStyle.FAINT.code() : DisplayStyle.NORMAL_INTENSITY.code());
        }
        if (Attrs.isItalic(next) ^ Attrs.isItalic(prev)) {
            int n = sgrParams[sgrParamsCount++] = Attrs.isItalic(next) ? DisplayStyle.ITALIC.code() : DisplayStyle.ITALIC_OFF.code();
        }
        if (Attrs.isUnderline(next) ^ Attrs.isUnderline(prev)) {
            int n = sgrParams[sgrParamsCount++] = Attrs.isUnderline(next) ? DisplayStyle.UNDERLINE.code() : DisplayStyle.UNDERLINE_OFF.code();
        }
        if (Attrs.isBlink(next) ^ Attrs.isBlink(prev)) {
            int n = sgrParams[sgrParamsCount++] = Attrs.isBlink(next) ? DisplayStyle.BLINK.code() : DisplayStyle.BLINK_OFF.code();
        }
        if (Attrs.isInverse(next) ^ Attrs.isInverse(prev)) {
            int n = sgrParams[sgrParamsCount++] = Attrs.isInverse(next) ? DisplayStyle.INVERSE.code() : DisplayStyle.INVERSE_OFF.code();
        }
        if (Attrs.isStrikethrough(next) ^ Attrs.isStrikethrough(prev)) {
            sgrParams[sgrParamsCount++] = Attrs.isStrikethrough(next) ? DisplayStyle.STRIKETHROUGH.code() : DisplayStyle.STRIKETHROUGH_OFF.code();
        }
        Color nextFgColor = Attrs.fgColor(next);
        Color prevFgColor = Attrs.fgColor(prev);
        if (nextFgColor != null && !nextFgColor.equals(prevFgColor)) {
            for (int param : nextFgColor.fgParams()) {
                sgrParams[sgrParamsCount++] = param;
            }
        } else if (nextFgColor == null && prevFgColor != null) {
            sgrParams[sgrParamsCount++] = Color16.DEFAULT.fgCode();
        }
        Color nextBgColor = Attrs.bgColor(next);
        Color prevBgColor = Attrs.bgColor(prev);
        if (nextBgColor != null && !nextBgColor.equals(prevBgColor)) {
            for (int param : nextBgColor.bgParams()) {
                sgrParams[sgrParamsCount++] = param;
            }
        } else if (nextBgColor == null && prevBgColor != null) {
            sgrParams[sgrParamsCount++] = Color16.DEFAULT.bgCode();
        }
        if (sgrParamsCount == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder("\u001b[");
        for (int i = 0; i < sgrParamsCount; ++i) {
            if (i > 0) {
                result.append(';');
            }
            result.append(sgrParams[i]);
        }
        return result.append('m').toString();
    }

    private static ColorType colorType(long attrs, long shiftValue) {
        int colorTypeCode = (int)(attrs >>> (int)shiftValue) & 0xF;
        if (colorTypeCode == 0) {
            return null;
        }
        return ColorType.withCode(colorTypeCode);
    }

    public static ColorType fgColorType(long attrs) {
        if (attrs == -1L) {
            return null;
        }
        return Attrs.colorType(attrs, 56L);
    }

    public static ColorType bgColorType(long attrs) {
        if (attrs == -1L) {
            return null;
        }
        return Attrs.colorType(attrs, 60L);
    }

    private static Color color(long attrs, ColorType colorType, long shiftValue) {
        if (colorType == null) {
            return null;
        }
        int colorBits = (int)(attrs >>> (int)shiftValue) & 0xFFFFFF;
        switch (colorType) {
            case COLOR_16: {
                return Color16.withCode(colorBits);
            }
            case COLOR_XTERM: {
                return new ColorXterm(colorBits);
            }
            case COLOR_RGB: {
                return ColorRgb.fromPacked(colorBits);
            }
        }
        return null;
    }

    public static Color fgColor(long attrs) {
        if (attrs == -1L) {
            return null;
        }
        ColorType colorType = Attrs.fgColorType(attrs);
        return Attrs.color(attrs, colorType, 8L);
    }

    public static Color bgColor(long attrs) {
        if (attrs == -1L) {
            return null;
        }
        ColorType colorType = Attrs.bgColorType(attrs);
        return Attrs.color(attrs, colorType, 32L);
    }

    public static boolean isBold(long attrs) {
        return (attrs & 1L) > 0L;
    }

    public static boolean isFaint(long attrs) {
        return (attrs & 2L) > 0L;
    }

    public static boolean isItalic(long attrs) {
        return (attrs & 4L) > 0L;
    }

    public static boolean isUnderline(long attrs) {
        return (attrs & 8L) > 0L;
    }

    public static boolean isBlink(long attrs) {
        return (attrs & 0x10L) > 0L;
    }

    public static boolean isInverse(long attrs) {
        return (attrs & 0x20L) > 0L;
    }

    public static boolean isStrikethrough(long attrs) {
        return (attrs & 0x40L) > 0L;
    }

    public static boolean isEmpty(long attrs) {
        return attrs == 0L;
    }
}

