/*
 * Decompiled with CFR 0.152.
 */
package com.opencastsoftware.prettier4j;

import java.util.Objects;

public class RenderOptions {
    private static final RenderOptions DEFAULT = new RenderOptions(80, true);
    private final int lineWidth;
    private final boolean emitAnsiEscapes;

    RenderOptions(int lineWidth, boolean emitAnsiEscapes) {
        this.lineWidth = lineWidth;
        this.emitAnsiEscapes = emitAnsiEscapes;
    }

    public int lineWidth() {
        return this.lineWidth;
    }

    public boolean emitAnsiEscapes() {
        return this.emitAnsiEscapes;
    }

    public static RenderOptions defaults() {
        return DEFAULT;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderOptions that = (RenderOptions)o;
        return this.lineWidth == that.lineWidth && this.emitAnsiEscapes == that.emitAnsiEscapes;
    }

    public int hashCode() {
        return Objects.hash(this.lineWidth, this.emitAnsiEscapes);
    }

    public String toString() {
        return "RenderOptions[lineWidth=" + this.lineWidth + ", emitAnsiEscapes=" + this.emitAnsiEscapes + ']';
    }

    public static class Builder {
        private int lineWidth;
        private boolean emitAnsiEscapes;

        private Builder() {
        }

        public RenderOptions build() {
            return new RenderOptions(this.lineWidth, this.emitAnsiEscapes);
        }

        public Builder lineWidth(int width) {
            this.lineWidth = width;
            return this;
        }

        public Builder emitAnsiEscapes(boolean emitAnsi) {
            this.emitAnsiEscapes = emitAnsi;
            return this;
        }
    }
}

