/*
 * Decompiled with CFR 0.152.
 */
package com.opencastsoftware.prettier4j;

import com.opencastsoftware.prettier4j.RenderOptions;
import com.opencastsoftware.prettier4j.ansi.Attrs;
import com.opencastsoftware.prettier4j.ansi.AttrsStack;
import com.opencastsoftware.prettier4j.ansi.Styles;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;

public abstract class Doc {
    private Doc() {
    }

    abstract Doc flatten();

    abstract boolean hasParams();

    public abstract Doc bind(String var1, Doc var2);

    public abstract Doc bind(Map<String, Doc> var1);

    public Doc bind(Object ... bindings) {
        if (bindings.length % 2 != 0) {
            throw new IllegalArgumentException("String-to-Doc pairs of arguments must be provided, but " + bindings.length + " arguments were found.");
        }
        HashMap<String, Doc> bindingsMap = new HashMap<String, Doc>();
        for (int i = 0; i < bindings.length; i += 2) {
            if (!(bindings[i] instanceof String)) {
                throw new IllegalArgumentException("Key type must be String, but was " + bindings[i].getClass().getSimpleName() + " at index " + i + '.');
            }
            if (!(bindings[i + 1] instanceof Doc)) {
                throw new IllegalArgumentException("Value type must be Doc, but was " + bindings[i + 1].getClass().getSimpleName() + " at index" + (i + 1) + '.');
            }
            bindingsMap.put((String)bindings[i], (Doc)bindings[i + 1]);
        }
        return this.bind(bindingsMap);
    }

    public Doc bind(String name, String value) {
        return this.bind(name, Doc.text(value));
    }

    public Doc append(Doc other) {
        return new Append(this, other);
    }

    public Doc appendSpace(Doc other) {
        return this.append(Doc.text(" ")).append(other);
    }

    public Doc appendLine(Doc other) {
        return this.append(Doc.line()).append(other);
    }

    public Doc appendLineOrSpace(Doc other) {
        return this.append(Doc.lineOrSpace()).append(other);
    }

    public Doc appendLineOrEmpty(Doc other) {
        return this.append(Doc.lineOrEmpty()).append(other);
    }

    public Doc appendLineOr(String altText, Doc other) {
        return this.appendLineOr(Doc.text(altText), other);
    }

    public Doc appendLineOr(Doc altDoc, Doc other) {
        return this.append(Doc.lineOr(altDoc)).append(other);
    }

    public Doc indent(int indent) {
        return Doc.indent(indent, this);
    }

    public Doc bracket(int indent, String left, String right) {
        return this.bracket(indent, Doc.text(left), Doc.text(right));
    }

    public Doc bracket(int indent, Doc left, Doc right) {
        return this.bracket(indent, Doc.lineOrSpace(), left, right);
    }

    public Doc bracket(int indent, Doc lineDoc, String left, String right) {
        return this.bracket(indent, lineDoc, Doc.text(left), Doc.text(right));
    }

    public Doc bracket(int indent, Doc lineDoc, Doc left, Doc right) {
        return Doc.group(left.append(lineDoc.append(this).indent(indent)).append(lineDoc.append(right)));
    }

    public final Doc styled(Styles.StylesOperator ... styles) {
        return Doc.styled(this, styles);
    }

    public String render() {
        return Doc.render(this);
    }

    public String render(RenderOptions options) {
        return Doc.render(this, options);
    }

    public void render(Appendable output) throws IOException {
        Doc.render(this, output);
    }

    public String render(int width) {
        return Doc.render(this, new RenderOptions(width, true));
    }

    public void render(int width, Appendable output) throws IOException {
        Doc.render(this, new RenderOptions(width, true), output);
    }

    public void render(RenderOptions options, Appendable output) throws IOException {
        Doc.render(this, options, output);
    }

    public static Doc text(String text) {
        return new Text(text);
    }

    static Doc alternatives(Doc left, Doc right) {
        return new Alternatives(left, right);
    }

    public static Doc indent(int indent, Doc doc) {
        return new Indent(indent, doc);
    }

    public static Doc line() {
        return Line.getInstance();
    }

    public static Doc lineOrEmpty() {
        return LineOrEmpty.getInstance();
    }

    public static Doc lineOrSpace() {
        return LineOrSpace.getInstance();
    }

    public static Doc empty() {
        return Empty.getInstance();
    }

    public static Doc lineOr(Doc altDoc) {
        return new LineOr(altDoc);
    }

    public static Doc lineOr(String altText) {
        return new LineOr(Doc.text(altText));
    }

    public static Doc styled(Doc doc, Styles.StylesOperator ... styles) {
        return new Styled(doc, styles);
    }

    public static Doc param(String name) {
        return new Param(name);
    }

    public static Doc fold(Collection<Doc> documents, BinaryOperator<Doc> fn) {
        return Doc.fold(documents.stream(), fn);
    }

    public static Doc fold(Stream<Doc> documents, BinaryOperator<Doc> fn) {
        return documents.reduce(fn).orElse(Doc.empty());
    }

    public static Doc intersperse(Doc separator, Collection<Doc> documents) {
        return Doc.intersperse(separator, documents.stream());
    }

    public static Doc intersperse(Doc separator, Stream<Doc> documents) {
        return Doc.fold(documents, (left, right) -> left.append(separator).append((Doc)right));
    }

    public static Doc group(Doc doc) {
        return Doc.alternatives(doc.flatten(), doc);
    }

    static boolean fits(int remaining, Deque<Map.Entry<Integer, Doc>> entries) {
        if (remaining < 0) {
            return false;
        }
        for (Map.Entry<Integer, Doc> entry : entries) {
            Doc entryDoc = entry.getValue();
            if (entryDoc instanceof Text) {
                Text textDoc = (Text)entryDoc;
                if ((remaining -= textDoc.text().length()) >= 0) continue;
                return false;
            }
            if (!(entryDoc instanceof LineOr)) continue;
            return true;
        }
        return true;
    }

    static Deque<Map.Entry<Integer, Doc>> chooseLayout(Doc left, Doc right, RenderOptions options, int indent, int position) {
        Deque<Map.Entry<Integer, Doc>> leftEntries = Doc.normalize(left, options, indent, position);
        int remaining = options.lineWidth() - position;
        if (Doc.fits(remaining, leftEntries)) {
            return leftEntries;
        }
        return Doc.normalize(right, options, indent, position);
    }

    static Deque<Map.Entry<Integer, Doc>> normalize(Doc doc, RenderOptions options, int indent, int position) {
        ArrayDeque<AbstractMap.SimpleEntry<Integer, Doc>> inQueue = new ArrayDeque<AbstractMap.SimpleEntry<Integer, Doc>>();
        ArrayDeque<Map.Entry<Integer, Doc>> outQueue = new ArrayDeque<Map.Entry<Integer, Doc>>();
        inQueue.add(new AbstractMap.SimpleEntry<Integer, Doc>(indent, doc));
        while (!inQueue.isEmpty()) {
            Map.Entry topEntry = (Map.Entry)inQueue.removeFirst();
            int entryIndent = (Integer)topEntry.getKey();
            Doc entryDoc = (Doc)topEntry.getValue();
            if (entryDoc instanceof Append) {
                Append appendDoc = (Append)entryDoc;
                inQueue.addFirst(new AbstractMap.SimpleEntry<Integer, Doc>(entryIndent, appendDoc.right()));
                inQueue.addFirst(new AbstractMap.SimpleEntry<Integer, Doc>(entryIndent, appendDoc.left()));
                continue;
            }
            if (entryDoc instanceof Styled) {
                Styled styledDoc = (Styled)entryDoc;
                if (options.emitAnsiEscapes()) {
                    inQueue.addFirst(new AbstractMap.SimpleEntry<Integer, Reset>(entryIndent, Reset.getInstance()));
                    inQueue.addFirst(new AbstractMap.SimpleEntry<Integer, Doc>(entryIndent, styledDoc.doc()));
                    inQueue.addFirst(new AbstractMap.SimpleEntry<Integer, Escape>(entryIndent, new Escape(styledDoc.styles())));
                    continue;
                }
                inQueue.addFirst(new AbstractMap.SimpleEntry<Integer, Doc>(entryIndent, styledDoc.doc()));
                continue;
            }
            if (entryDoc instanceof Indent) {
                Indent indentDoc = (Indent)entryDoc;
                int newIndent = entryIndent + indentDoc.indent();
                inQueue.addFirst(new AbstractMap.SimpleEntry<Integer, Doc>(newIndent, indentDoc.doc()));
                continue;
            }
            if (entryDoc instanceof Alternatives) {
                Alternatives altDoc = (Alternatives)entryDoc;
                Deque<Map.Entry<Integer, Doc>> chosenEntries = Doc.chooseLayout(altDoc.left(), altDoc.right(), options, entryIndent, position);
                chosenEntries.descendingIterator().forEachRemaining(inQueue::addFirst);
                continue;
            }
            if (entryDoc instanceof Text) {
                Text textDoc = (Text)entryDoc;
                position += textDoc.text().length();
                outQueue.addLast(topEntry);
                continue;
            }
            if (entryDoc instanceof LineOr) {
                position = entryIndent;
                outQueue.addLast(topEntry);
                continue;
            }
            if (entryDoc instanceof Escape) {
                outQueue.addLast(topEntry);
                continue;
            }
            if (!(entryDoc instanceof Reset)) continue;
            outQueue.addLast(topEntry);
        }
        return outQueue;
    }

    public static void render(Doc doc, RenderOptions options, Appendable output) throws IOException {
        if (doc.hasParams()) {
            throw new IllegalStateException("This Doc contains unbound parameters");
        }
        Deque<Map.Entry<Integer, Doc>> renderQueue = Doc.normalize(doc, options, 0, 0);
        AttrsStack attrsStack = new AttrsStack();
        for (Map.Entry<Integer, Doc> entry : renderQueue) {
            int entryIndent = entry.getKey();
            Doc entryDoc = entry.getValue();
            if (entryDoc instanceof Text) {
                Text textDoc = (Text)entryDoc;
                output.append(textDoc.text());
                continue;
            }
            if (entryDoc instanceof LineOr) {
                output.append(System.lineSeparator());
                for (int i = 0; i < entryIndent; ++i) {
                    output.append(' ');
                }
                continue;
            }
            if (entryDoc instanceof Reset) {
                long resetAttrs = attrsStack.popLast();
                long prevAttrs = attrsStack.peekLast();
                output.append(Attrs.transition(resetAttrs, prevAttrs));
                continue;
            }
            if (!(entryDoc instanceof Escape)) continue;
            Escape escapeDoc = (Escape)entryDoc;
            long prevAttrs = attrsStack.peekLast();
            if (prevAttrs == -1L) {
                prevAttrs = 0L;
            }
            long newAttrs = Attrs.withStyles(prevAttrs, escapeDoc.styles());
            attrsStack.pushLast(newAttrs);
            output.append(Attrs.transition(prevAttrs, newAttrs));
        }
    }

    public static void render(Doc doc, Appendable output) throws IOException {
        Doc.render(doc, RenderOptions.defaults(), output);
    }

    public static String render(Doc doc, RenderOptions options) {
        StringBuilder output = new StringBuilder();
        try {
            Doc.render(doc, options, output);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        return output.toString();
    }

    public static String render(Doc doc) {
        return Doc.render(doc, RenderOptions.defaults());
    }

    public static class Param
    extends Doc {
        private final String name;
        private final boolean flattened;

        private Param(String name, boolean flattened) {
            this.name = name;
            this.flattened = flattened;
        }

        Param(String name) {
            this(name, false);
        }

        public String name() {
            return this.name;
        }

        @Override
        Doc flatten() {
            return new Param(this.name, true);
        }

        @Override
        boolean hasParams() {
            return true;
        }

        @Override
        public Doc bind(String name, Doc value) {
            if (this.name.equals(name)) {
                return this.flattened ? value.flatten() : value;
            }
            return this;
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            Doc value = bindings.getOrDefault(this.name, this);
            if (value != this) {
                return this.flattened ? value.flatten() : value;
            }
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Param param = (Param)o;
            return this.flattened == param.flattened && Objects.equals(this.name, param.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.flattened);
        }

        public String toString() {
            return "Param[name='" + this.name + '\'' + ", flattened=" + this.flattened + ']';
        }
    }

    public static class Reset
    extends Doc {
        private static final Reset INSTANCE = new Reset();

        static Reset getInstance() {
            return INSTANCE;
        }

        Reset() {
        }

        @Override
        Doc flatten() {
            return this;
        }

        @Override
        boolean hasParams() {
            return false;
        }

        @Override
        public Doc bind(String name, Doc value) {
            return this;
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            return this;
        }

        public String toString() {
            return "Reset []";
        }
    }

    public static class Escape
    extends Doc {
        private final Styles.StylesOperator[] styles;

        public Escape(Styles.StylesOperator[] styles) {
            this.styles = styles;
        }

        public Styles.StylesOperator[] styles() {
            return this.styles;
        }

        @Override
        Doc flatten() {
            return this;
        }

        @Override
        boolean hasParams() {
            return false;
        }

        @Override
        public Doc bind(String name, Doc value) {
            return this;
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Escape escape = (Escape)o;
            return Objects.deepEquals(this.styles, escape.styles);
        }

        public int hashCode() {
            return Arrays.hashCode(this.styles);
        }

        public String toString() {
            return "Escape [styles=" + Arrays.toString(this.styles) + ']';
        }
    }

    public static class Styled
    extends Doc {
        private final Doc doc;
        private final Styles.StylesOperator[] styles;

        Styled(Doc doc, Styles.StylesOperator[] styles) {
            this.doc = doc;
            this.styles = styles;
        }

        public Doc doc() {
            return this.doc;
        }

        public Styles.StylesOperator[] styles() {
            return this.styles;
        }

        @Override
        Doc flatten() {
            return new Styled(this.doc.flatten(), this.styles);
        }

        @Override
        boolean hasParams() {
            return this.doc.hasParams();
        }

        @Override
        public Doc bind(String name, Doc value) {
            return new Styled(this.doc.bind(name, value), this.styles);
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            return new Styled(this.doc.bind(bindings), this.styles);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Styled styled = (Styled)o;
            return Objects.equals(this.doc, styled.doc) && Objects.deepEquals(this.styles, styled.styles);
        }

        public int hashCode() {
            return Objects.hash(this.doc, Arrays.hashCode(this.styles));
        }

        public String toString() {
            return "Styled [doc=" + this.doc + ", styles=" + Arrays.toString(this.styles) + ']';
        }
    }

    public static class Empty
    extends Doc {
        private static final Empty INSTANCE = new Empty();

        static Empty getInstance() {
            return INSTANCE;
        }

        Empty() {
        }

        @Override
        Doc flatten() {
            return this;
        }

        @Override
        boolean hasParams() {
            return false;
        }

        @Override
        public Doc bind(String name, Doc value) {
            return this;
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            return this;
        }

        public String toString() {
            return "Empty []";
        }
    }

    public static class LineOr
    extends Doc {
        private final Doc altDoc;

        protected LineOr() {
            this.altDoc = this;
        }

        protected LineOr(Doc altDoc) {
            this.altDoc = altDoc;
        }

        @Override
        Doc flatten() {
            return this.altDoc != this ? this.altDoc.flatten() : this.altDoc;
        }

        @Override
        boolean hasParams() {
            return this.altDoc != this && this.altDoc.hasParams();
        }

        @Override
        public Doc bind(String name, Doc value) {
            return new LineOr(this.altDoc.bind(name, value));
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            return new LineOr(this.altDoc.bind(bindings));
        }

        public String toString() {
            return "LineOr [altDoc=" + this.altDoc + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.altDoc == null || this == this.altDoc ? 0 : this.altDoc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LineOr other = (LineOr)obj;
            if (this.altDoc == null) {
                if (other.altDoc != null) {
                    return false;
                }
            } else {
                if (this == this.altDoc) {
                    return false;
                }
                if (!this.altDoc.equals(other.altDoc)) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class LineOrSpace
    extends LineOr {
        private static final LineOrSpace INSTANCE = new LineOrSpace();

        static LineOrSpace getInstance() {
            return INSTANCE;
        }

        LineOrSpace() {
            super(LineOrSpace.text(" "));
        }

        @Override
        public Doc bind(String name, Doc value) {
            return this;
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            return this;
        }

        @Override
        public String toString() {
            return "LineOrSpace []";
        }
    }

    public static class LineOrEmpty
    extends LineOr {
        private static final LineOrEmpty INSTANCE = new LineOrEmpty();

        static LineOrEmpty getInstance() {
            return INSTANCE;
        }

        public LineOrEmpty() {
            super(LineOrEmpty.empty());
        }

        @Override
        public Doc bind(String name, Doc value) {
            return this;
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            return this;
        }

        @Override
        public String toString() {
            return "LineOrEmpty []";
        }
    }

    public static class Line
    extends LineOr {
        private static final Line INSTANCE = new Line();

        static Line getInstance() {
            return INSTANCE;
        }

        @Override
        public Doc bind(String name, Doc value) {
            return this;
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            return this;
        }

        @Override
        public String toString() {
            return "Line []";
        }
    }

    public static class Indent
    extends Doc {
        private final int indent;
        private final Doc doc;

        Indent(int indent, Doc doc) {
            this.indent = indent;
            this.doc = doc;
        }

        public int indent() {
            return this.indent;
        }

        public Doc doc() {
            return this.doc;
        }

        @Override
        Doc flatten() {
            return this.doc.flatten().indent(this.indent);
        }

        @Override
        boolean hasParams() {
            return this.doc.hasParams();
        }

        @Override
        public Doc bind(String name, Doc value) {
            return new Indent(this.indent, this.doc.bind(name, value));
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            return new Indent(this.indent, this.doc.bind(bindings));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.indent;
            result = 31 * result + (this.doc == null ? 0 : this.doc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Indent other = (Indent)obj;
            if (this.indent != other.indent) {
                return false;
            }
            return !(this.doc == null ? other.doc != null : !this.doc.equals(other.doc));
        }

        public String toString() {
            return "Indent [indent=" + this.indent + ", doc=" + this.doc + "]";
        }
    }

    public static class Alternatives
    extends Doc {
        private final Doc left;
        private final Doc right;

        Alternatives(Doc left, Doc right) {
            this.left = left;
            this.right = right;
        }

        public Doc left() {
            return this.left;
        }

        public Doc right() {
            return this.right;
        }

        @Override
        Doc flatten() {
            return this.left.flatten();
        }

        @Override
        boolean hasParams() {
            return this.left.hasParams() || this.right.hasParams();
        }

        @Override
        public Doc bind(String name, Doc value) {
            return new Alternatives(this.left.bind(name, value), this.right.bind(name, value));
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            return new Alternatives(this.left.bind(bindings), this.right.bind(bindings));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Alternatives other = (Alternatives)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        public String toString() {
            return "Alternatives [left=" + this.left + ", right=" + this.right + "]";
        }
    }

    public static class Append
    extends Doc {
        private final Doc left;
        private final Doc right;

        Append(Doc left, Doc right) {
            this.left = left;
            this.right = right;
        }

        public Doc left() {
            return this.left;
        }

        public Doc right() {
            return this.right;
        }

        @Override
        Doc flatten() {
            return this.left.flatten().append(this.right.flatten());
        }

        @Override
        boolean hasParams() {
            return this.left.hasParams() || this.right.hasParams();
        }

        @Override
        public Doc bind(String name, Doc value) {
            return new Append(this.left.bind(name, value), this.right.bind(name, value));
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            return new Append(this.left.bind(bindings), this.right.bind(bindings));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Append other = (Append)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        public String toString() {
            return "Append [left=" + this.left + ", right=" + this.right + "]";
        }
    }

    public static class Text
    extends Doc {
        private final String text;

        Text(String text) {
            this.text = text;
        }

        public String text() {
            return this.text;
        }

        @Override
        Doc flatten() {
            return this;
        }

        @Override
        boolean hasParams() {
            return false;
        }

        @Override
        public Doc bind(String name, Doc value) {
            return this;
        }

        @Override
        public Doc bind(Map<String, Doc> bindings) {
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Text other = (Text)obj;
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }

        public String toString() {
            return "Text [text=" + this.text + "]";
        }
    }
}

