/*
 * Decompiled with CFR 0.152.
 */
package com.openai.models.audio.translations;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.openai.core.BaseDeserializer;
import com.openai.core.BaseSerializer;
import com.openai.core.JsonValue;
import com.openai.core.Utils;
import com.openai.errors.OpenAIInvalidDataException;
import com.openai.models.audio.translations.Translation;
import com.openai.models.audio.translations.TranslationCreateResponse;
import com.openai.models.audio.translations.TranslationVerbose;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0004\u001f !\"B+\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u001f\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0005J\u0013\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\nJ\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bJ\u0006\u0010\u001c\u001a\u00020\u0000J\r\u0010\u001d\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001eJ\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateResponse;", "", "translation", "Lcom/openai/models/audio/translations/Translation;", "verbose", "Lcom/openai/models/audio/translations/TranslationVerbose;", "_json", "Lcom/openai/core/JsonValue;", "(Lcom/openai/models/audio/translations/Translation;Lcom/openai/models/audio/translations/TranslationVerbose;Lcom/openai/core/JsonValue;)V", "validated", "", "Ljava/util/Optional;", "accept", "T", "visitor", "Lcom/openai/models/audio/translations/TranslationCreateResponse$Visitor;", "(Lcom/openai/models/audio/translations/TranslationCreateResponse$Visitor;)Ljava/lang/Object;", "asTranslation", "asVerbose", "equals", "other", "hashCode", "", "isTranslation", "isValid", "isVerbose", "toString", "", "validate", "validity", "validity$openai_java_core", "Companion", "Deserializer", "Serializer", "Visitor", "openai-java-core"})
public final class TranslationCreateResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Translation translation;
    @Nullable
    private final TranslationVerbose verbose;
    @Nullable
    private final JsonValue _json;
    private boolean validated;

    private TranslationCreateResponse(Translation translation, TranslationVerbose verbose, JsonValue _json) {
        this.translation = translation;
        this.verbose = verbose;
        this._json = _json;
    }

    /* synthetic */ TranslationCreateResponse(Translation translation, TranslationVerbose translationVerbose, JsonValue jsonValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            translation = null;
        }
        if ((n & 2) != 0) {
            translationVerbose = null;
        }
        if ((n & 4) != 0) {
            jsonValue = null;
        }
        this(translation, translationVerbose, jsonValue);
    }

    @NotNull
    public final Optional<Translation> translation() {
        Optional<Translation> optional = Optional.ofNullable(this.translation);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(translation)");
        return optional;
    }

    @NotNull
    public final Optional<TranslationVerbose> verbose() {
        Optional<TranslationVerbose> optional = Optional.ofNullable(this.verbose);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(verbose)");
        return optional;
    }

    public final boolean isTranslation() {
        return this.translation != null;
    }

    public final boolean isVerbose() {
        return this.verbose != null;
    }

    @NotNull
    public final Translation asTranslation() {
        return (Translation)Utils.getOrThrow(this.translation, "translation");
    }

    @NotNull
    public final TranslationVerbose asVerbose() {
        return (TranslationVerbose)Utils.getOrThrow(this.verbose, "verbose");
    }

    @NotNull
    public final Optional<JsonValue> _json() {
        Optional<JsonValue> optional = Optional.ofNullable(this._json);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(_json)");
        return optional;
    }

    public final <T> T accept(@NotNull Visitor<? extends T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return this.translation != null ? visitor.visitTranslation(this.translation) : (this.verbose != null ? visitor.visitVerbose(this.verbose) : visitor.unknown(this._json));
    }

    @NotNull
    public final TranslationCreateResponse validate() {
        TranslationCreateResponse translationCreateResponse;
        TranslationCreateResponse $this$validate_u24lambda_u240 = translationCreateResponse = this;
        boolean bl = false;
        if (!$this$validate_u24lambda_u240.validated) {
            $this$validate_u24lambda_u240.accept((Visitor)new Visitor<Unit>(){

                public void visitTranslation(@NotNull Translation translation) {
                    Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
                    translation.validate();
                }

                public void visitVerbose(@NotNull TranslationVerbose verbose) {
                    Intrinsics.checkNotNullParameter((Object)verbose, (String)"verbose");
                    verbose.validate();
                }
            });
            $this$validate_u24lambda_u240.validated = true;
        }
        return translationCreateResponse;
    }

    public final boolean isValid() {
        boolean bl;
        try {
            this.validate();
            bl = true;
        }
        catch (OpenAIInvalidDataException e) {
            bl = false;
        }
        return bl;
    }

    public final /* synthetic */ int validity$openai_java_core() {
        return ((Number)this.accept((Visitor)new Visitor<Integer>(){

            @NotNull
            public Integer visitTranslation(@NotNull Translation translation) {
                Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
                return translation.validity$openai_java_core();
            }

            @NotNull
            public Integer visitVerbose(@NotNull TranslationVerbose verbose) {
                Intrinsics.checkNotNullParameter((Object)verbose, (String)"verbose");
                return verbose.validity$openai_java_core();
            }

            @NotNull
            public Integer unknown(@Nullable JsonValue json2) {
                return 0;
            }
        })).intValue();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TranslationCreateResponse && Intrinsics.areEqual((Object)this.translation, (Object)((TranslationCreateResponse)other).translation) && Intrinsics.areEqual((Object)this.verbose, (Object)((TranslationCreateResponse)other).verbose);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.translation, this.verbose};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        String string;
        if (this.translation != null) {
            string = "TranslationCreateResponse{translation=" + this.translation + '}';
        } else if (this.verbose != null) {
            string = "TranslationCreateResponse{verbose=" + this.verbose + '}';
        } else if (this._json != null) {
            string = "TranslationCreateResponse{_unknown=" + this._json + '}';
        } else {
            throw new IllegalStateException("Invalid TranslationCreateResponse");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final TranslationCreateResponse ofTranslation(@NotNull Translation translation) {
        return Companion.ofTranslation(translation);
    }

    @JvmStatic
    @NotNull
    public static final TranslationCreateResponse ofVerbose(@NotNull TranslationVerbose verbose) {
        return Companion.ofVerbose(verbose);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateResponse$Companion;", "", "()V", "ofTranslation", "Lcom/openai/models/audio/translations/TranslationCreateResponse;", "translation", "Lcom/openai/models/audio/translations/Translation;", "ofVerbose", "verbose", "Lcom/openai/models/audio/translations/TranslationVerbose;", "openai-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TranslationCreateResponse ofTranslation(@NotNull Translation translation) {
            Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
            return new TranslationCreateResponse(translation, null, null, 6, null);
        }

        @JvmStatic
        @NotNull
        public final TranslationCreateResponse ofVerbose(@NotNull TranslationVerbose verbose) {
            Intrinsics.checkNotNullParameter((Object)verbose, (String)"verbose");
            return new TranslationCreateResponse(null, verbose, null, 5, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateResponse$Deserializer;", "Lcom/openai/core/BaseDeserializer;", "Lcom/openai/models/audio/translations/TranslationCreateResponse;", "()V", "deserialize", "Lcom/fasterxml/jackson/core/ObjectCodec;", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "openai-java-core"})
    @SourceDebugExtension(value={"SMAP\nTranslationCreateResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationCreateResponse.kt\ncom/openai/models/audio/translations/TranslationCreateResponse$Deserializer\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n43#2:198\n43#2:199\n288#3,2:200\n*S KotlinDebug\n*F\n+ 1 TranslationCreateResponse.kt\ncom/openai/models/audio/translations/TranslationCreateResponse$Deserializer\n*L\n158#1:198\n161#1:199\n175#1:200,2\n*E\n"})
    public static final class Deserializer
    extends BaseDeserializer<TranslationCreateResponse> {
        public Deserializer() {
            super(Reflection.getOrCreateKotlinClass(TranslationCreateResponse.class));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected TranslationCreateResponse deserialize(@NotNull ObjectCodec $this$deserialize, @NotNull JsonNode node) {
            Object v9;
            TranslationCreateResponse translationCreateResponse;
            List bestMatches2;
            block9: {
                TranslationCreateResponse translationCreateResponse2;
                TranslationCreateResponse translationCreateResponse3;
                TranslationCreateResponse translationCreateResponse4;
                TranslationVerbose it;
                Object[] objectArray;
                int n;
                int $i$f$jacksonTypeRef;
                Object[] objectArray2;
                Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                JsonValue json2 = JsonValue.Companion.fromJsonNode(node);
                Object[] objectArray3 = objectArray2 = new TranslationCreateResponse[2];
                int n2 = $i$f$jacksonTypeRef = 0;
                Translation translation = (Translation)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<Translation>(){});
                if (translation != null) {
                    Translation translation2 = translation;
                    n = n2;
                    objectArray = objectArray3;
                    boolean bl = false;
                    translationCreateResponse4 = new TranslationCreateResponse((Translation)((Object)it), null, json2, 2, null);
                    objectArray3 = objectArray;
                    n2 = n;
                    translationCreateResponse3 = translationCreateResponse4;
                } else {
                    translationCreateResponse3 = null;
                }
                objectArray3[n2] = translationCreateResponse3;
                Object[] objectArray4 = objectArray2;
                int n3 = 1;
                $i$f$jacksonTypeRef = 0;
                TranslationVerbose translationVerbose = (TranslationVerbose)this.tryDeserialize($this$deserialize, node, (TypeReference)new TypeReference<TranslationVerbose>(){});
                if (translationVerbose != null) {
                    it = translationVerbose;
                    n = n3;
                    objectArray = objectArray4;
                    boolean bl = false;
                    translationCreateResponse4 = new TranslationCreateResponse(null, it, json2, 1, null);
                    objectArray4 = objectArray;
                    n3 = n;
                    translationCreateResponse2 = translationCreateResponse4;
                } else {
                    translationCreateResponse2 = null;
                }
                objectArray4[n3] = translationCreateResponse2;
                bestMatches2 = CollectionsKt.toList((Iterable)Utils.allMaxBy(SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray2)), deserialize.bestMatches.3.INSTANCE));
                switch (bestMatches2.size()) {
                    case 0: {
                        translationCreateResponse = new TranslationCreateResponse(null, null, json2, 3, null);
                        return translationCreateResponse;
                    }
                    case 1: {
                        translationCreateResponse = (TranslationCreateResponse)CollectionsKt.single((List)bestMatches2);
                        return translationCreateResponse;
                    }
                }
                Iterable $this$firstOrNull$iv = bestMatches2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TranslationCreateResponse it2 = (TranslationCreateResponse)element$iv;
                    boolean bl = false;
                    if (!it2.isValid()) continue;
                    v9 = element$iv;
                    break block9;
                }
                v9 = null;
            }
            TranslationCreateResponse translationCreateResponse5 = v9;
            translationCreateResponse = translationCreateResponse5;
            if (translationCreateResponse5 != null) return translationCreateResponse;
            translationCreateResponse = (TranslationCreateResponse)CollectionsKt.first((List)bestMatches2);
            return translationCreateResponse;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateResponse$Serializer;", "Lcom/openai/core/BaseSerializer;", "Lcom/openai/models/audio/translations/TranslationCreateResponse;", "()V", "serialize", "", "value", "generator", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "openai-java-core"})
    public static final class Serializer
    extends BaseSerializer<TranslationCreateResponse> {
        public Serializer() {
            super(Reflection.getOrCreateKotlinClass(TranslationCreateResponse.class));
        }

        public void serialize(@NotNull TranslationCreateResponse value, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            if (value.translation != null) {
                generator.writeObject((Object)value.translation);
            } else if (value.verbose != null) {
                generator.writeObject((Object)value.verbose);
            } else if (value._json != null) {
                generator.writeObject((Object)value._json);
            } else {
                throw new IllegalStateException("Invalid TranslationCreateResponse");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/openai/models/audio/translations/TranslationCreateResponse$Visitor;", "T", "", "unknown", "json", "Lcom/openai/core/JsonValue;", "(Lcom/openai/core/JsonValue;)Ljava/lang/Object;", "visitTranslation", "translation", "Lcom/openai/models/audio/translations/Translation;", "(Lcom/openai/models/audio/translations/Translation;)Ljava/lang/Object;", "visitVerbose", "verbose", "Lcom/openai/models/audio/translations/TranslationVerbose;", "(Lcom/openai/models/audio/translations/TranslationVerbose;)Ljava/lang/Object;", "openai-java-core"})
    public static interface Visitor<T> {
        public T visitTranslation(@NotNull Translation var1);

        public T visitVerbose(@NotNull TranslationVerbose var1);

        default public T unknown(@Nullable JsonValue json2) {
            throw new OpenAIInvalidDataException("Unknown TranslationCreateResponse: " + json2, null, 2, null);
        }
    }
}

