// File generated from our OpenAPI spec by Stainless.

package com.openai.models

import com.fasterxml.jackson.annotation.JsonAnyGetter
import com.fasterxml.jackson.annotation.JsonAnySetter
import com.fasterxml.jackson.annotation.JsonProperty
import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.openai.core.ExcludeMissing
import com.openai.core.JsonField
import com.openai.core.JsonMissing
import com.openai.core.JsonValue
import com.openai.core.NoAutoDetect
import com.openai.core.toImmutable
import java.util.Objects
import java.util.Optional

/**
 * The settings for your integration with Weights and Biases. This payload specifies the project
 * that metrics will be sent to. Optionally, you can set an explicit display name for your run, add
 * tags to your run, and set a default entity (team, username, etc) to be associated with your run.
 */
@JsonDeserialize(builder = FineTuningJobWandbIntegration.Builder::class)
@NoAutoDetect
class FineTuningJobWandbIntegration
private constructor(
    private val project: JsonField<String>,
    private val name: JsonField<String>,
    private val entity: JsonField<String>,
    private val tags: JsonField<List<String>>,
    private val additionalProperties: Map<String, JsonValue>,
) {

    private var validated: Boolean = false

    /** The name of the project that the new run will be created under. */
    fun project(): String = project.getRequired("project")

    /** A display name to set for the run. If not set, we will use the Job ID as the name. */
    fun name(): Optional<String> = Optional.ofNullable(name.getNullable("name"))

    /**
     * The entity to use for the run. This allows you to set the team or username of the WandB user
     * that you would like associated with the run. If not set, the default entity for the
     * registered WandB API key is used.
     */
    fun entity(): Optional<String> = Optional.ofNullable(entity.getNullable("entity"))

    /**
     * A list of tags to be attached to the newly created run. These tags are passed through
     * directly to WandB. Some default tags are generated by OpenAI: "openai/finetune",
     * "openai/{base-model}", "openai/{ftjob-abcdef}".
     */
    fun tags(): Optional<List<String>> = Optional.ofNullable(tags.getNullable("tags"))

    /** The name of the project that the new run will be created under. */
    @JsonProperty("project") @ExcludeMissing fun _project() = project

    /** A display name to set for the run. If not set, we will use the Job ID as the name. */
    @JsonProperty("name") @ExcludeMissing fun _name() = name

    /**
     * The entity to use for the run. This allows you to set the team or username of the WandB user
     * that you would like associated with the run. If not set, the default entity for the
     * registered WandB API key is used.
     */
    @JsonProperty("entity") @ExcludeMissing fun _entity() = entity

    /**
     * A list of tags to be attached to the newly created run. These tags are passed through
     * directly to WandB. Some default tags are generated by OpenAI: "openai/finetune",
     * "openai/{base-model}", "openai/{ftjob-abcdef}".
     */
    @JsonProperty("tags") @ExcludeMissing fun _tags() = tags

    @JsonAnyGetter
    @ExcludeMissing
    fun _additionalProperties(): Map<String, JsonValue> = additionalProperties

    fun validate(): FineTuningJobWandbIntegration = apply {
        if (!validated) {
            project()
            name()
            entity()
            tags()
            validated = true
        }
    }

    fun toBuilder() = Builder().from(this)

    companion object {

        @JvmStatic fun builder() = Builder()
    }

    class Builder {

        private var project: JsonField<String> = JsonMissing.of()
        private var name: JsonField<String> = JsonMissing.of()
        private var entity: JsonField<String> = JsonMissing.of()
        private var tags: JsonField<List<String>> = JsonMissing.of()
        private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

        @JvmSynthetic
        internal fun from(fineTuningJobWandbIntegration: FineTuningJobWandbIntegration) = apply {
            this.project = fineTuningJobWandbIntegration.project
            this.name = fineTuningJobWandbIntegration.name
            this.entity = fineTuningJobWandbIntegration.entity
            this.tags = fineTuningJobWandbIntegration.tags
            additionalProperties(fineTuningJobWandbIntegration.additionalProperties)
        }

        /** The name of the project that the new run will be created under. */
        fun project(project: String) = project(JsonField.of(project))

        /** The name of the project that the new run will be created under. */
        @JsonProperty("project")
        @ExcludeMissing
        fun project(project: JsonField<String>) = apply { this.project = project }

        /** A display name to set for the run. If not set, we will use the Job ID as the name. */
        fun name(name: String) = name(JsonField.of(name))

        /** A display name to set for the run. If not set, we will use the Job ID as the name. */
        @JsonProperty("name")
        @ExcludeMissing
        fun name(name: JsonField<String>) = apply { this.name = name }

        /**
         * The entity to use for the run. This allows you to set the team or username of the WandB
         * user that you would like associated with the run. If not set, the default entity for the
         * registered WandB API key is used.
         */
        fun entity(entity: String) = entity(JsonField.of(entity))

        /**
         * The entity to use for the run. This allows you to set the team or username of the WandB
         * user that you would like associated with the run. If not set, the default entity for the
         * registered WandB API key is used.
         */
        @JsonProperty("entity")
        @ExcludeMissing
        fun entity(entity: JsonField<String>) = apply { this.entity = entity }

        /**
         * A list of tags to be attached to the newly created run. These tags are passed through
         * directly to WandB. Some default tags are generated by OpenAI: "openai/finetune",
         * "openai/{base-model}", "openai/{ftjob-abcdef}".
         */
        fun tags(tags: List<String>) = tags(JsonField.of(tags))

        /**
         * A list of tags to be attached to the newly created run. These tags are passed through
         * directly to WandB. Some default tags are generated by OpenAI: "openai/finetune",
         * "openai/{base-model}", "openai/{ftjob-abcdef}".
         */
        @JsonProperty("tags")
        @ExcludeMissing
        fun tags(tags: JsonField<List<String>>) = apply { this.tags = tags }

        fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
            this.additionalProperties.clear()
            this.additionalProperties.putAll(additionalProperties)
        }

        @JsonAnySetter
        fun putAdditionalProperty(key: String, value: JsonValue) = apply {
            this.additionalProperties.put(key, value)
        }

        fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
            this.additionalProperties.putAll(additionalProperties)
        }

        fun build(): FineTuningJobWandbIntegration =
            FineTuningJobWandbIntegration(
                project,
                name,
                entity,
                tags.map { it.toImmutable() },
                additionalProperties.toImmutable(),
            )
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) {
            return true
        }

        return /* spotless:off */ other is FineTuningJobWandbIntegration && project == other.project && name == other.name && entity == other.entity && tags == other.tags && additionalProperties == other.additionalProperties /* spotless:on */
    }

    /* spotless:off */
    private val hashCode: Int by lazy { Objects.hash(project, name, entity, tags, additionalProperties) }
    /* spotless:on */

    override fun hashCode(): Int = hashCode

    override fun toString() =
        "FineTuningJobWandbIntegration{project=$project, name=$name, entity=$entity, tags=$tags, additionalProperties=$additionalProperties}"
}
