/*
 * Decompiled with CFR 0.152.
 */
package com.openai.models.audio.transcriptions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.openai.core.Check;
import com.openai.core.Enum;
import com.openai.core.ExcludeMissing;
import com.openai.core.JsonField;
import com.openai.core.MultipartField;
import com.openai.core.Params;
import com.openai.core.Utils;
import com.openai.core.http.Headers;
import com.openai.core.http.QueryParams;
import com.openai.errors.OpenAIInvalidDataException;
import com.openai.models.audio.AudioModel;
import com.openai.models.audio.AudioResponseFormat;
import com.openai.models.audio.transcriptions.TranscriptionCreateParams;
import com.openai.models.audio.transcriptions.TranscriptionInclude;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 52\u00020\u0001:\u00043456B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u0007J\u001d\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\fH\u0000\u00a2\u0006\u0002\b\u000fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eJ\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u000eJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u000eJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000eJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u000eJ\b\u0010\u001a\u001a\u00020\u0007H\u0016J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000eJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000eJ\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00140\u000eJ\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\u0006\u0010%\u001a\u00020\u0011J\b\u0010&\u001a\u00020'H\u0016J\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140)J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0)J\u0006\u0010+\u001a\u00020\u0018J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0)J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0)J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001e0)J\u0012\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00140)J\u0006\u00100\u001a\u000201J\b\u00102\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams;", "Lcom/openai/core/Params;", "body", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Body;", "additionalHeaders", "Lcom/openai/core/http/Headers;", "additionalQueryParams", "Lcom/openai/core/http/QueryParams;", "(Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Body;Lcom/openai/core/http/Headers;Lcom/openai/core/http/QueryParams;)V", "_additionalHeaders", "_additionalQueryParams", "_body", "", "", "Lcom/openai/core/MultipartField;", "_body$openai_java_core", "_file", "Ljava/io/InputStream;", "_headers", "_include", "", "Lcom/openai/models/audio/transcriptions/TranscriptionInclude;", "_language", "_model", "Lcom/openai/models/audio/AudioModel;", "_prompt", "_queryParams", "_responseFormat", "Lcom/openai/models/audio/AudioResponseFormat;", "_temperature", "", "_timestampGranularities", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$TimestampGranularity;", "equals", "", "other", "", "file", "hashCode", "", "include", "Ljava/util/Optional;", "language", "model", "prompt", "responseFormat", "temperature", "timestampGranularities", "toBuilder", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Builder;", "toString", "Body", "Builder", "Companion", "TimestampGranularity", "openai-java-core"})
public final class TranscriptionCreateParams
implements Params {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Body body;
    @NotNull
    private final Headers additionalHeaders;
    @NotNull
    private final QueryParams additionalQueryParams;

    private TranscriptionCreateParams(Body body, Headers additionalHeaders, QueryParams additionalQueryParams) {
        this.body = body;
        this.additionalHeaders = additionalHeaders;
        this.additionalQueryParams = additionalQueryParams;
    }

    @NotNull
    public final InputStream file() {
        return this.body.file();
    }

    @NotNull
    public final AudioModel model() {
        return this.body.model();
    }

    @NotNull
    public final Optional<List<TranscriptionInclude>> include() {
        return this.body.include();
    }

    @NotNull
    public final Optional<String> language() {
        return this.body.language();
    }

    @NotNull
    public final Optional<String> prompt() {
        return this.body.prompt();
    }

    @NotNull
    public final Optional<AudioResponseFormat> responseFormat() {
        return this.body.responseFormat();
    }

    @NotNull
    public final Optional<Double> temperature() {
        return this.body.temperature();
    }

    @NotNull
    public final Optional<List<TimestampGranularity>> timestampGranularities() {
        return this.body.timestampGranularities();
    }

    @NotNull
    public final MultipartField<InputStream> _file() {
        return this.body._file();
    }

    @NotNull
    public final MultipartField<AudioModel> _model() {
        return this.body._model();
    }

    @NotNull
    public final MultipartField<List<TranscriptionInclude>> _include() {
        return this.body._include();
    }

    @NotNull
    public final MultipartField<String> _language() {
        return this.body._language();
    }

    @NotNull
    public final MultipartField<String> _prompt() {
        return this.body._prompt();
    }

    @NotNull
    public final MultipartField<AudioResponseFormat> _responseFormat() {
        return this.body._responseFormat();
    }

    @NotNull
    public final MultipartField<Double> _temperature() {
        return this.body._temperature();
    }

    @NotNull
    public final MultipartField<List<TimestampGranularity>> _timestampGranularities() {
        return this.body._timestampGranularities();
    }

    @NotNull
    public final Headers _additionalHeaders() {
        return this.additionalHeaders;
    }

    @NotNull
    public final QueryParams _additionalQueryParams() {
        return this.additionalQueryParams;
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder().from$openai_java_core(this);
    }

    public final /* synthetic */ Map _body$openai_java_core() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"file", this._file()), TuplesKt.to((Object)"model", this._model()), TuplesKt.to((Object)"include", this._include()), TuplesKt.to((Object)"language", this._language()), TuplesKt.to((Object)"prompt", this._prompt()), TuplesKt.to((Object)"response_format", this._responseFormat()), TuplesKt.to((Object)"temperature", this._temperature()), TuplesKt.to((Object)"timestamp_granularities", this._timestampGranularities())};
        return Utils.toImmutable(MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public Headers _headers() {
        return this.additionalHeaders;
    }

    @Override
    @NotNull
    public QueryParams _queryParams() {
        return this.additionalQueryParams;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TranscriptionCreateParams && Intrinsics.areEqual((Object)this.body, (Object)((TranscriptionCreateParams)other).body) && Intrinsics.areEqual((Object)this.additionalHeaders, (Object)((TranscriptionCreateParams)other).additionalHeaders) && Intrinsics.areEqual((Object)this.additionalQueryParams, (Object)((TranscriptionCreateParams)other).additionalQueryParams);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.body, this.additionalHeaders, this.additionalQueryParams};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "TranscriptionCreateParams{body=" + this.body + ", additionalHeaders=" + this.additionalHeaders + ", additionalQueryParams=" + this.additionalQueryParams + '}';
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    public /* synthetic */ TranscriptionCreateParams(Body body, Headers additionalHeaders, QueryParams additionalQueryParams, DefaultConstructorMarker $constructor_marker) {
        this(body, additionalHeaders, additionalQueryParams);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0002+,B\u0083\u0001\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003\u0012\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\b0\u0003\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u0014\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0003H\u0007J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003H\u0007J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u0007J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003H\u0007J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u0007J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003H\u0007J\u0014\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\b0\u0003H\u0007J\u0013\u0010$\u001a\u00020\u001b2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u0002\u001a\u00020\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0&J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0&J\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0&J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0&J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100&J\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\b0&J\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020\u000bH\u0016J\u0006\u0010*\u001a\u00020\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Body;", "", "file", "Lcom/openai/core/MultipartField;", "Ljava/io/InputStream;", "model", "Lcom/openai/models/audio/AudioModel;", "include", "", "Lcom/openai/models/audio/transcriptions/TranscriptionInclude;", "language", "", "prompt", "responseFormat", "Lcom/openai/models/audio/AudioResponseFormat;", "temperature", "", "timestampGranularities", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$TimestampGranularity;", "(Lcom/openai/core/MultipartField;Lcom/openai/core/MultipartField;Lcom/openai/core/MultipartField;Lcom/openai/core/MultipartField;Lcom/openai/core/MultipartField;Lcom/openai/core/MultipartField;Lcom/openai/core/MultipartField;Lcom/openai/core/MultipartField;)V", "hashCode", "", "getHashCode", "()I", "hashCode$delegate", "Lkotlin/Lazy;", "validated", "", "_file", "_include", "_language", "_model", "_prompt", "_responseFormat", "_temperature", "_timestampGranularities", "equals", "other", "Ljava/util/Optional;", "toBuilder", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Body$Builder;", "toString", "validate", "Builder", "Companion", "openai-java-core"})
    public static final class Body {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MultipartField<InputStream> file;
        @NotNull
        private final MultipartField<AudioModel> model;
        @NotNull
        private final MultipartField<List<TranscriptionInclude>> include;
        @NotNull
        private final MultipartField<String> language;
        @NotNull
        private final MultipartField<String> prompt;
        @NotNull
        private final MultipartField<AudioResponseFormat> responseFormat;
        @NotNull
        private final MultipartField<Double> temperature;
        @NotNull
        private final MultipartField<List<TimestampGranularity>> timestampGranularities;
        private boolean validated;
        @NotNull
        private final Lazy hashCode$delegate;

        private Body(MultipartField<InputStream> file, MultipartField<AudioModel> model, MultipartField<List<TranscriptionInclude>> include2, MultipartField<String> language, MultipartField<String> prompt, MultipartField<AudioResponseFormat> responseFormat, MultipartField<Double> temperature, MultipartField<List<TimestampGranularity>> timestampGranularities2) {
            this.file = file;
            this.model = model;
            this.include = include2;
            this.language = language;
            this.prompt = prompt;
            this.responseFormat = responseFormat;
            this.temperature = temperature;
            this.timestampGranularities = timestampGranularities2;
            this.hashCode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
                final /* synthetic */ Body this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    Object[] objectArray = new Object[]{Body.access$getFile$p(this.this$0), Body.access$getModel$p(this.this$0), Body.access$getInclude$p(this.this$0), Body.access$getLanguage$p(this.this$0), Body.access$getPrompt$p(this.this$0), Body.access$getResponseFormat$p(this.this$0), Body.access$getTemperature$p(this.this$0), Body.access$getTimestampGranularities$p(this.this$0)};
                    return Objects.hash(objectArray);
                }
            }));
        }

        @NotNull
        public final InputStream file() {
            return (InputStream)this.file.value().getRequired$openai_java_core("file");
        }

        @NotNull
        public final AudioModel model() {
            return (AudioModel)this.model.value().getRequired$openai_java_core("model");
        }

        @NotNull
        public final Optional<List<TranscriptionInclude>> include() {
            Optional<Object> optional = Optional.ofNullable(this.include.value().getNullable$openai_java_core("include"));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(include.value.getNullable(\"include\"))");
            return optional;
        }

        @NotNull
        public final Optional<String> language() {
            Optional<Object> optional = Optional.ofNullable(this.language.value().getNullable$openai_java_core("language"));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(language.value.getNullable(\"language\"))");
            return optional;
        }

        @NotNull
        public final Optional<String> prompt() {
            Optional<Object> optional = Optional.ofNullable(this.prompt.value().getNullable$openai_java_core("prompt"));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(prompt.value.getNullable(\"prompt\"))");
            return optional;
        }

        @NotNull
        public final Optional<AudioResponseFormat> responseFormat() {
            Optional<Object> optional = Optional.ofNullable(this.responseFormat.value().getNullable$openai_java_core("response_format"));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(responseForma\u2026lable(\"response_format\"))");
            return optional;
        }

        @NotNull
        public final Optional<Double> temperature() {
            Optional<Object> optional = Optional.ofNullable(this.temperature.value().getNullable$openai_java_core("temperature"));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(temperature.v\u2026tNullable(\"temperature\"))");
            return optional;
        }

        @NotNull
        public final Optional<List<TimestampGranularity>> timestampGranularities() {
            Optional<Object> optional = Optional.ofNullable(this.timestampGranularities.value().getNullable$openai_java_core("timestamp_granularities"));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(timestampGran\u2026imestamp_granularities\"))");
            return optional;
        }

        @JsonProperty(value="file")
        @ExcludeMissing
        @NotNull
        public final MultipartField<InputStream> _file() {
            return this.file;
        }

        @JsonProperty(value="model")
        @ExcludeMissing
        @NotNull
        public final MultipartField<AudioModel> _model() {
            return this.model;
        }

        @JsonProperty(value="include")
        @ExcludeMissing
        @NotNull
        public final MultipartField<List<TranscriptionInclude>> _include() {
            return this.include;
        }

        @JsonProperty(value="language")
        @ExcludeMissing
        @NotNull
        public final MultipartField<String> _language() {
            return this.language;
        }

        @JsonProperty(value="prompt")
        @ExcludeMissing
        @NotNull
        public final MultipartField<String> _prompt() {
            return this.prompt;
        }

        @JsonProperty(value="response_format")
        @ExcludeMissing
        @NotNull
        public final MultipartField<AudioResponseFormat> _responseFormat() {
            return this.responseFormat;
        }

        @JsonProperty(value="temperature")
        @ExcludeMissing
        @NotNull
        public final MultipartField<Double> _temperature() {
            return this.temperature;
        }

        @JsonProperty(value="timestamp_granularities")
        @ExcludeMissing
        @NotNull
        public final MultipartField<List<TimestampGranularity>> _timestampGranularities() {
            return this.timestampGranularities;
        }

        @NotNull
        public final Builder toBuilder() {
            return new Builder().from$openai_java_core(this);
        }

        @NotNull
        public final Body validate() {
            Body body;
            Body $this$validate_u24lambda_u240 = body = this;
            boolean bl = false;
            if (!$this$validate_u24lambda_u240.validated) {
                $this$validate_u24lambda_u240.file();
                $this$validate_u24lambda_u240.model();
                $this$validate_u24lambda_u240.include();
                $this$validate_u24lambda_u240.language();
                $this$validate_u24lambda_u240.prompt();
                $this$validate_u24lambda_u240.responseFormat();
                $this$validate_u24lambda_u240.temperature();
                $this$validate_u24lambda_u240.timestampGranularities();
                $this$validate_u24lambda_u240.validated = true;
            }
            return body;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Body && Intrinsics.areEqual(this.file, ((Body)other).file) && Intrinsics.areEqual(this.model, ((Body)other).model) && Intrinsics.areEqual(this.include, ((Body)other).include) && Intrinsics.areEqual(this.language, ((Body)other).language) && Intrinsics.areEqual(this.prompt, ((Body)other).prompt) && Intrinsics.areEqual(this.responseFormat, ((Body)other).responseFormat) && Intrinsics.areEqual(this.temperature, ((Body)other).temperature) && Intrinsics.areEqual(this.timestampGranularities, ((Body)other).timestampGranularities);
        }

        private final int getHashCode() {
            Lazy lazy = this.hashCode$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        public int hashCode() {
            return this.getHashCode();
        }

        @NotNull
        public String toString() {
            return "Body{file=" + this.file + ", model=" + this.model + ", include=" + this.include + ", language=" + this.language + ", prompt=" + this.prompt + ", responseFormat=" + this.responseFormat + ", temperature=" + this.temperature + ", timestampGranularities=" + this.timestampGranularities + '}';
        }

        @JvmStatic
        @NotNull
        public static final Builder builder() {
            return Companion.builder();
        }

        public /* synthetic */ Body(MultipartField file, MultipartField model, MultipartField include2, MultipartField language, MultipartField prompt, MultipartField responseFormat, MultipartField temperature, MultipartField timestampGranularities2, DefaultConstructorMarker $constructor_marker) {
            this(file, model, include2, language, prompt, responseFormat, temperature, timestampGranularities2);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0013J\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0003\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0005J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0019J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u001aJ\u0015\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001dJ\u001a\u0010\u0006\u001a\u00020\u00002\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001e0\u0004J\u0014\u0010\u0006\u001a\u00020\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u001eJ\u0014\u0010\t\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\nJ\u0014\u0010\r\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0004J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\nJ\u0014\u0010\u000e\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u00020\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001e0\u0004J\u0014\u0010\u0012\u001a\u00020\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u001eR\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0007\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Body$Builder;", "", "()V", "file", "Lcom/openai/core/MultipartField;", "Ljava/io/InputStream;", "include", "", "Lcom/openai/models/audio/transcriptions/TranscriptionInclude;", "language", "", "model", "Lcom/openai/models/audio/AudioModel;", "prompt", "responseFormat", "Lcom/openai/models/audio/AudioResponseFormat;", "temperature", "", "timestampGranularities", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$TimestampGranularity;", "addInclude", "addTimestampGranularity", "timestampGranularity", "build", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Body;", "Ljava/nio/file/Path;", "", "from", "body", "from$openai_java_core", "", "value", "openai-java-core"})
        @SourceDebugExtension(value={"SMAP\nTranscriptionCreateParams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranscriptionCreateParams.kt\ncom/openai/models/audio/transcriptions/TranscriptionCreateParams$Body$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1108:1\n1#2:1109\n*E\n"})
        public static final class Builder {
            @Nullable
            private MultipartField<InputStream> file;
            @Nullable
            private MultipartField<AudioModel> model;
            @Nullable
            private MultipartField<List<TranscriptionInclude>> include;
            @NotNull
            private MultipartField<String> language = MultipartField.Companion.of(null);
            @NotNull
            private MultipartField<String> prompt = MultipartField.Companion.of(null);
            @NotNull
            private MultipartField<AudioResponseFormat> responseFormat = MultipartField.Companion.of(null);
            @NotNull
            private MultipartField<Double> temperature = MultipartField.Companion.of(null);
            @Nullable
            private MultipartField<List<TimestampGranularity>> timestampGranularities;

            public final /* synthetic */ Builder from$openai_java_core(Body body) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Builder $this$from_u24lambda_u240 = builder = this;
                boolean bl = false;
                $this$from_u24lambda_u240.file = body.file;
                $this$from_u24lambda_u240.model = body.model;
                $this$from_u24lambda_u240.include = body.include.map$openai_java_core(from.1.1.INSTANCE);
                $this$from_u24lambda_u240.language = body.language;
                $this$from_u24lambda_u240.prompt = body.prompt;
                $this$from_u24lambda_u240.responseFormat = body.responseFormat;
                $this$from_u24lambda_u240.temperature = body.temperature;
                $this$from_u24lambda_u240.timestampGranularities = body.timestampGranularities.map$openai_java_core(from.1.2.INSTANCE);
                return builder;
            }

            @NotNull
            public final Builder file(@NotNull InputStream file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return this.file(MultipartField.Companion.of(file));
            }

            @NotNull
            public final Builder file(@NotNull MultipartField<InputStream> file) {
                Builder builder;
                Intrinsics.checkNotNullParameter(file, (String)"file");
                Builder $this$file_u24lambda_u241 = builder = this;
                boolean bl = false;
                $this$file_u24lambda_u241.file = file;
                return builder;
            }

            @NotNull
            public final Builder file(@NotNull byte[] file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return this.file(new ByteArrayInputStream(file));
            }

            @NotNull
            public final Builder file(@NotNull Path file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                MultipartField.Builder<InputStream> builder = MultipartField.Companion.builder();
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
                return this.file(builder.value(inputStream).filename(PathsKt.getName((Path)file)).build());
            }

            @NotNull
            public final Builder model(@NotNull AudioModel model) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                return this.model(MultipartField.Companion.of(model));
            }

            @NotNull
            public final Builder model(@NotNull MultipartField<AudioModel> model) {
                Builder builder;
                Intrinsics.checkNotNullParameter(model, (String)"model");
                Builder $this$model_u24lambda_u242 = builder = this;
                boolean bl = false;
                $this$model_u24lambda_u242.model = model;
                return builder;
            }

            @NotNull
            public final Builder model(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return this.model(AudioModel.Companion.of(value));
            }

            @NotNull
            public final Builder include(@NotNull List<TranscriptionInclude> include2) {
                Intrinsics.checkNotNullParameter(include2, (String)"include");
                return this.include(MultipartField.Companion.of(include2));
            }

            @NotNull
            public final Builder include(@NotNull MultipartField<List<TranscriptionInclude>> include2) {
                Builder builder;
                Intrinsics.checkNotNullParameter(include2, (String)"include");
                Builder $this$include_u24lambda_u243 = builder = this;
                boolean bl = false;
                $this$include_u24lambda_u243.include = include2.map$openai_java_core(include.1.1.INSTANCE);
                return builder;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Builder addInclude(@NotNull TranscriptionInclude include2) {
                void it;
                MultipartField<List<TranscriptionInclude>> multipartField;
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)include2, (String)"include");
                Builder $this$addInclude_u24lambda_u245 = builder = this;
                boolean bl = false;
                MultipartField<List<TranscriptionInclude>> multipartField2 = $this$addInclude_u24lambda_u245.include;
                if (multipartField2 == null) {
                    multipartField2 = MultipartField.Companion.of((List)new ArrayList());
                }
                MultipartField<List<TranscriptionInclude>> multipartField3 = multipartField = multipartField2;
                Builder builder2 = $this$addInclude_u24lambda_u245;
                boolean bl2 = false;
                ((List)Check.checkKnown("include", (MultipartField)it)).add(include2);
                builder2.include = multipartField;
                return builder;
            }

            @NotNull
            public final Builder language(@NotNull String language) {
                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                return this.language(MultipartField.Companion.of(language));
            }

            @NotNull
            public final Builder language(@NotNull MultipartField<String> language) {
                Builder builder;
                Intrinsics.checkNotNullParameter(language, (String)"language");
                Builder $this$language_u24lambda_u246 = builder = this;
                boolean bl = false;
                $this$language_u24lambda_u246.language = language;
                return builder;
            }

            @NotNull
            public final Builder prompt(@NotNull String prompt) {
                Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
                return this.prompt(MultipartField.Companion.of(prompt));
            }

            @NotNull
            public final Builder prompt(@NotNull MultipartField<String> prompt) {
                Builder builder;
                Intrinsics.checkNotNullParameter(prompt, (String)"prompt");
                Builder $this$prompt_u24lambda_u247 = builder = this;
                boolean bl = false;
                $this$prompt_u24lambda_u247.prompt = prompt;
                return builder;
            }

            @NotNull
            public final Builder responseFormat(@NotNull AudioResponseFormat responseFormat) {
                Intrinsics.checkNotNullParameter((Object)responseFormat, (String)"responseFormat");
                return this.responseFormat(MultipartField.Companion.of(responseFormat));
            }

            @NotNull
            public final Builder responseFormat(@NotNull MultipartField<AudioResponseFormat> responseFormat) {
                Builder builder;
                Intrinsics.checkNotNullParameter(responseFormat, (String)"responseFormat");
                Builder $this$responseFormat_u24lambda_u248 = builder = this;
                boolean bl = false;
                $this$responseFormat_u24lambda_u248.responseFormat = responseFormat;
                return builder;
            }

            @NotNull
            public final Builder temperature(double temperature) {
                return this.temperature(MultipartField.Companion.of(temperature));
            }

            @NotNull
            public final Builder temperature(@NotNull MultipartField<Double> temperature) {
                Builder builder;
                Intrinsics.checkNotNullParameter(temperature, (String)"temperature");
                Builder $this$temperature_u24lambda_u249 = builder = this;
                boolean bl = false;
                $this$temperature_u24lambda_u249.temperature = temperature;
                return builder;
            }

            @NotNull
            public final Builder timestampGranularities(@NotNull List<TimestampGranularity> timestampGranularities2) {
                Intrinsics.checkNotNullParameter(timestampGranularities2, (String)"timestampGranularities");
                return this.timestampGranularities(MultipartField.Companion.of(timestampGranularities2));
            }

            @NotNull
            public final Builder timestampGranularities(@NotNull MultipartField<List<TimestampGranularity>> timestampGranularities2) {
                Builder builder;
                Intrinsics.checkNotNullParameter(timestampGranularities2, (String)"timestampGranularities");
                Builder $this$timestampGranularities_u24lambda_u2410 = builder = this;
                boolean bl = false;
                $this$timestampGranularities_u24lambda_u2410.timestampGranularities = timestampGranularities2.map$openai_java_core(timestampGranularities.1.1.INSTANCE);
                return builder;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Builder addTimestampGranularity(@NotNull TimestampGranularity timestampGranularity) {
                void it;
                MultipartField<List<TimestampGranularity>> multipartField;
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)timestampGranularity, (String)"timestampGranularity");
                Builder $this$addTimestampGranularity_u24lambda_u2412 = builder = this;
                boolean bl = false;
                MultipartField<List<TimestampGranularity>> multipartField2 = $this$addTimestampGranularity_u24lambda_u2412.timestampGranularities;
                if (multipartField2 == null) {
                    multipartField2 = MultipartField.Companion.of((List)new ArrayList());
                }
                MultipartField<List<TimestampGranularity>> multipartField3 = multipartField = multipartField2;
                Builder builder2 = $this$addTimestampGranularity_u24lambda_u2412;
                boolean bl2 = false;
                ((List)Check.checkKnown("timestampGranularities", (MultipartField)it)).add(timestampGranularity);
                builder2.timestampGranularities = multipartField;
                return builder;
            }

            @NotNull
            public final Body build() {
                MultipartField<List<TranscriptionInclude>> multipartField = this.include;
                if (multipartField == null) {
                    multipartField = MultipartField.Companion.of(null);
                }
                MultipartField multipartField2 = multipartField.map$openai_java_core(build.1.INSTANCE);
                MultipartField<List<TimestampGranularity>> multipartField3 = this.timestampGranularities;
                if (multipartField3 == null) {
                    multipartField3 = MultipartField.Companion.of(null);
                }
                return new Body(Check.checkRequired("file", this.file), Check.checkRequired("model", this.model), multipartField2, this.language, this.prompt, this.responseFormat, this.temperature, multipartField3.map$openai_java_core(build.2.INSTANCE), null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Body$Companion;", "", "()V", "builder", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Body$Builder;", "openai-java-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder builder() {
                return new Builder();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u000fJ \u0010\u0003\u001a\u00020\u00002\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00120\u0010J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0013J \u0010\u0005\u001a\u00020\u00002\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00120\u0010J\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0018J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0019J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u001aJ\u0015\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001dJ\u001a\u0010\n\u001a\u00020\u00002\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001e0\u0017J\u0014\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eJ\u0014\u0010\u001f\u001a\u00020\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0011J\u0014\u0010 \u001a\u00020\u00002\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0017J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0011J\u0014\u0010#\u001a\u00020\u00002\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0011J\u0016\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0011J\u001c\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00112\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u0012J\u0016\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0011J\u001c\u0010*\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00112\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u0012J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u000fJ \u0010+\u001a\u00020\u00002\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00120\u0010J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0013J \u0010,\u001a\u00020\u00002\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00120\u0010J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0011J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0011J\u0014\u0010/\u001a\u00020\u00002\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001101J\u0014\u00102\u001a\u00020\u00002\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001101J\u0016\u00104\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0011J\u001c\u00104\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00112\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u0012J\u0016\u00105\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0011J\u001c\u00105\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00112\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\u0012J\u000e\u00106\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u000fJ \u00106\u001a\u00020\u00002\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00120\u0010J\u000e\u00107\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0013J \u00107\u001a\u00020\u00002\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00120\u0010J\u0014\u00108\u001a\u00020\u00002\f\u00108\u001a\b\u0012\u0004\u0012\u0002090\u0017J\u000e\u00108\u001a\u00020\u00002\u0006\u00108\u001a\u000209J\u0014\u0010:\u001a\u00020\u00002\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u0017J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010:\u001a\u00020;J\u001a\u0010<\u001a\u00020\u00002\u0012\u0010<\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001e0\u0017J\u0014\u0010<\u001a\u00020\u00002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Builder;", "", "()V", "additionalHeaders", "Lcom/openai/core/http/Headers$Builder;", "additionalQueryParams", "Lcom/openai/core/http/QueryParams$Builder;", "body", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Body$Builder;", "addInclude", "include", "Lcom/openai/models/audio/transcriptions/TranscriptionInclude;", "addTimestampGranularity", "timestampGranularity", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$TimestampGranularity;", "Lcom/openai/core/http/Headers;", "", "", "", "Lcom/openai/core/http/QueryParams;", "build", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams;", "file", "Lcom/openai/core/MultipartField;", "Ljava/io/InputStream;", "Ljava/nio/file/Path;", "", "from", "transcriptionCreateParams", "from$openai_java_core", "", "language", "model", "Lcom/openai/models/audio/AudioModel;", "value", "prompt", "putAdditionalHeader", "name", "putAdditionalHeaders", "values", "putAdditionalQueryParam", "key", "putAdditionalQueryParams", "putAllAdditionalHeaders", "putAllAdditionalQueryParams", "removeAdditionalHeaders", "removeAdditionalQueryParams", "removeAllAdditionalHeaders", "names", "", "removeAllAdditionalQueryParams", "keys", "replaceAdditionalHeaders", "replaceAdditionalQueryParams", "replaceAllAdditionalHeaders", "replaceAllAdditionalQueryParams", "responseFormat", "Lcom/openai/models/audio/AudioResponseFormat;", "temperature", "", "timestampGranularities", "openai-java-core"})
    @SourceDebugExtension(value={"SMAP\nTranscriptionCreateParams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranscriptionCreateParams.kt\ncom/openai/models/audio/transcriptions/TranscriptionCreateParams$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1108:1\n1#2:1109\n*E\n"})
    public static final class Builder {
        @NotNull
        private Body.Builder body = Body.Companion.builder();
        @NotNull
        private Headers.Builder additionalHeaders = Headers.Companion.builder();
        @NotNull
        private QueryParams.Builder additionalQueryParams = QueryParams.Companion.builder();

        public final /* synthetic */ Builder from$openai_java_core(TranscriptionCreateParams transcriptionCreateParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)transcriptionCreateParams, (String)"transcriptionCreateParams");
            Builder $this$from_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$from_u24lambda_u240.body = transcriptionCreateParams.body.toBuilder();
            $this$from_u24lambda_u240.additionalHeaders = transcriptionCreateParams.additionalHeaders.toBuilder();
            $this$from_u24lambda_u240.additionalQueryParams = transcriptionCreateParams.additionalQueryParams.toBuilder();
            return builder;
        }

        @NotNull
        public final Builder file(@NotNull InputStream file) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Builder $this$file_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$file_u24lambda_u241.body.file(file);
            return builder;
        }

        @NotNull
        public final Builder file(@NotNull MultipartField<InputStream> file) {
            Builder builder;
            Intrinsics.checkNotNullParameter(file, (String)"file");
            Builder $this$file_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$file_u24lambda_u242.body.file(file);
            return builder;
        }

        @NotNull
        public final Builder file(@NotNull byte[] file) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Builder $this$file_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$file_u24lambda_u243.body.file(file);
            return builder;
        }

        @NotNull
        public final Builder file(@NotNull Path file) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Builder $this$file_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$file_u24lambda_u244.body.file(file);
            return builder;
        }

        @NotNull
        public final Builder model(@NotNull AudioModel model) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Builder $this$model_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$model_u24lambda_u245.body.model(model);
            return builder;
        }

        @NotNull
        public final Builder model(@NotNull MultipartField<AudioModel> model) {
            Builder builder;
            Intrinsics.checkNotNullParameter(model, (String)"model");
            Builder $this$model_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$model_u24lambda_u246.body.model(model);
            return builder;
        }

        @NotNull
        public final Builder model(@NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$model_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$model_u24lambda_u247.body.model(value);
            return builder;
        }

        @NotNull
        public final Builder include(@NotNull List<TranscriptionInclude> include2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(include2, (String)"include");
            Builder $this$include_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$include_u24lambda_u248.body.include(include2);
            return builder;
        }

        @NotNull
        public final Builder include(@NotNull MultipartField<List<TranscriptionInclude>> include2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(include2, (String)"include");
            Builder $this$include_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$include_u24lambda_u249.body.include(include2);
            return builder;
        }

        @NotNull
        public final Builder addInclude(@NotNull TranscriptionInclude include2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)include2, (String)"include");
            Builder $this$addInclude_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$addInclude_u24lambda_u2410.body.addInclude(include2);
            return builder;
        }

        @NotNull
        public final Builder language(@NotNull String language) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Builder $this$language_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$language_u24lambda_u2411.body.language(language);
            return builder;
        }

        @NotNull
        public final Builder language(@NotNull MultipartField<String> language) {
            Builder builder;
            Intrinsics.checkNotNullParameter(language, (String)"language");
            Builder $this$language_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$language_u24lambda_u2412.body.language(language);
            return builder;
        }

        @NotNull
        public final Builder prompt(@NotNull String prompt) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
            Builder $this$prompt_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$prompt_u24lambda_u2413.body.prompt(prompt);
            return builder;
        }

        @NotNull
        public final Builder prompt(@NotNull MultipartField<String> prompt) {
            Builder builder;
            Intrinsics.checkNotNullParameter(prompt, (String)"prompt");
            Builder $this$prompt_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$prompt_u24lambda_u2414.body.prompt(prompt);
            return builder;
        }

        @NotNull
        public final Builder responseFormat(@NotNull AudioResponseFormat responseFormat) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)responseFormat, (String)"responseFormat");
            Builder $this$responseFormat_u24lambda_u2415 = builder = this;
            boolean bl = false;
            $this$responseFormat_u24lambda_u2415.body.responseFormat(responseFormat);
            return builder;
        }

        @NotNull
        public final Builder responseFormat(@NotNull MultipartField<AudioResponseFormat> responseFormat) {
            Builder builder;
            Intrinsics.checkNotNullParameter(responseFormat, (String)"responseFormat");
            Builder $this$responseFormat_u24lambda_u2416 = builder = this;
            boolean bl = false;
            $this$responseFormat_u24lambda_u2416.body.responseFormat(responseFormat);
            return builder;
        }

        @NotNull
        public final Builder temperature(double temperature) {
            Builder builder;
            Builder $this$temperature_u24lambda_u2417 = builder = this;
            boolean bl = false;
            $this$temperature_u24lambda_u2417.body.temperature(temperature);
            return builder;
        }

        @NotNull
        public final Builder temperature(@NotNull MultipartField<Double> temperature) {
            Builder builder;
            Intrinsics.checkNotNullParameter(temperature, (String)"temperature");
            Builder $this$temperature_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$temperature_u24lambda_u2418.body.temperature(temperature);
            return builder;
        }

        @NotNull
        public final Builder timestampGranularities(@NotNull List<TimestampGranularity> timestampGranularities2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(timestampGranularities2, (String)"timestampGranularities");
            Builder $this$timestampGranularities_u24lambda_u2419 = builder = this;
            boolean bl = false;
            $this$timestampGranularities_u24lambda_u2419.body.timestampGranularities(timestampGranularities2);
            return builder;
        }

        @NotNull
        public final Builder timestampGranularities(@NotNull MultipartField<List<TimestampGranularity>> timestampGranularities2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(timestampGranularities2, (String)"timestampGranularities");
            Builder $this$timestampGranularities_u24lambda_u2420 = builder = this;
            boolean bl = false;
            $this$timestampGranularities_u24lambda_u2420.body.timestampGranularities(timestampGranularities2);
            return builder;
        }

        @NotNull
        public final Builder addTimestampGranularity(@NotNull TimestampGranularity timestampGranularity) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)timestampGranularity, (String)"timestampGranularity");
            Builder $this$addTimestampGranularity_u24lambda_u2421 = builder = this;
            boolean bl = false;
            $this$addTimestampGranularity_u24lambda_u2421.body.addTimestampGranularity(timestampGranularity);
            return builder;
        }

        @NotNull
        public final Builder additionalHeaders(@NotNull Headers additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)additionalHeaders, (String)"additionalHeaders");
            Builder $this$additionalHeaders_u24lambda_u2422 = builder = this;
            boolean bl = false;
            $this$additionalHeaders_u24lambda_u2422.additionalHeaders.clear();
            $this$additionalHeaders_u24lambda_u2422.putAllAdditionalHeaders(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder additionalHeaders(@NotNull Map<String, ? extends Iterable<String>> additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalHeaders, (String)"additionalHeaders");
            Builder $this$additionalHeaders_u24lambda_u2423 = builder = this;
            boolean bl = false;
            $this$additionalHeaders_u24lambda_u2423.additionalHeaders.clear();
            $this$additionalHeaders_u24lambda_u2423.putAllAdditionalHeaders(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalHeader(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putAdditionalHeader_u24lambda_u2424 = builder = this;
            boolean bl = false;
            $this$putAdditionalHeader_u24lambda_u2424.additionalHeaders.put(name, value);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalHeaders(@NotNull String name, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putAdditionalHeaders_u24lambda_u2425 = builder = this;
            boolean bl = false;
            $this$putAdditionalHeaders_u24lambda_u2425.additionalHeaders.put(name, values);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalHeaders(@NotNull Headers additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)additionalHeaders, (String)"additionalHeaders");
            Builder $this$putAllAdditionalHeaders_u24lambda_u2426 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalHeaders_u24lambda_u2426.additionalHeaders.putAll(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalHeaders(@NotNull Map<String, ? extends Iterable<String>> additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalHeaders, (String)"additionalHeaders");
            Builder $this$putAllAdditionalHeaders_u24lambda_u2427 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalHeaders_u24lambda_u2427.additionalHeaders.putAll(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder replaceAdditionalHeaders(@NotNull String name, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$replaceAdditionalHeaders_u24lambda_u2428 = builder = this;
            boolean bl = false;
            $this$replaceAdditionalHeaders_u24lambda_u2428.additionalHeaders.replace(name, value);
            return builder;
        }

        @NotNull
        public final Builder replaceAdditionalHeaders(@NotNull String name, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$replaceAdditionalHeaders_u24lambda_u2429 = builder = this;
            boolean bl = false;
            $this$replaceAdditionalHeaders_u24lambda_u2429.additionalHeaders.replace(name, values);
            return builder;
        }

        @NotNull
        public final Builder replaceAllAdditionalHeaders(@NotNull Headers additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)additionalHeaders, (String)"additionalHeaders");
            Builder $this$replaceAllAdditionalHeaders_u24lambda_u2430 = builder = this;
            boolean bl = false;
            $this$replaceAllAdditionalHeaders_u24lambda_u2430.additionalHeaders.replaceAll(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder replaceAllAdditionalHeaders(@NotNull Map<String, ? extends Iterable<String>> additionalHeaders) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalHeaders, (String)"additionalHeaders");
            Builder $this$replaceAllAdditionalHeaders_u24lambda_u2431 = builder = this;
            boolean bl = false;
            $this$replaceAllAdditionalHeaders_u24lambda_u2431.additionalHeaders.replaceAll(additionalHeaders);
            return builder;
        }

        @NotNull
        public final Builder removeAdditionalHeaders(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$removeAdditionalHeaders_u24lambda_u2432 = builder = this;
            boolean bl = false;
            $this$removeAdditionalHeaders_u24lambda_u2432.additionalHeaders.remove(name);
            return builder;
        }

        @NotNull
        public final Builder removeAllAdditionalHeaders(@NotNull Set<String> names) {
            Builder builder;
            Intrinsics.checkNotNullParameter(names, (String)"names");
            Builder $this$removeAllAdditionalHeaders_u24lambda_u2433 = builder = this;
            boolean bl = false;
            $this$removeAllAdditionalHeaders_u24lambda_u2433.additionalHeaders.removeAll(names);
            return builder;
        }

        @NotNull
        public final Builder additionalQueryParams(@NotNull QueryParams additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)additionalQueryParams, (String)"additionalQueryParams");
            Builder $this$additionalQueryParams_u24lambda_u2434 = builder = this;
            boolean bl = false;
            $this$additionalQueryParams_u24lambda_u2434.additionalQueryParams.clear();
            $this$additionalQueryParams_u24lambda_u2434.putAllAdditionalQueryParams(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder additionalQueryParams(@NotNull Map<String, ? extends Iterable<String>> additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalQueryParams, (String)"additionalQueryParams");
            Builder $this$additionalQueryParams_u24lambda_u2435 = builder = this;
            boolean bl = false;
            $this$additionalQueryParams_u24lambda_u2435.additionalQueryParams.clear();
            $this$additionalQueryParams_u24lambda_u2435.putAllAdditionalQueryParams(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalQueryParam(@NotNull String key, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$putAdditionalQueryParam_u24lambda_u2436 = builder = this;
            boolean bl = false;
            $this$putAdditionalQueryParam_u24lambda_u2436.additionalQueryParams.put(key, value);
            return builder;
        }

        @NotNull
        public final Builder putAdditionalQueryParams(@NotNull String key, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$putAdditionalQueryParams_u24lambda_u2437 = builder = this;
            boolean bl = false;
            $this$putAdditionalQueryParams_u24lambda_u2437.additionalQueryParams.put(key, values);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalQueryParams(@NotNull QueryParams additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)additionalQueryParams, (String)"additionalQueryParams");
            Builder $this$putAllAdditionalQueryParams_u24lambda_u2438 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalQueryParams_u24lambda_u2438.additionalQueryParams.putAll(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder putAllAdditionalQueryParams(@NotNull Map<String, ? extends Iterable<String>> additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalQueryParams, (String)"additionalQueryParams");
            Builder $this$putAllAdditionalQueryParams_u24lambda_u2439 = builder = this;
            boolean bl = false;
            $this$putAllAdditionalQueryParams_u24lambda_u2439.additionalQueryParams.putAll(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder replaceAdditionalQueryParams(@NotNull String key, @NotNull String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$replaceAdditionalQueryParams_u24lambda_u2440 = builder = this;
            boolean bl = false;
            $this$replaceAdditionalQueryParams_u24lambda_u2440.additionalQueryParams.replace(key, value);
            return builder;
        }

        @NotNull
        public final Builder replaceAdditionalQueryParams(@NotNull String key, @NotNull Iterable<String> values) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Builder $this$replaceAdditionalQueryParams_u24lambda_u2441 = builder = this;
            boolean bl = false;
            $this$replaceAdditionalQueryParams_u24lambda_u2441.additionalQueryParams.replace(key, values);
            return builder;
        }

        @NotNull
        public final Builder replaceAllAdditionalQueryParams(@NotNull QueryParams additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)additionalQueryParams, (String)"additionalQueryParams");
            Builder $this$replaceAllAdditionalQueryParams_u24lambda_u2442 = builder = this;
            boolean bl = false;
            $this$replaceAllAdditionalQueryParams_u24lambda_u2442.additionalQueryParams.replaceAll(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder replaceAllAdditionalQueryParams(@NotNull Map<String, ? extends Iterable<String>> additionalQueryParams) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalQueryParams, (String)"additionalQueryParams");
            Builder $this$replaceAllAdditionalQueryParams_u24lambda_u2443 = builder = this;
            boolean bl = false;
            $this$replaceAllAdditionalQueryParams_u24lambda_u2443.additionalQueryParams.replaceAll(additionalQueryParams);
            return builder;
        }

        @NotNull
        public final Builder removeAdditionalQueryParams(@NotNull String key) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$removeAdditionalQueryParams_u24lambda_u2444 = builder = this;
            boolean bl = false;
            $this$removeAdditionalQueryParams_u24lambda_u2444.additionalQueryParams.remove(key);
            return builder;
        }

        @NotNull
        public final Builder removeAllAdditionalQueryParams(@NotNull Set<String> keys2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(keys2, (String)"keys");
            Builder $this$removeAllAdditionalQueryParams_u24lambda_u2445 = builder = this;
            boolean bl = false;
            $this$removeAllAdditionalQueryParams_u24lambda_u2445.additionalQueryParams.removeAll(keys2);
            return builder;
        }

        @NotNull
        public final TranscriptionCreateParams build() {
            return new TranscriptionCreateParams(this.body.build(), this.additionalHeaders.build(), this.additionalQueryParams.build(), null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Companion;", "", "()V", "builder", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$Builder;", "openai-java-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\u0015\b\u0003\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u0006\u0010\u0007\u001a\u00020\u0004J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0006\u0010\u0002\u001a\u00020\u0011R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$TimestampGranularity;", "Lcom/openai/core/Enum;", "value", "Lcom/openai/core/JsonField;", "", "(Lcom/openai/core/JsonField;)V", "_value", "asString", "equals", "", "other", "", "hashCode", "", "known", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$TimestampGranularity$Known;", "toString", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$TimestampGranularity$Value;", "Companion", "Known", "Value", "openai-java-core"})
    public static final class TimestampGranularity
    implements Enum {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JsonField<String> value;
        @JvmField
        @NotNull
        public static final TimestampGranularity WORD = Companion.of("word");
        @JvmField
        @NotNull
        public static final TimestampGranularity SEGMENT = Companion.of("segment");

        @JsonCreator
        private TimestampGranularity(JsonField<String> value) {
            this.value = value;
        }

        @JsonValue
        @NotNull
        public final JsonField<String> _value() {
            return this.value;
        }

        @NotNull
        public final Value value() {
            TimestampGranularity timestampGranularity = this;
            return Intrinsics.areEqual((Object)timestampGranularity, (Object)WORD) ? Value.WORD : (Intrinsics.areEqual((Object)timestampGranularity, (Object)SEGMENT) ? Value.SEGMENT : Value._UNKNOWN);
        }

        @NotNull
        public final Known known() {
            Known known;
            TimestampGranularity timestampGranularity = this;
            if (Intrinsics.areEqual((Object)timestampGranularity, (Object)WORD)) {
                known = Known.WORD;
            } else if (Intrinsics.areEqual((Object)timestampGranularity, (Object)SEGMENT)) {
                known = Known.SEGMENT;
            } else {
                throw new OpenAIInvalidDataException("Unknown TimestampGranularity: " + this.value, null, 2, null);
            }
            return known;
        }

        @NotNull
        public final String asString() {
            String string = this._value().asString().orElseThrow(TimestampGranularity::asString$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"_value().asString().orEl\u2026Value is not a String\") }");
            return string;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TimestampGranularity && Intrinsics.areEqual(this.value, ((TimestampGranularity)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @NotNull
        public String toString() {
            return this.value.toString();
        }

        private static final OpenAIInvalidDataException asString$lambda$0() {
            return new OpenAIInvalidDataException("Value is not a String", null, 2, null);
        }

        @JvmStatic
        @NotNull
        public static final TimestampGranularity of(@NotNull String value) {
            return Companion.of(value);
        }

        public /* synthetic */ TimestampGranularity(JsonField value, DefaultConstructorMarker $constructor_marker) {
            this(value);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$TimestampGranularity$Companion;", "", "()V", "SEGMENT", "Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$TimestampGranularity;", "WORD", "of", "value", "", "openai-java-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final TimestampGranularity of(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new TimestampGranularity(JsonField.Companion.of(value), null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$TimestampGranularity$Known;", "", "(Ljava/lang/String;I)V", "WORD", "SEGMENT", "openai-java-core"})
        public static final class Known
        extends java.lang.Enum<Known> {
            public static final /* enum */ Known WORD = new Known();
            public static final /* enum */ Known SEGMENT = new Known();
            private static final /* synthetic */ Known[] $VALUES;

            public static Known[] values() {
                return (Known[])$VALUES.clone();
            }

            public static Known valueOf(String value) {
                return java.lang.Enum.valueOf(Known.class, value);
            }

            static {
                $VALUES = knownArray = new Known[]{Known.WORD, Known.SEGMENT};
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/openai/models/audio/transcriptions/TranscriptionCreateParams$TimestampGranularity$Value;", "", "(Ljava/lang/String;I)V", "WORD", "SEGMENT", "_UNKNOWN", "openai-java-core"})
        public static final class Value
        extends java.lang.Enum<Value> {
            public static final /* enum */ Value WORD = new Value();
            public static final /* enum */ Value SEGMENT = new Value();
            public static final /* enum */ Value _UNKNOWN = new Value();
            private static final /* synthetic */ Value[] $VALUES;

            public static Value[] values() {
                return (Value[])$VALUES.clone();
            }

            public static Value valueOf(String value) {
                return java.lang.Enum.valueOf(Value.class, value);
            }

            static {
                $VALUES = valueArray = new Value[]{Value.WORD, Value.SEGMENT, Value._UNKNOWN};
            }
        }
    }
}

