/*
 * Decompiled with CFR 0.152.
 */
package com.openai.services.blocking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.openai.core.ClientOptions;
import com.openai.core.PrepareRequest;
import com.openai.core.RequestOptions;
import com.openai.core.handlers.ErrorHandler;
import com.openai.core.http.HttpMethod;
import com.openai.core.http.HttpRequest;
import com.openai.core.http.HttpRequestBody;
import com.openai.core.http.HttpResponse;
import com.openai.errors.OpenAIError;
import com.openai.errors.OpenAIException;
import com.openai.models.Model;
import com.openai.models.ModelDeleteParams;
import com.openai.models.ModelDeleted;
import com.openai.models.ModelListPage;
import com.openai.models.ModelListParams;
import com.openai.models.ModelRetrieveParams;
import com.openai.services.blocking.ModelService;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/openai/services/blocking/ModelServiceImpl;", "Lcom/openai/services/blocking/ModelService;", "clientOptions", "Lcom/openai/core/ClientOptions;", "<init>", "(Lcom/openai/core/ClientOptions;)V", "errorHandler", "Lcom/openai/core/http/HttpResponse$Handler;", "Lcom/openai/errors/OpenAIError;", "retrieveHandler", "Lcom/openai/models/Model;", "retrieve", "params", "Lcom/openai/models/ModelRetrieveParams;", "requestOptions", "Lcom/openai/core/RequestOptions;", "listHandler", "Lcom/openai/models/ModelListPage$Response;", "list", "Lcom/openai/models/ModelListPage;", "Lcom/openai/models/ModelListParams;", "deleteHandler", "Lcom/openai/models/ModelDeleted;", "delete", "Lcom/openai/models/ModelDeleteParams;", "openai-java-core"})
@SourceDebugExtension(value={"SMAP\nModelServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelServiceImpl.kt\ncom/openai/services/blocking/ModelServiceImpl\n+ 2 JsonHandler.kt\ncom/openai/core/handlers/JsonHandler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 HttpRequestBodies.kt\ncom/openai/core/HttpRequestBodies\n*L\n1#1,102:1\n13#2,9:103\n13#2,9:112\n13#2,9:121\n1#3:130\n14#4:131\n*S KotlinDebug\n*F\n+ 1 ModelServiceImpl.kt\ncom/openai/services/blocking/ModelServiceImpl\n*L\n29#1:103,9\n53#1:112,9\n78#1:121,9\n89#1:131\n*E\n"})
public final class ModelServiceImpl
implements ModelService {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<OpenAIError> errorHandler;
    @NotNull
    private final HttpResponse.Handler<Model> retrieveHandler;
    @NotNull
    private final HttpResponse.Handler<ModelListPage.Response> listHandler;
    @NotNull
    private final HttpResponse.Handler<ModelDeleted> deleteHandler;

    public ModelServiceImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.retrieveHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<Model>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public Model handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<Model>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ModelListPage.Response>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ModelListPage.Response handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ModelListPage.Response>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.deleteHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<ModelDeleted>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public ModelDeleted handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<ModelDeleted>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Model retrieve(@NotNull ModelRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"models", params.getPathParam(0)};
        HttpRequest request = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, params.model());
        HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions);
        Object object = response;
        Throwable throwable = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            it = this.retrieveHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((Model)it2).validate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModelListPage list(@NotNull ModelListParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"models"};
        HttpRequest request = PrepareRequest.prepare(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
        HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions);
        Object object = response;
        Throwable throwable = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            it = this.listHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((ModelListPage.Response)it2).validate();
        }
        it2 = object;
        boolean bl3 = false;
        return ModelListPage.Companion.of(this, params, (ModelListPage.Response)it2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModelDeleted delete(@NotNull ModelDeleteParams params, @NotNull RequestOptions requestOptions) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Object object = new String[]{"models", params.getPathParam(0)};
        Object $this$delete_u24lambda_u247 = object = HttpRequest.Companion.builder().method(HttpMethod.DELETE).addPathSegments((String[])object);
        boolean $i$a$-apply-ModelServiceImpl$delete$request$22 = false;
        params._body$openai_java_core().ifPresent(arg_0 -> ModelServiceImpl.delete$lambda$7$lambda$6(arg_0 -> ModelServiceImpl.delete$lambda$7$lambda$5((HttpRequest.Builder)$this$delete_u24lambda_u247, this, arg_0), arg_0));
        HttpRequest request = PrepareRequest.prepare(((HttpRequest.Builder)object).build(), this.clientOptions, params, params.model());
        HttpResponse response = this.clientOptions.httpClient().execute(request, requestOptions);
        Object object2 = response;
        Throwable $i$a$-apply-ModelServiceImpl$delete$request$22 = null;
        try {
            it = (HttpResponse)object2;
            boolean bl = false;
            it = this.deleteHandler.handle((HttpResponse)it);
        }
        catch (Throwable throwable) {
            $i$a$-apply-ModelServiceImpl$delete$request$22 = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)$i$a$-apply-ModelServiceImpl$delete$request$22);
        }
        Object it2 = object2 = it;
        boolean bl = false;
        Boolean bl2 = requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this.clientOptions.responseValidation()) {
            ((ModelDeleted)it2).validate();
        }
        return object2;
    }

    private static final Unit delete$lambda$7$lambda$5(HttpRequest.Builder $this_apply, ModelServiceImpl this$0, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JsonMapper jsonMapper$iv = this$0.clientOptions.jsonMapper();
        boolean $i$f$json = false;
        $this_apply.body(new HttpRequestBody(jsonMapper$iv, it){
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new OpenAIException("Error writing request", e);
                }
            }

            public void writeTo(OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        });
        return Unit.INSTANCE;
    }

    private static final void delete$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

