/*
 * Decompiled with CFR 0.152.
 */
package com.openai.services.async;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.openai.core.ClientOptions;
import com.openai.core.PrepareRequest;
import com.openai.core.RequestOptions;
import com.openai.core.handlers.ErrorHandler;
import com.openai.core.http.HttpClient;
import com.openai.core.http.HttpMethod;
import com.openai.core.http.HttpRequest;
import com.openai.core.http.HttpRequestBody;
import com.openai.core.http.HttpResponse;
import com.openai.errors.OpenAIError;
import com.openai.errors.OpenAIException;
import com.openai.models.FileContentParams;
import com.openai.models.FileDeleteParams;
import com.openai.models.FileDeleted;
import com.openai.models.FileListPageAsync;
import com.openai.models.FileListParams;
import com.openai.models.FileObject;
import com.openai.models.FileRetrieveParams;
import com.openai.services.async.FileServiceAsync;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\u0006\u0010\r\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\u0006\u0010\r\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/openai/services/async/FileServiceAsyncImpl;", "Lcom/openai/services/async/FileServiceAsync;", "clientOptions", "Lcom/openai/core/ClientOptions;", "<init>", "(Lcom/openai/core/ClientOptions;)V", "errorHandler", "Lcom/openai/core/http/HttpResponse$Handler;", "Lcom/openai/errors/OpenAIError;", "retrieveHandler", "Lcom/openai/models/FileObject;", "retrieve", "Ljava/util/concurrent/CompletableFuture;", "params", "Lcom/openai/models/FileRetrieveParams;", "requestOptions", "Lcom/openai/core/RequestOptions;", "listHandler", "Lcom/openai/models/FileListPageAsync$Response;", "list", "Lcom/openai/models/FileListPageAsync;", "Lcom/openai/models/FileListParams;", "deleteHandler", "Lcom/openai/models/FileDeleted;", "delete", "Lcom/openai/models/FileDeleteParams;", "content", "Lcom/openai/core/http/HttpResponse;", "Lcom/openai/models/FileContentParams;", "openai-java-core"})
@SourceDebugExtension(value={"SMAP\nFileServiceAsyncImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileServiceAsyncImpl.kt\ncom/openai/services/async/FileServiceAsyncImpl\n+ 2 JsonHandler.kt\ncom/openai/core/handlers/JsonHandler\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 HttpRequestBodies.kt\ncom/openai/core/HttpRequestBodies\n*L\n1#1,131:1\n13#2,9:132\n13#2,9:141\n13#2,9:150\n1#3:159\n14#4:160\n*S KotlinDebug\n*F\n+ 1 FileServiceAsyncImpl.kt\ncom/openai/services/async/FileServiceAsyncImpl\n*L\n32#1:132,9\n59#1:141,9\n88#1:150,9\n99#1:160\n*E\n"})
public final class FileServiceAsyncImpl
implements FileServiceAsync {
    @NotNull
    private final ClientOptions clientOptions;
    @NotNull
    private final HttpResponse.Handler<OpenAIError> errorHandler;
    @NotNull
    private final HttpResponse.Handler<FileObject> retrieveHandler;
    @NotNull
    private final HttpResponse.Handler<FileListPageAsync.Response> listHandler;
    @NotNull
    private final HttpResponse.Handler<FileDeleted> deleteHandler;

    public FileServiceAsyncImpl(@NotNull ClientOptions clientOptions) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        this.clientOptions = clientOptions;
        this.errorHandler = ErrorHandler.errorHandler(this.clientOptions.jsonMapper());
        JsonMapper jsonMapper$iv = this.clientOptions.jsonMapper();
        boolean $i$f$jsonHandler = false;
        this.retrieveHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<FileObject>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public FileObject handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<FileObject>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.listHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<FileListPageAsync.Response>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public FileListPageAsync.Response handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<FileListPageAsync.Response>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
        jsonMapper$iv = this.clientOptions.jsonMapper();
        $i$f$jsonHandler = false;
        this.deleteHandler = ErrorHandler.withErrorHandler(new HttpResponse.Handler<FileDeleted>(jsonMapper$iv){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public FileDeleted handle(HttpResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    return this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<FileDeleted>(){});
                }
                catch (Exception e) {
                    throw new OpenAIException("Error reading response", e);
                }
            }
        }, this.errorHandler);
    }

    @Override
    @NotNull
    public CompletableFuture<FileObject> retrieve(@NotNull FileRetrieveParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"files", params.getPathParam(0)};
        CompletableFuture request = PrepareRequest.prepareAsync(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
        CompletionStage completionStage = ((CompletableFuture)request.thenComposeAsync(arg_0 -> FileServiceAsyncImpl.retrieve$lambda$1(arg_0 -> FileServiceAsyncImpl.retrieve$lambda$0(this, requestOptions, arg_0), arg_0))).thenApply(arg_0 -> FileServiceAsyncImpl.retrieve$lambda$5(arg_0 -> FileServiceAsyncImpl.retrieve$lambda$4(this, requestOptions, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FileListPageAsync> list(@NotNull FileListParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"files"};
        CompletableFuture request = PrepareRequest.prepareAsync(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
        CompletionStage completionStage = ((CompletableFuture)request.thenComposeAsync(arg_0 -> FileServiceAsyncImpl.list$lambda$7(arg_0 -> FileServiceAsyncImpl.list$lambda$6(this, requestOptions, arg_0), arg_0))).thenApply(arg_0 -> FileServiceAsyncImpl.list$lambda$12(arg_0 -> FileServiceAsyncImpl.list$lambda$11(this, requestOptions, params, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FileDeleted> delete(@NotNull FileDeleteParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Object object = new String[]{"files", params.getPathParam(0)};
        Object $this$delete_u24lambda_u2415 = object = HttpRequest.Companion.builder().method(HttpMethod.DELETE).addPathSegments((String[])object);
        boolean bl = false;
        params._body$openai_java_core().ifPresent(arg_0 -> FileServiceAsyncImpl.delete$lambda$15$lambda$14(arg_0 -> FileServiceAsyncImpl.delete$lambda$15$lambda$13((HttpRequest.Builder)$this$delete_u24lambda_u2415, this, arg_0), arg_0));
        CompletableFuture request = PrepareRequest.prepareAsync(((HttpRequest.Builder)object).build(), this.clientOptions, params, null);
        CompletionStage completionStage = ((CompletableFuture)request.thenComposeAsync(arg_0 -> FileServiceAsyncImpl.delete$lambda$17(arg_0 -> FileServiceAsyncImpl.delete$lambda$16(this, requestOptions, arg_0), arg_0))).thenApply(arg_0 -> FileServiceAsyncImpl.delete$lambda$21(arg_0 -> FileServiceAsyncImpl.delete$lambda$20(this, requestOptions, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<HttpResponse> content(@NotNull FileContentParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String[] stringArray = new String[]{"files", params.getPathParam(0), "content"};
        CompletableFuture request = PrepareRequest.prepareAsync(HttpRequest.Companion.builder().method(HttpMethod.GET).addPathSegments(stringArray).build(), this.clientOptions, params, null);
        CompletionStage completionStage = request.thenComposeAsync(arg_0 -> FileServiceAsyncImpl.content$lambda$23(arg_0 -> FileServiceAsyncImpl.content$lambda$22(this, requestOptions, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenComposeAsync(...)");
        return completionStage;
    }

    private static final CompletionStage retrieve$lambda$0(FileServiceAsyncImpl this$0, RequestOptions $requestOptions, HttpRequest it) {
        HttpClient httpClient = this$0.clientOptions.httpClient();
        Intrinsics.checkNotNull((Object)it);
        return httpClient.executeAsync(it, $requestOptions);
    }

    private static final CompletionStage retrieve$lambda$1(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final FileObject retrieve$lambda$4(FileServiceAsyncImpl this$0, RequestOptions $requestOptions, HttpResponse response) {
        Object it;
        Object object = response;
        Throwable throwable = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            HttpResponse.Handler<FileObject> handler = this$0.retrieveHandler;
            Intrinsics.checkNotNull((Object)it);
            it = handler.handle((HttpResponse)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = $requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this$0.clientOptions.responseValidation()) {
            ((FileObject)it2).validate();
        }
        return object;
    }

    private static final FileObject retrieve$lambda$5(Function1 $tmp0, Object p0) {
        return (FileObject)$tmp0.invoke(p0);
    }

    private static final CompletionStage list$lambda$6(FileServiceAsyncImpl this$0, RequestOptions $requestOptions, HttpRequest it) {
        HttpClient httpClient = this$0.clientOptions.httpClient();
        Intrinsics.checkNotNull((Object)it);
        return httpClient.executeAsync(it, $requestOptions);
    }

    private static final CompletionStage list$lambda$7(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final FileListPageAsync list$lambda$11(FileServiceAsyncImpl this$0, RequestOptions $requestOptions, FileListParams $params, HttpResponse response) {
        Object it;
        Object object = response;
        Throwable throwable = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            HttpResponse.Handler<FileListPageAsync.Response> handler = this$0.listHandler;
            Intrinsics.checkNotNull((Object)it);
            it = handler.handle((HttpResponse)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = $requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this$0.clientOptions.responseValidation()) {
            ((FileListPageAsync.Response)it2).validate();
        }
        it2 = object;
        boolean bl3 = false;
        return FileListPageAsync.Companion.of(this$0, $params, (FileListPageAsync.Response)it2);
    }

    private static final FileListPageAsync list$lambda$12(Function1 $tmp0, Object p0) {
        return (FileListPageAsync)$tmp0.invoke(p0);
    }

    private static final Unit delete$lambda$15$lambda$13(HttpRequest.Builder $this_apply, FileServiceAsyncImpl this$0, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JsonMapper jsonMapper$iv = this$0.clientOptions.jsonMapper();
        boolean $i$f$json = false;
        $this_apply.body(new HttpRequestBody(jsonMapper$iv, it){
            private byte[] cachedBytes;
            final /* synthetic */ JsonMapper $jsonMapper;
            final /* synthetic */ T $value;
            {
                this.$jsonMapper = $jsonMapper;
                this.$value = $value;
            }

            private final byte[] serialize() {
                if (this.cachedBytes != null) {
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    this.$jsonMapper.writeValue((OutputStream)buffer, this.$value);
                    this.cachedBytes = buffer.toByteArray();
                    Intrinsics.checkNotNull((Object)this.cachedBytes);
                    return this.cachedBytes;
                }
                catch (Exception e) {
                    throw new OpenAIException("Error writing request", e);
                }
            }

            public void writeTo(OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                outputStream.write(this.serialize());
            }

            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.serialize().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        });
        return Unit.INSTANCE;
    }

    private static final void delete$lambda$15$lambda$14(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final CompletionStage delete$lambda$16(FileServiceAsyncImpl this$0, RequestOptions $requestOptions, HttpRequest it) {
        HttpClient httpClient = this$0.clientOptions.httpClient();
        Intrinsics.checkNotNull((Object)it);
        return httpClient.executeAsync(it, $requestOptions);
    }

    private static final CompletionStage delete$lambda$17(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final FileDeleted delete$lambda$20(FileServiceAsyncImpl this$0, RequestOptions $requestOptions, HttpResponse response) {
        Object it;
        Object object = response;
        Throwable throwable = null;
        try {
            it = (HttpResponse)object;
            boolean bl = false;
            HttpResponse.Handler<FileDeleted> handler = this$0.deleteHandler;
            Intrinsics.checkNotNull((Object)it);
            it = handler.handle((HttpResponse)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object it2 = object = it;
        boolean bl = false;
        Boolean bl2 = $requestOptions.getResponseValidation();
        if (bl2 != null ? bl2.booleanValue() : this$0.clientOptions.responseValidation()) {
            ((FileDeleted)it2).validate();
        }
        return object;
    }

    private static final FileDeleted delete$lambda$21(Function1 $tmp0, Object p0) {
        return (FileDeleted)$tmp0.invoke(p0);
    }

    private static final CompletionStage content$lambda$22(FileServiceAsyncImpl this$0, RequestOptions $requestOptions, HttpRequest it) {
        HttpClient httpClient = this$0.clientOptions.httpClient();
        Intrinsics.checkNotNull((Object)it);
        return httpClient.executeAsync(it, $requestOptions);
    }

    private static final CompletionStage content$lambda$23(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }
}

