/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase.util;

import com.alipay.oceanbase.hbase.OHTable;
import com.alipay.oceanbase.hbase.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.hbase.util.OHBufferedMutatorImpl;
import com.alipay.oceanbase.hbase.util.OHConnectionConfiguration;
import com.alipay.oceanbase.hbase.util.ObTableBuilderBase;
import com.alipay.oceanbase.hbase.util.TableHBaseLoggerFactory;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Threads;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@InterfaceAudience.Private
public class OHConnectionImpl
implements Connection {
    private static final Logger LOGGER = TableHBaseLoggerFactory.getLogger(OHConnectionImpl.class);
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    public static final int BUFFERED_PARAM_UNSET = -1;
    private volatile boolean closed;
    private volatile boolean aborted;
    private volatile ExecutorService batchPool = null;
    private volatile boolean cleanupPool = false;
    private final Configuration conf;
    private final OHConnectionConfiguration connectionConfig;

    OHConnectionImpl(Configuration conf, ExecutorService pool, User user) throws IOException {
        this.conf = conf;
        this.batchPool = pool;
        this.connectionConfig = new OHConnectionConfiguration(conf);
        this.closed = false;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public OHConnectionConfiguration getOHConnectionConfiguration() {
        return this.connectionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getBatchPool() {
        if (this.batchPool == null) {
            OHConnectionImpl oHConnectionImpl = this;
            synchronized (oHConnectionImpl) {
                if (this.batchPool == null) {
                    this.batchPool = this.getThreadPool(this.conf.getInt("hbase.hconnection.threads.max", 256), this.conf.getInt("hbase.hconnection.threads.core", 256), "-shared-", null);
                }
            }
        }
        return this.batchPool;
    }

    private ExecutorService getThreadPool(int maxThreads, int coreThreads, String nameHint, BlockingQueue<Runnable> passedWorkQueue) {
        if (maxThreads == 0) {
            maxThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        if (coreThreads == 0) {
            coreThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        long keepAliveTime = this.conf.getLong("hbase.hconnection.threads.keepalivetime", 60L);
        BlockingQueue<Runnable> workQueue = passedWorkQueue;
        if (workQueue == null) {
            workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * this.conf.getInt("hbase.client.max.total.tasks", 100));
        }
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, Threads.newDaemonThreadFactory((String)(this.toString() + nameHint)));
        tpe.allowCoreThreadTimeOut(true);
        return tpe;
    }

    public Table getTable(TableName tableName) throws IOException {
        return this.getTable(tableName, this.getBatchPool());
    }

    public Table getTable(TableName tableName, ExecutorService pool) throws IOException {
        return new OHTable(tableName, this, this.connectionConfig, pool);
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return this.getBufferedMutator(new BufferedMutatorParams(tableName));
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        if (params.getTableName() == null) {
            throw new IllegalArgumentException("TableName cannot be null.");
        }
        if (params.getWriteBufferSize() == -1L) {
            params.writeBufferSize(this.connectionConfig.getWriteBufferSize());
        }
        if (params.getMaxKeyValueSize() == -1) {
            params.maxKeyValueSize(this.connectionConfig.getMaxKeyValueSize());
        }
        return new OHBufferedMutatorImpl(this, params);
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        throw new FeatureNotSupportedException("not supported yet'");
    }

    public Admin getAdmin() throws IOException {
        throw new FeatureNotSupportedException("not supported yet'");
    }

    private void shutdownBatchPool(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.cleanupPool && this.batchPool != null && !this.batchPool.isShutdown()) {
            this.shutdownBatchPool(this.batchPool);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public TableBuilder getTableBuilder(TableName tableName, final ExecutorService pool) {
        return new ObTableBuilderBase(tableName, this.connectionConfig){

            public Table build() {
                try {
                    return new OHTable(OHConnectionImpl.this, this, OHConnectionImpl.this.connectionConfig, pool);
                }
                catch (Exception e) {
                    LOGGER.error("Fail to build new OHTable", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void abort(String msg, Throwable t) {
        if (t != null) {
            LOGGER.error(FATAL, msg, t);
        } else {
            LOGGER.error(FATAL, msg);
        }
        this.aborted = true;
        this.close();
    }

    public boolean isAborted() {
        return this.aborted;
    }
}

