/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase;

import com.alipay.oceanbase.hbase.OHTable;
import com.alipay.oceanbase.hbase.core.Lifecycle;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.util.Pair;

public class OHTableClient
implements Table,
Lifecycle {
    private byte[] tableName;
    private String tableNameString;
    private ReentrantLock lock = new ReentrantLock();
    private OHTable ohTable;
    private volatile boolean initialized = false;
    private final Configuration conf;
    private ExecutorService runtimeBatchExecutor;

    public void setRuntimeBatchExecutor(ExecutorService runtimeBatchExecutor) {
        this.runtimeBatchExecutor = runtimeBatchExecutor;
    }

    public OHTableClient(String tableNameString, Configuration conf) {
        this.tableNameString = tableNameString;
        this.tableName = tableNameString.getBytes();
        this.conf = conf;
    }

    @Override
    public void init() throws Exception {
        if (!this.initialized) {
            this.lock.lock();
            try {
                if (!this.initialized) {
                    this.ohTable = new OHTable(this.conf, this.tableNameString);
                    this.initialized = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.initialized) {
            this.lock.lock();
            try {
                if (this.initialized && this.ohTable != null) {
                    this.ohTable.close();
                }
            }
            finally {
                this.initialized = false;
                this.lock.unlock();
            }
        }
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        this.checkStatus();
        return this.ohTable.coprocessorService(row);
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        this.checkStatus();
        return this.ohTable.coprocessorService(service, startKey, endKey, callable);
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.checkStatus();
        this.ohTable.coprocessorService(service, startKey, endKey, callable, callback);
    }

    private void checkStatus() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("tableName " + this.tableNameString + " is not initialized");
        }
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        this.checkStatus();
        return this.ohTable.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype);
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.checkStatus();
        this.ohTable.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype, callback);
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations mutations) throws IOException {
        this.checkStatus();
        return this.ohTable.checkAndMutate(row, family, qualifier, compareOp, value, mutations);
    }

    public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        this.checkStatus();
        return this.ohTable.checkAndMutate(row, family);
    }

    public void setOperationTimeout(int i) {
        this.checkStatus();
        this.ohTable.setOperationTimeout(i);
    }

    public int getOperationTimeout() {
        this.checkStatus();
        return this.ohTable.getOperationTimeout();
    }

    public void setRpcTimeout(int i) {
        this.checkStatus();
        this.ohTable.setRpcTimeout(i);
    }

    public int getRpcTimeout() {
        this.checkStatus();
        return this.ohTable.getRpcTimeout();
    }

    public TableName getName() {
        return this.ohTable.getName();
    }

    public Configuration getConfiguration() {
        this.checkStatus();
        return this.ohTable.getConfiguration();
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        this.checkStatus();
        return this.ohTable.getTableDescriptor();
    }

    public TableDescriptor getDescriptor() throws IOException {
        return null;
    }

    public boolean exists(Get get) throws IOException {
        this.checkStatus();
        return this.ohTable.exists(get);
    }

    public boolean[] existsAll(List<Get> list) throws IOException {
        this.checkStatus();
        return this.ohTable.existsAll(list);
    }

    public boolean[] exists(List<Get> gets) throws IOException {
        this.checkStatus();
        return this.ohTable.exists(gets);
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        this.checkStatus();
        this.ohTable.batch(actions, results);
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.checkStatus();
        this.ohTable.batchCallback(actions, results, callback);
    }

    public Result get(Get get) throws IOException {
        this.checkStatus();
        return this.ohTable.get(get);
    }

    public Result[] get(List<Get> gets) throws IOException {
        this.checkStatus();
        return this.ohTable.get(gets);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        this.checkStatus();
        return this.ohTable.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        this.checkStatus();
        return this.ohTable.getScanner(family);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        this.checkStatus();
        return this.ohTable.getScanner(family, qualifier);
    }

    public List<ResultScanner> getScanners(Scan scan) throws IOException {
        this.checkStatus();
        return this.ohTable.getScanners(scan);
    }

    public void put(Put put) throws IOException {
        this.checkStatus();
        this.ohTable.put(put);
    }

    public void put(List<Put> puts) throws IOException {
        this.checkStatus();
        this.ohTable.put(puts);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        this.checkStatus();
        return this.ohTable.checkAndPut(row, family, qualifier, value, put);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put) throws IOException {
        this.checkStatus();
        return this.ohTable.checkAndPut(row, family, qualifier, compareOp, value, put);
    }

    public void delete(Delete delete) throws IOException {
        this.checkStatus();
        this.ohTable.delete(delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        this.checkStatus();
        this.ohTable.delete(deletes);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        this.checkStatus();
        return this.ohTable.checkAndDelete(row, family, qualifier, value, delete);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        this.checkStatus();
        return this.ohTable.checkAndDelete(row, family, qualifier, compareOp, value, delete);
    }

    public void mutateRow(RowMutations rm) throws IOException {
        this.checkStatus();
        this.ohTable.mutateRow(rm);
    }

    public Result append(Append append) throws IOException {
        this.checkStatus();
        return this.ohTable.append(append);
    }

    public Result increment(Increment increment) throws IOException {
        this.checkStatus();
        return this.ohTable.increment(increment);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        this.checkStatus();
        return this.ohTable.incrementColumnValue(row, family, qualifier, amount);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        this.checkStatus();
        return this.ohTable.incrementColumnValue(row, family, qualifier, amount, durability);
    }

    public String getTableNameString() {
        return this.tableNameString;
    }

    public void setTableNameString(String tableNameString) {
        this.tableNameString = tableNameString;
        this.tableName = tableNameString.getBytes();
    }

    public void refreshTableEntry(String familyString, boolean hasTestLoad) throws Exception {
        this.checkStatus();
        this.ohTable.refreshTableEntry(familyString, hasTestLoad);
    }

    public byte[][] getStartKeys() throws IOException {
        this.checkStatus();
        return this.ohTable.getStartKeys();
    }

    public byte[][] getEndKeys() throws IOException {
        this.checkStatus();
        return this.ohTable.getEndKeys();
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        this.checkStatus();
        return this.ohTable.getStartEndKeys();
    }
}

