/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.template;

import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.template.AdhocQueryCallback;
import com.marklogic.xcc.template.XccCallback;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XccTemplate {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ContentSource contentSource;

    public XccTemplate(String uri) {
        this.logger.info("uri: " + uri);
        try {
            String[] tokens;
            this.contentSource = ContentSourceFactory.newContentSource((URI)new URI(uri));
            if (this.logger.isInfoEnabled() && (tokens = uri.split("@")).length > 1) {
                String hostAndPort = tokens[tokens.length - 1];
                this.logger.info("Will submit requests to XDBC server at " + hostAndPort);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public XccTemplate(String host, int port, String username, String password, String contentDatabaseName) {
        char[] charPassword = password != null ? password.toCharArray() : new char[]{};
        this.contentSource = contentDatabaseName != null ? ContentSourceFactory.newContentSource((String)host, (int)port, (String)username, (char[])charPassword, (String)contentDatabaseName) : ContentSourceFactory.newContentSource((String)host, (int)port, (String)username, (char[])charPassword);
    }

    public XccTemplate(ContentSource contentSource) {
        this.contentSource = contentSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(XccCallback<T> callback) {
        try (Session session = this.contentSource.newSession();){
            T t = callback.execute(session);
            return t;
        }
        catch (RequestException re) {
            throw new RuntimeException(re);
        }
    }

    public String executeAdhocQuery(String xquery) {
        return this.execute(new AdhocQueryCallback(xquery));
    }
}

