/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import com.marklogic.client.io.Format;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class TokenReplacerDocumentFileProcessor
extends LoggingObject
implements DocumentFileProcessor {
    private TokenReplacer tokenReplacer;

    public TokenReplacerDocumentFileProcessor(TokenReplacer tokenReplacer) {
        this.tokenReplacer = tokenReplacer;
    }

    @Override
    public DocumentFile processDocumentFile(DocumentFile documentFile) {
        if (this.tokenReplacer != null && this.moduleCanBeReadAsString(documentFile.getFormat())) {
            Resource resource;
            String text = documentFile.getModifiedContent();
            if (text == null && (resource = documentFile.getResource()) != null) {
                try {
                    text = new String(FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream()));
                }
                catch (IOException ie) {
                    this.logger.warn("Unable to replace tokens in file: " + documentFile.getUri() + "; cause: " + ie.getMessage());
                }
            }
            if (text != null) {
                text = this.tokenReplacer.replaceTokens(text);
                documentFile.setModifiedContent(text);
            }
        }
        return documentFile;
    }

    protected boolean moduleCanBeReadAsString(Format format) {
        return format != null && (format.equals((Object)Format.JSON) || format.equals((Object)Format.TEXT) || format.equals((Object)Format.XML));
    }
}

