/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class PropertiesDrivenDocumentFileProcessor
extends LoggingObject
implements DocumentFileProcessor,
FileFilter {
    protected static final String WILDCARD_KEY = "*";
    private String propertiesFilename;
    private Map<File, Properties> propertiesCache = new HashMap<File, Properties>();
    private TokenReplacer tokenReplacer;

    protected PropertiesDrivenDocumentFileProcessor(String propertiesFilename) {
        this.propertiesFilename = propertiesFilename;
    }

    @Override
    public boolean accept(File file) {
        return !file.getName().equals(this.propertiesFilename);
    }

    @Override
    public DocumentFile processDocumentFile(DocumentFile documentFile) {
        File file = documentFile.getFile();
        if (!this.accept(file)) {
            return null;
        }
        File propertiesFile = new File(file.getParentFile(), this.propertiesFilename);
        if (propertiesFile.exists()) {
            try {
                Properties props = this.loadProperties(propertiesFile);
                this.processProperties(documentFile, props);
            }
            catch (IOException e) {
                this.logger.warn("Unable to load properties from file: " + propertiesFile.getAbsolutePath(), (Throwable)e);
            }
        }
        return documentFile;
    }

    protected abstract void processProperties(DocumentFile var1, Properties var2);

    protected Properties loadProperties(File propertiesFile) throws IOException {
        Properties props = null;
        if (this.propertiesCache.containsKey(propertiesFile)) {
            props = this.propertiesCache.get(propertiesFile);
        }
        if (props != null) {
            return props;
        }
        props = new Properties();
        try (FileReader reader = new FileReader(propertiesFile);){
            props.load(reader);
            this.propertiesCache.put(propertiesFile, props);
            Properties properties = props;
            return properties;
        }
    }

    protected String getPropertyValue(Properties properties, String propertyName) {
        if (properties == null || propertyName == null) {
            return null;
        }
        String value = properties.getProperty(propertyName);
        return this.tokenReplacer != null && value != null ? this.tokenReplacer.replaceTokens(value) : value;
    }

    public Map<File, Properties> getPropertiesCache() {
        return this.propertiesCache;
    }

    public String getPropertiesFilename() {
        return this.propertiesFilename;
    }

    public void setTokenReplacer(TokenReplacer tokenReplacer) {
        this.tokenReplacer = tokenReplacer;
    }

    protected TokenReplacer getTokenReplacer() {
        return this.tokenReplacer;
    }
}

