/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.file.FormatDocumentFileProcessor;
import com.marklogic.client.ext.helper.LoggingObject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.ClassUtils;

public abstract class AbstractDocumentFileReader
extends LoggingObject {
    private List<DocumentFileProcessor> documentFileProcessors = new ArrayList<DocumentFileProcessor>();
    private FormatDocumentFileProcessor formatDocumentFileProcessor = new FormatDocumentFileProcessor();
    private boolean catchProcessingError = false;

    protected AbstractDocumentFileReader() {
        this.documentFileProcessors.add(this.formatDocumentFileProcessor);
    }

    public DocumentFileProcessor getDocumentFileProcessor(String classShortName) {
        for (DocumentFileProcessor processor : this.documentFileProcessors) {
            if (!ClassUtils.getShortName(processor.getClass()).equals(classShortName)) continue;
            return processor;
        }
        return null;
    }

    public void addDocumentFileProcessor(DocumentFileProcessor processor) {
        if (this.documentFileProcessors == null) {
            this.documentFileProcessors = new ArrayList<DocumentFileProcessor>();
        }
        this.documentFileProcessors.add(processor);
    }

    protected DocumentFile processDocumentFile(DocumentFile documentFile) {
        for (DocumentFileProcessor processor : this.documentFileProcessors) {
            try {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(String.format("Applying processor %s to DocumentFile with URI: %s", processor.getClass().getName(), documentFile.getUri()));
                }
                documentFile = processor.processDocumentFile(documentFile);
            }
            catch (Exception e) {
                String message = "Error while processing file: " + documentFile.getFile() + "; cause: " + e.getMessage();
                if (this.catchProcessingError) {
                    this.logger.error(message, (Throwable)e);
                }
                throw new RuntimeException(message, e);
            }
            if (documentFile != null) continue;
            break;
        }
        return documentFile;
    }

    public List<DocumentFileProcessor> getDocumentFileProcessors() {
        return this.documentFileProcessors;
    }

    public void setDocumentFileProcessors(List<DocumentFileProcessor> documentFileProcessors) {
        this.documentFileProcessors = documentFileProcessors;
    }

    public FormatDocumentFileProcessor getFormatDocumentFileProcessor() {
        return this.formatDocumentFileProcessor;
    }

    public void setFormatDocumentFileProcessor(FormatDocumentFileProcessor formatDocumentFileProcessor) {
        this.formatDocumentFileProcessor = formatDocumentFileProcessor;
    }

    public boolean isCatchProcessingError() {
        return this.catchProcessingError;
    }

    public void setCatchProcessingError(boolean catchProcessingError) {
        this.catchProcessingError = catchProcessingError;
    }
}

