/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.batch;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.ext.batch.BatchHandler;
import com.marklogic.client.ext.batch.BatchWriterSupport;
import com.marklogic.client.ext.batch.DefaultBatchHandler;
import com.marklogic.client.io.Format;
import java.util.Arrays;
import java.util.List;

public class RestBatchWriter
extends BatchWriterSupport {
    private List<DatabaseClient> databaseClients;
    private int clientIndex = 0;
    private boolean releaseDatabaseClients = true;
    private Format contentFormat;
    private ServerTransform serverTransform;
    private BatchHandler batchHandler;

    public RestBatchWriter(DatabaseClient databaseClient) {
        this(databaseClient, true);
    }

    public RestBatchWriter(DatabaseClient databaseClient, boolean releaseDatabaseClients) {
        this(Arrays.asList(databaseClient));
        this.releaseDatabaseClients = releaseDatabaseClients;
    }

    public RestBatchWriter(List<DatabaseClient> databaseClients) {
        this.databaseClients = databaseClients;
    }

    public RestBatchWriter(List<DatabaseClient> databaseClients, boolean releaseDatabaseClients, BatchHandler batchHandler) {
        this(databaseClients);
        this.releaseDatabaseClients = releaseDatabaseClients;
        this.batchHandler = batchHandler;
    }

    @Override
    public void write(List<? extends DocumentWriteOperation> items) {
        this.initialize();
        DatabaseClient client = this.determineDatabaseClientToUse();
        Runnable runnable = this.buildRunnable(client, items);
        this.executeRunnable(runnable, items);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.batchHandler == null) {
            DefaultBatchHandler dbh = new DefaultBatchHandler();
            dbh.setContentFormat(this.contentFormat);
            dbh.setServerTransform(this.serverTransform);
            this.batchHandler = dbh;
        }
    }

    protected DatabaseClient determineDatabaseClientToUse() {
        if (this.clientIndex >= this.databaseClients.size()) {
            this.clientIndex = 0;
        }
        DatabaseClient client = this.databaseClients.get(this.clientIndex);
        ++this.clientIndex;
        return client;
    }

    protected Runnable buildRunnable(final DatabaseClient client, final List<? extends DocumentWriteOperation> items) {
        return new Runnable(){

            @Override
            public void run() {
                RestBatchWriter.this.batchHandler.handleBatch(client, items);
            }
        };
    }

    @Override
    public void waitForCompletion() {
        super.waitForCompletion();
        if (this.databaseClients != null && this.releaseDatabaseClients) {
            this.logger.info("Releasing DatabaseClient instances...");
            for (DatabaseClient client : this.databaseClients) {
                client.release();
            }
            this.logger.info("Finished releasing DatabaseClient instances");
        }
    }

    public void setReleaseDatabaseClients(boolean releaseDatabaseClients) {
        this.releaseDatabaseClients = releaseDatabaseClients;
    }

    public void setServerTransform(ServerTransform serverTransform) {
        this.serverTransform = serverTransform;
    }

    protected List<DatabaseClient> getDatabaseClients() {
        return this.databaseClients;
    }

    protected int getClientIndex() {
        return this.clientIndex;
    }

    protected boolean isReleaseDatabaseClients() {
        return this.releaseDatabaseClients;
    }

    protected ServerTransform getServerTransform() {
        return this.serverTransform;
    }

    public void setContentFormat(Format contentFormat) {
        this.contentFormat = contentFormat;
    }

    public void setBatchHandler(BatchHandler batchHandler) {
        this.batchHandler = batchHandler;
    }
}

