/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.spring;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.DatabaseClientConfig;
import com.marklogic.client.ext.DefaultConfiguredDatabaseClientFactory;
import com.marklogic.client.ext.helper.LoggingObject;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

public class DatabaseClientManager
extends LoggingObject
implements FactoryBean<DatabaseClient>,
DisposableBean {
    private DatabaseClientConfig config;
    private DatabaseClient client;

    public DatabaseClientManager() {
    }

    public DatabaseClientManager(DatabaseClientConfig config) {
        this();
        this.config = config;
    }

    public DatabaseClient getObject() {
        if (this.client == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Connecting to REST server with: " + this.config);
            }
            this.client = new DefaultConfiguredDatabaseClientFactory().newDatabaseClient(this.config);
        }
        return this.client;
    }

    public Class<?> getObjectType() {
        return DatabaseClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.client != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Releasing client with username: " + this.config.getUsername());
            }
            this.client.release();
        }
    }

    public void setConfig(DatabaseClientConfig config) {
        this.config = config;
    }
}

