/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.modulesloader.impl;

import com.marklogic.client.admin.ExtensionMetadata;
import com.marklogic.client.admin.MethodType;
import com.marklogic.client.admin.ResourceExtensionsManager;
import com.marklogic.client.ext.helper.FilenameUtil;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.modulesloader.ExtensionMetadataAndParams;
import com.marklogic.client.ext.modulesloader.ExtensionMetadataProvider;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class DefaultExtensionMetadataProvider
extends LoggingObject
implements ExtensionMetadataProvider {
    private ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    @Override
    public ExtensionMetadataAndParams provideExtensionMetadataAndParams(Resource r) {
        Resource metadataResource;
        String filename = this.getFilenameMinusExtension(r);
        URL url = null;
        try {
            url = r.getURL();
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
        String metadataPath = url.toString().replace(r.getFilename(), "");
        String metadataFile = metadataPath + "metadata/" + filename + ".xml";
        ExtensionMetadata m = new ExtensionMetadata();
        ArrayList<ResourceExtensionsManager.MethodParameters> paramList = new ArrayList<ResourceExtensionsManager.MethodParameters>();
        if (FilenameUtil.isJavascriptFile(r.getFilename())) {
            m.setScriptLanguage(ExtensionMetadata.ScriptLanguage.JAVASCRIPT);
            m.setVersion("1.0");
        }
        if ((metadataResource = this.resolver.getResource(metadataFile)) != null) {
            try {
                Element root = new SAXBuilder().build(metadataResource.getInputStream()).getRootElement();
                m.setTitle(root.getChildText("title"));
                Element desc = root.getChild("description");
                if (desc.getChildren() != null && desc.getChildren().size() == 1) {
                    m.setDescription(new XMLOutputter().outputString((Element)desc.getChildren().get(0)));
                } else {
                    m.setDescription(desc.getText());
                }
                for (Element method : root.getChildren("method")) {
                    ResourceExtensionsManager.MethodParameters mp = new ResourceExtensionsManager.MethodParameters(MethodType.valueOf((String)method.getAttributeValue("name")));
                    paramList.add(mp);
                    for (Element param : method.getChildren("param")) {
                        String name = param.getAttributeValue("name");
                        String type = "xs:string";
                        if (param.getAttribute("type") != null) {
                            type = param.getAttributeValue("type");
                        }
                        mp.add(name, type);
                    }
                }
            }
            catch (IOException ie) {
                this.logger.debug("Unable to build metadata from resource file: " + url.toString() + "; cause: " + ie.getMessage());
                this.setDefaults(m, r);
            }
            catch (Exception e) {
                this.logger.warn("Unable to build metadata from resource file: " + url.toString() + "; cause: " + e.getMessage());
                this.setDefaults(m, r);
            }
        } else {
            this.setDefaults(m, r);
        }
        return new ExtensionMetadataAndParams(m, paramList);
    }

    protected String getFilenameMinusExtension(Resource file) {
        String[] tokens = file.getFilename().split("\\.");
        tokens = Arrays.copyOfRange(tokens, 0, tokens.length - 1);
        String filename = tokens[0];
        for (int i = 1; i < tokens.length; ++i) {
            filename = filename + "." + tokens[i];
        }
        return filename;
    }

    private void setDefaults(ExtensionMetadata metadata, Resource resourceFile) {
        metadata.setTitle(this.getFilenameMinusExtension(resourceFile));
    }
}

