/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DocumentFile {
    private String uri;
    private Resource resource;
    private Format format;
    private DocumentMetadataHandle documentMetadata;
    private String temporalDocumentURI;
    private String modifiedContent;
    private Path rootPath;

    public DocumentFile(String uri, Resource resource) {
        this.init(uri, resource);
    }

    public DocumentFile(String uri, File file) {
        this.init(uri, (Resource)new FileSystemResource(file));
    }

    private void init(String uri, Resource resource) {
        this.uri = uri;
        this.resource = resource;
        this.documentMetadata = new DocumentMetadataHandle();
    }

    public DocumentWriteOperation toDocumentWriteOperation() {
        return new DocumentWriteOperationImpl(this.getOperationType(), this.uri, (DocumentMetadataWriteHandle)this.getMetadata(), this.getContent(), this.getTemporalDocumentURI());
    }

    public String getUri() {
        return this.uri;
    }

    public DocumentWriteOperation.OperationType getOperationType() {
        return DocumentWriteOperation.OperationType.DOCUMENT_WRITE;
    }

    public DocumentMetadataHandle getMetadata() {
        return this.documentMetadata;
    }

    public AbstractWriteHandle getContent() {
        if (this.modifiedContent != null) {
            StringHandle h = new StringHandle(this.modifiedContent);
            return this.format != null ? h.withFormat(this.format) : h;
        }
        InputStreamHandle h = null;
        try {
            h = new InputStreamHandle(this.resource.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.format != null ? h.withFormat(this.format) : h;
    }

    public String getTemporalDocumentURI() {
        return this.temporalDocumentURI;
    }

    public String getFileExtension() {
        if (this.resource != null) {
            String name = this.resource.getFilename();
            int pos = name.lastIndexOf(46);
            return pos < 0 ? name : name.substring(pos + 1);
        }
        return null;
    }

    public Resource getResource() {
        return this.resource;
    }

    public File getFile() {
        File file;
        try {
            file = this.resource.getFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public DocumentMetadataHandle getDocumentMetadata() {
        return this.documentMetadata;
    }

    public void setDocumentMetadata(DocumentMetadataHandle documentMetadata) {
        this.documentMetadata = documentMetadata;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setTemporalDocumentURI(String temporalDocumentURI) {
        this.temporalDocumentURI = temporalDocumentURI;
    }

    public void setModifiedContent(String modifiedContent) {
        this.modifiedContent = modifiedContent;
    }

    public String getModifiedContent() {
        return this.modifiedContent;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(Path rootPath) {
        this.rootPath = rootPath;
    }
}

