/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.batch;

import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.ext.batch.BatchWriterSupport;
import com.marklogic.client.ext.xcc.DefaultDocumentWriteOperationAdapter;
import com.marklogic.client.ext.xcc.DocumentWriteOperationAdapter;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import java.util.List;

public class XccBatchWriter
extends BatchWriterSupport {
    private List<ContentSource> contentSources;
    private int contentSourceIndex = 0;
    private DocumentWriteOperationAdapter documentWriteOperationAdapter;

    public XccBatchWriter(List<ContentSource> contentSources) {
        this.contentSources = contentSources;
        this.documentWriteOperationAdapter = new DefaultDocumentWriteOperationAdapter();
    }

    @Override
    public void write(List<? extends DocumentWriteOperation> items) {
        ContentSource contentSource = this.determineContentSourceToUse();
        Runnable runnable = this.buildRunnable(contentSource, items);
        this.executeRunnable(runnable, items);
    }

    protected ContentSource determineContentSourceToUse() {
        if (this.contentSourceIndex >= this.contentSources.size()) {
            this.contentSourceIndex = 0;
        }
        ContentSource contentSource = this.contentSources.get(this.contentSourceIndex);
        ++this.contentSourceIndex;
        return contentSource;
    }

    protected Runnable buildRunnable(final ContentSource contentSource, final List<? extends DocumentWriteOperation> items) {
        return new Runnable(){

            @Override
            public void run() {
                Session session = contentSource.newSession();
                int count = items.size();
                Content[] array = new Content[count];
                for (int i = 0; i < count; ++i) {
                    array[i] = XccBatchWriter.this.documentWriteOperationAdapter.adapt((DocumentWriteOperation)items.get(i));
                }
                if (XccBatchWriter.this.logger.isDebugEnabled()) {
                    XccBatchWriter.this.logger.debug("Writing " + count + " documents to MarkLogic");
                }
                try {
                    session.insertContent(array);
                    if (XccBatchWriter.this.logger.isInfoEnabled()) {
                        XccBatchWriter.this.logger.info("Wrote " + count + " documents to MarkLogic");
                    }
                }
                catch (RequestException e) {
                    throw new RuntimeException("Unable to insert content: " + e.getMessage(), e);
                }
                finally {
                    session.close();
                }
            }
        };
    }

    public void setDocumentWriteOperationAdapter(DocumentWriteOperationAdapter documentWriteOperationAdapter) {
        this.documentWriteOperationAdapter = documentWriteOperationAdapter;
    }
}

