/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.batch;

import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.ext.batch.BatchWriter;
import com.marklogic.client.ext.batch.DefaultWriteListener;
import com.marklogic.client.ext.batch.WriteListener;
import com.marklogic.client.ext.helper.LoggingObject;
import java.util.List;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public abstract class BatchWriterSupport
extends LoggingObject
implements BatchWriter {
    private TaskExecutor taskExecutor;
    private int threadCount = 16;
    private WriteListener writeListener = new DefaultWriteListener();

    @Override
    public void initialize() {
        if (this.taskExecutor == null) {
            this.initializeDefaultTaskExecutor();
        }
    }

    @Override
    public void waitForCompletion() {
        if (this.taskExecutor instanceof ExecutorConfigurationSupport) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Calling shutdown on thread pool");
            }
            ((ExecutorConfigurationSupport)this.taskExecutor).shutdown();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Thread pool finished shutdown");
            }
            this.taskExecutor = null;
        }
        if (this.writeListener != null) {
            this.writeListener.afterCompletion();
        }
    }

    protected void initializeDefaultTaskExecutor() {
        if (this.threadCount > 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Initializing thread pool with a count of " + this.threadCount);
            }
            ThreadPoolTaskExecutor tpte = new ThreadPoolTaskExecutor();
            tpte.setCorePoolSize(this.threadCount);
            tpte.setWaitForTasksToCompleteOnShutdown(true);
            tpte.setAwaitTerminationSeconds(3600);
            tpte.afterPropertiesSet();
            this.taskExecutor = tpte;
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Thread count is 1, so using a synchronous TaskExecutor");
            }
            this.taskExecutor = new SyncTaskExecutor();
        }
    }

    protected void executeRunnable(Runnable runnable, final List<? extends DocumentWriteOperation> items) {
        if (this.writeListener != null && this.taskExecutor instanceof AsyncListenableTaskExecutor) {
            AsyncListenableTaskExecutor asyncListenableTaskExecutor = (AsyncListenableTaskExecutor)this.taskExecutor;
            ListenableFuture future = asyncListenableTaskExecutor.submitListenable(runnable);
            future.addCallback((ListenableFutureCallback)new ListenableFutureCallback<Object>(){

                public void onFailure(Throwable ex) {
                    BatchWriterSupport.this.writeListener.onWriteFailure(ex, items);
                }

                public void onSuccess(Object result) {
                }
            });
        } else {
            this.taskExecutor.execute(runnable);
        }
    }

    protected TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    protected WriteListener getWriteListener() {
        return this.writeListener;
    }

    public void setWriteListener(WriteListener writeListener) {
        this.writeListener = writeListener;
    }

    public int getThreadCount() {
        return this.threadCount;
    }
}

