/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.modulesloader.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.modulesloader.impl.LoadModulesFailureListener;
import java.util.function.Supplier;

public class SimpleLoadModulesFailureListener
extends LoggingObject
implements LoadModulesFailureListener,
Supplier<Throwable> {
    private Throwable firstThrowable;

    @Override
    public void processFailure(Throwable throwable, DatabaseClient databaseClient) {
        String message = this.format("Error occurred while loading modules; host: %s; port: %d; cause: %s", databaseClient.getHost(), databaseClient.getPort(), throwable.getMessage());
        RuntimeException exception = new RuntimeException(message, throwable);
        if (this.firstThrowable == null) {
            this.firstThrowable = exception;
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message, throwable);
        }
    }

    @Override
    public Throwable get() {
        return this.firstThrowable;
    }
}

