/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.PropertiesDrivenDocumentFileProcessor;
import java.util.Properties;

public class CollectionsFileDocumentFileProcessor
extends PropertiesDrivenDocumentFileProcessor {
    private String delimiter = ",";

    public CollectionsFileDocumentFileProcessor() {
        this("collections.properties");
    }

    public CollectionsFileDocumentFileProcessor(String propertiesFilename) {
        super(propertiesFilename);
    }

    @Override
    protected void processProperties(DocumentFile documentFile, Properties properties) {
        String value;
        String name = documentFile.getFile().getName();
        if (properties.containsKey(name)) {
            value = this.getPropertyValue(properties, name);
            documentFile.getDocumentMetadata().withCollections(value.split(this.delimiter));
        }
        if (properties.containsKey("*")) {
            value = this.getPropertyValue(properties, "*");
            documentFile.getDocumentMetadata().withCollections(value.split(this.delimiter));
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

