/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.ext.ConfiguredDatabaseClientFactory;
import com.marklogic.client.ext.DatabaseClientConfig;
import com.marklogic.client.ext.SecurityContextType;
import com.marklogic.client.ext.ssl.SslConfig;
import com.marklogic.client.ext.ssl.SslUtil;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public class DefaultConfiguredDatabaseClientFactory
implements ConfiguredDatabaseClientFactory {
    @Override
    public DatabaseClient newDatabaseClient(DatabaseClientConfig config) {
        DatabaseClientFactory.BasicAuthContext securityContext;
        SecurityContextType securityContextType = config.getSecurityContextType();
        DatabaseClient.ConnectionType connectionType = config.getConnectionType();
        if (SecurityContextType.BASIC.equals((Object)securityContextType)) {
            securityContext = new DatabaseClientFactory.BasicAuthContext(config.getUsername(), config.getPassword());
        } else if (SecurityContextType.CERTIFICATE.equals((Object)securityContextType)) {
            securityContext = this.buildCertificateAuthContent(config);
        } else if (SecurityContextType.DIGEST.equals((Object)securityContextType)) {
            securityContext = new DatabaseClientFactory.DigestAuthContext(config.getUsername(), config.getPassword());
        } else if (SecurityContextType.KERBEROS.equals((Object)securityContextType)) {
            securityContext = new DatabaseClientFactory.KerberosAuthContext(config.getExternalName());
        } else if (SecurityContextType.NONE.equals((Object)securityContextType)) {
            securityContext = null;
        } else {
            throw new IllegalArgumentException("Unsupported SecurityContextType: " + (Object)((Object)securityContextType));
        }
        if (securityContext != null) {
            DatabaseClientFactory.SSLHostnameVerifier verifier;
            SslConfig sslConfig = this.determineSslConfig(config);
            if (sslConfig != null) {
                securityContext = securityContext.withSSLContext(sslConfig.getSslContext(), sslConfig.getTrustManager());
            }
            if ((verifier = config.getSslHostnameVerifier()) != null) {
                securityContext = securityContext.withSSLHostnameVerifier(verifier);
            }
        }
        String host = config.getHost();
        int port = config.getPort();
        String database = config.getDatabase();
        if (connectionType == null) {
            if (securityContext == null) {
                if (database == null) {
                    return DatabaseClientFactory.newClient((String)host, (int)port);
                }
                return DatabaseClientFactory.newClient((String)host, (int)port, (String)database);
            }
            if (database == null) {
                return DatabaseClientFactory.newClient((String)host, (int)port, (DatabaseClientFactory.SecurityContext)securityContext);
            }
            return DatabaseClientFactory.newClient((String)host, (int)port, (String)database, (DatabaseClientFactory.SecurityContext)securityContext);
        }
        if (securityContext == null) {
            if (database == null) {
                return DatabaseClientFactory.newClient((String)host, (int)port, null, (DatabaseClient.ConnectionType)connectionType);
            }
            return DatabaseClientFactory.newClient((String)host, (int)port, (String)database, null, (DatabaseClient.ConnectionType)connectionType);
        }
        if (database == null) {
            return DatabaseClientFactory.newClient((String)host, (int)port, (DatabaseClientFactory.SecurityContext)securityContext, (DatabaseClient.ConnectionType)connectionType);
        }
        return DatabaseClientFactory.newClient((String)host, (int)port, (String)database, (DatabaseClientFactory.SecurityContext)securityContext, (DatabaseClient.ConnectionType)connectionType);
    }

    protected DatabaseClientFactory.SecurityContext buildCertificateAuthContent(DatabaseClientConfig config) {
        X509TrustManager trustManager = config.getTrustManager();
        String certFile = config.getCertFile();
        if (certFile != null) {
            try {
                if (config.getCertPassword() != null) {
                    return new DatabaseClientFactory.CertificateAuthContext(certFile, config.getCertPassword(), trustManager);
                }
                return new DatabaseClientFactory.CertificateAuthContext(certFile, trustManager);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to build CertificateAuthContext: " + ex.getMessage(), ex);
            }
        }
        SslConfig sslConfig = this.determineSslConfig(config);
        DatabaseClientFactory.SSLHostnameVerifier verifier = config.getSslHostnameVerifier();
        return verifier != null ? new DatabaseClientFactory.CertificateAuthContext(sslConfig.getSslContext(), verifier, sslConfig.getTrustManager()) : new DatabaseClientFactory.CertificateAuthContext(sslConfig.getSslContext(), sslConfig.getTrustManager());
    }

    protected SslConfig determineSslConfig(DatabaseClientConfig config) {
        SSLContext sslContext = config.getSslContext();
        X509TrustManager trustManager = config.getTrustManager();
        if (sslContext != null && trustManager != null) {
            return new SslConfig(sslContext, trustManager);
        }
        String protocol = config.getSslProtocol();
        return protocol != null && protocol.trim().length() > 0 ? SslUtil.configureUsingTrustManagerFactory(protocol, config.getTrustManagementAlgorithm()) : null;
    }
}

