/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.io.Base64;
import com.marklogic.io.IOHelper;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.UserCredentials;
import com.marklogic.xcc.impl.SessionImpl;
import com.marklogic.xcc.spi.ConnectionProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

public class ContentSourceImpl
implements ContentSource {
    private static final String DEFAULT_LOGGER_NAME = "com.marklogic.xcc";
    private static final String XCC_LOGGING_CONFIG_FILE = "xcc.logging.properties";
    private static final String XCC_CONFIG_FILE = "xcc.properties";
    private static final String SYSTEM_LOGGING_CONFIG_CLASS = "java.util.logging.config.class";
    private static final String SYSTEM_LOGGING_CONFIG_FILE = "java.util.logging.config.file";
    private final ConnectionProvider connectionProvider;
    private final String user;
    private final char[] password;
    private final String contentBase;
    private boolean authenticationPreemptive = false;
    private boolean challengeIgnored = false;
    private Logger logger = ContentSourceImpl.newDefaultLogger();
    private AuthType authType = AuthType.NONE;
    private String challenge;
    private static Random random = new Random();
    private Credentials credentials;

    private static Logger newDefaultLogger() {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger(DEFAULT_LOGGER_NAME);
        if (logger != null) {
            return logger;
        }
        if (System.getProperty(SYSTEM_LOGGING_CONFIG_CLASS) != null || System.getProperty(SYSTEM_LOGGING_CONFIG_FILE) != null) {
            return Logger.getLogger(DEFAULT_LOGGER_NAME);
        }
        return ContentSourceImpl.customizedLogger(logManager);
    }

    private void initializeConfig() {
        URL url = this.getClass().getClassLoader().getResource(XCC_CONFIG_FILE);
        Properties props = System.getProperties();
        if (url != null) {
            try (FileInputStream is = new FileInputStream(url.getPath());){
                props.load(is);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "property file not found:" + url.getPath());
            }
        }
    }

    public ContentSourceImpl(ConnectionProvider connectionProvider, String user, char[] password, String contentBase) {
        this.connectionProvider = connectionProvider;
        this.user = user;
        this.password = password;
        this.credentials = new Credentials(user, password);
        String cbName = contentBase;
        if (cbName != null && (cbName = cbName.trim()).length() == 0) {
            cbName = null;
        }
        this.contentBase = cbName;
        this.initializeConfig();
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public Session newSession() {
        return new SessionImpl(this, this.connectionProvider, this.credentials, this.contentBase);
    }

    @Override
    public Session newSession(String userName, char[] password) {
        return new SessionImpl(this, this.connectionProvider, new Credentials(userName, password), this.contentBase);
    }

    @Override
    public Session newSession(String user, char[] password, String contentBaseArg) {
        String contentBase = contentBaseArg == null ? this.contentBase : contentBaseArg;
        return new SessionImpl(this, this.connectionProvider, new Credentials(user, password), contentBase);
    }

    @Override
    public Session newSession(String databaseId) {
        return new SessionImpl(this, this.connectionProvider, this.credentials, databaseId);
    }

    @Override
    public Logger getDefaultLogger() {
        return this.logger;
    }

    @Override
    public void setDefaultLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isAuthenticationPreemptive() {
        return this.authenticationPreemptive;
    }

    @Override
    public void setAuthenticationPreemptive(boolean value) {
        this.authenticationPreemptive = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthChallenge(String challenge) {
        ContentSourceImpl contentSourceImpl = this;
        synchronized (contentSourceImpl) {
            this.authType = AuthType.valueOf(challenge.split(" ")[0].toUpperCase());
            this.challenge = challenge;
        }
    }

    public boolean isChallengeIgnored() {
        return this.challengeIgnored;
    }

    public void setChallengeIgnored(boolean challengeIgnored) {
        this.challengeIgnored = challengeIgnored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAuthString(String method, String uri, UserCredentials credentials) {
        String challenge;
        AuthType authType;
        ContentSourceImpl contentSourceImpl = this;
        synchronized (contentSourceImpl) {
            authType = this.authType;
            challenge = this.challenge;
        }
        switch (authType) {
            case BASIC: {
                return credentials.toHttpBasicAuth();
            }
            case DIGEST: {
                return credentials.toHttpDigestAuth(method, uri, challenge);
            }
            case NEGOTIATE: {
                return credentials.toHttpNegotiateAuth(this.connectionProvider.getHostName(), challenge);
            }
        }
        return this.isAuthenticationPreemptive() ? credentials.toHttpBasicAuth() : null;
    }

    public String toString() {
        return "user=" + (this.user == null ? "{none}" : this.user) + ", cb=" + (this.contentBase == null ? "{none}" : this.contentBase) + " [provider: " + this.connectionProvider.toString() + "]";
    }

    private static Logger customizedLogger(LogManager logManager) {
        Properties props = ContentSourceImpl.loadLoggingPropertiesFromResource();
        Logger logger = Logger.getLogger(DEFAULT_LOGGER_NAME);
        List<Handler> handlers = ContentSourceImpl.getLoggerHandlers(logger, logManager, props);
        Iterator<Handler> it = handlers.iterator();
        while (it.hasNext()) {
            logger.addHandler(it.next());
        }
        boolean useParentHandlers = ContentSourceImpl.getUseParentHandlersFlag(logger, logManager, props);
        logger.setUseParentHandlers(useParentHandlers);
        logManager.addLogger(logger);
        return logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadLoggingPropertiesFromResource() {
        Object logger;
        Properties props;
        block29: {
            props = new Properties();
            URL url = ClassLoader.getSystemResource(XCC_LOGGING_CONFIG_FILE);
            if (url != null) {
                try (FileInputStream is = new FileInputStream(url.getPath());){
                    props.load(is);
                    Properties throwable3 = props;
                    return throwable3;
                }
                catch (IOException e) {
                    logger = Logger.getLogger(DEFAULT_LOGGER_NAME);
                    if (logger == null) break block29;
                    ((Logger)logger).warning("property file not found: " + url);
                }
            }
        }
        try {
            InputStream is = ContentSource.class.getResourceAsStream(XCC_LOGGING_CONFIG_FILE);
            logger = null;
            try {
                if (is == null) return props;
                props.load(is);
                return props;
            }
            catch (Throwable throwable) {
                logger = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (logger != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)logger).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger = Logger.getLogger(DEFAULT_LOGGER_NAME);
            if (logger == null) return props;
            ((Logger)logger).warning("Error loading default logging file: " + e.getMessage());
        }
        return props;
    }

    private static List<Handler> getLoggerHandlers(Logger logger, LogManager logManager, Properties props) {
        String propName = logger.getName() + ".handlers";
        String handlerPropVal = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        if (handlerPropVal == null) {
            return new ArrayList<Handler>(0);
        }
        String[] handlerClassNames = handlerPropVal.split("\\\\s*,?\\\\s*");
        ArrayList<Handler> handlers = new ArrayList<Handler>(handlerClassNames.length);
        Level level = ContentSourceImpl.getLoggerLevel(logger, logManager, props);
        if (level != null) {
            logger.setLevel(level);
        }
        for (int i = 0; i < handlerClassNames.length; ++i) {
            try {
                Class<Handler> handlerClass = Class.forName(handlerClassNames[i]).asSubclass(Handler.class);
                Handler handler = handlerClass.newInstance();
                Formatter formatter = ContentSourceImpl.getFormatter(handler, logManager, props);
                handlers.add(handler);
                if (formatter != null) {
                    handler.setFormatter(formatter);
                }
                if (level == null) continue;
                handler.setLevel(level);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return handlers;
    }

    private static Formatter getFormatter(Handler handler, LogManager logManager, Properties props) {
        String propName = handler.getClass().getName() + ".formatter";
        String formatterClassName = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        try {
            Class<Formatter> clazz = Class.forName(formatterClassName).asSubclass(Formatter.class);
            Constructor<Formatter> cons = null;
            try {
                cons = clazz.getConstructor(Properties.class, LogManager.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cons != null) {
                return cons.newInstance(props, logManager);
            }
            return (Formatter)Class.forName(formatterClassName).newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Level getLoggerLevel(Logger logger, LogManager logManager, Properties props) {
        String propName = logger.getName() + ".level";
        String levelName = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        try {
            return Level.parse(levelName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean getUseParentHandlersFlag(Logger logger, LogManager logManager, Properties props) {
        String propName = logger.getName() + ".useParentHandlers";
        String propValue = ContentSourceImpl.getPropertyValue(propName, logManager, props);
        if (propValue == null) {
            return false;
        }
        try {
            return Boolean.valueOf(propValue);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getPropertyValue(String propName, LogManager logManager, Properties props) {
        String propVal = props.getProperty(propName);
        if (propVal != null) {
            return propVal.trim();
        }
        propVal = logManager.getProperty(propName);
        if (propVal != null) {
            return propVal.trim();
        }
        return null;
    }

    public static String digestCalcResponse(String HA1, String nonce, String nonceCount, String cNonce, String qop, String method, String uri) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            StringBuilder plaintext = new StringBuilder();
            plaintext.append(method);
            plaintext.append(":");
            plaintext.append(uri);
            digest.update(plaintext.toString().getBytes(), 0, plaintext.length());
            String HA2 = IOHelper.bytesToHex(digest.digest());
            plaintext.setLength(0);
            plaintext.append(HA1);
            plaintext.append(":");
            plaintext.append(nonce);
            plaintext.append(":");
            if (qop != null) {
                plaintext.append(nonceCount);
                plaintext.append(":");
                plaintext.append(cNonce);
                plaintext.append(":");
                plaintext.append(qop);
                plaintext.append(":");
            }
            plaintext.append(HA2);
            digest.update(plaintext.toString().getBytes(), 0, plaintext.length());
            return IOHelper.bytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String digestCalcHA1(String userName, String realm, char[] password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            StringBuilder plaintext = new StringBuilder();
            plaintext.append(userName);
            plaintext.append(":");
            plaintext.append(realm);
            plaintext.append(":");
            byte[] ubytes = plaintext.toString().getBytes();
            ByteBuffer pbuf = Charset.defaultCharset().encode(CharBuffer.wrap(password));
            byte[] upbytes = new byte[pbuf.remaining() + ubytes.length];
            System.arraycopy(ubytes, 0, upbytes, 0, ubytes.length);
            pbuf.get(upbytes, ubytes.length, pbuf.remaining());
            digest.update(upbytes, 0, upbytes.length);
            return IOHelper.bytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Session newSession(String userName, String password) {
        return this.newSession(userName, password == null ? null : password.toCharArray());
    }

    @Override
    public Session newSession(String userName, String password, String contentbaseId) {
        return this.newSession(userName, password == null ? null : password.toCharArray(), contentbaseId);
    }

    static class Credentials
    implements UserCredentials {
        private String user;
        private char[] password;
        private String basicAuth;
        private String HA1;
        private LoginContext loginContext;
        private static final AtomicLong nonceCounter = new AtomicLong();

        private void buildSubjectCredentials() throws KrbException, IOException, LoginException {
            Subject subject = new Subject();
            sun.security.krb5.Credentials cred = this.user != null && !this.user.equals("") ? sun.security.krb5.Credentials.acquireTGTFromCache(new PrincipalName(this.user), null) : sun.security.krb5.Credentials.acquireTGTFromCache(null, null);
            if (cred == null) {
                throw new KrbException("No ticket granting ticket in the cache");
            }
            Date endTime = cred.getEndTime();
            if (endTime != null && endTime.compareTo(new Date()) == -1) {
                throw new KrbException("The ticket granting ticket in the cache is no longer valid");
            }
            this.loginContext = new LoginContext("Krb5LoginContext", subject, null, new KerberosLoginConfiguration());
            this.loginContext.login();
        }

        private String getAuthorizationHeader(String serverPrincipalName) throws GSSException, LoginException, KrbException, IOException {
            String clientPrincipal = this.getClientPrincipalName();
            CreateAuthorizationHeaderAction action = new CreateAuthorizationHeaderAction(clientPrincipal, serverPrincipalName);
            Set<Object> privateCreds = this.loginContext.getSubject().getPrivateCredentials();
            for (Object privateCred : privateCreds) {
                String serverPrincipalTicketName;
                if (!(privateCred instanceof KerberosTicket) || !(serverPrincipalTicketName = ((KerberosTicket)privateCred).getServer().getName()).startsWith("krbtgt") || ((KerberosTicket)privateCred).getEndTime().compareTo(new Date()) != -1) continue;
                this.buildSubjectCredentials();
                break;
            }
            Subject.doAs(this.loginContext.getSubject(), action);
            return action.getNegotiateToken();
        }

        private String getClientPrincipalName() {
            Set<Principal> principalSet = this.loginContext.getSubject().getPrincipals();
            if (principalSet.size() != 1) {
                throw new IllegalStateException("Only one principal per subject is expected. Found 0 or more than one principals :" + principalSet);
            }
            return principalSet.iterator().next().getName();
        }

        public Credentials(String user, char[] password) {
            this.user = user;
            this.password = password;
            if (user != null && password != null) {
                this.initBasicAuth();
            }
        }

        @Override
        public String getUserName() {
            return this.user;
        }

        void initBasicAuth(Charset encoding) throws UnsupportedEncodingException {
            byte[] ubytes = (this.user + ":").getBytes(encoding);
            ByteBuffer pbuf = encoding.encode(CharBuffer.wrap(this.password));
            byte[] upbytes = new byte[pbuf.remaining() + ubytes.length];
            System.arraycopy(ubytes, 0, upbytes, 0, ubytes.length);
            pbuf.get(upbytes, ubytes.length, pbuf.remaining());
            this.basicAuth = "basic " + Base64.encodeBytes(upbytes, 8);
        }

        void initBasicAuth() {
            try {
                this.initBasicAuth(Charset.forName("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                try {
                    this.initBasicAuth(Charset.defaultCharset());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }

        @Override
        public String toHttpBasicAuth() {
            if (this.user == null || this.password == null && this.basicAuth == null) {
                throw new IllegalStateException("Invalid authentication credentials");
            }
            if (this.password != null) {
                Arrays.fill(this.password, '\u0000');
                this.password = null;
            }
            return this.basicAuth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toHttpDigestAuth(String method, String uri, String challengeHeader) {
            if (this.user == null || this.password == null && this.HA1 == null) {
                throw new IllegalStateException("Invalid authentication credentials");
            }
            if (challengeHeader == null || !challengeHeader.startsWith("Digest ")) {
                return null;
            }
            String[] pairs = challengeHeader.substring("Digest ".length()).split(", +");
            HashMap<String, String> params = new HashMap<String, String>();
            for (String pair : pairs) {
                String[] nv = pair.split("=", 2);
                params.put(nv[0].toLowerCase(), nv[1].substring(1, nv[1].length() - 1));
            }
            String realm = (String)params.get("realm");
            if (this.HA1 == null) {
                this.HA1 = ContentSourceImpl.digestCalcHA1(this.user, realm, this.password);
            }
            String nonce = (String)params.get("nonce");
            String qop = (String)params.get("qop");
            String opaque = (String)params.get("opaque");
            byte[] bytes = new byte[16];
            Random random = random;
            synchronized (random) {
                random.nextBytes(bytes);
            }
            String cNonce = IOHelper.bytesToHex(bytes);
            String nonceCount = Long.toHexString(nonceCounter.incrementAndGet());
            String response = ContentSourceImpl.digestCalcResponse(this.HA1, nonce, nonceCount, cNonce, qop, method, uri);
            StringBuilder buf = new StringBuilder();
            buf.append("Digest username=\"");
            buf.append(this.user);
            buf.append("\", realm=\"");
            buf.append(realm);
            buf.append("\", nonce=\"");
            buf.append(nonce);
            buf.append("\", uri=\"");
            buf.append(uri);
            buf.append("\", qop=\"auth\", nc=\"");
            buf.append(nonceCount);
            buf.append("\", cnonce=\"");
            buf.append(cNonce);
            buf.append("\", response=\"");
            buf.append(response);
            buf.append("\", opaque=\"");
            buf.append(opaque);
            buf.append("\"");
            return buf.toString();
        }

        @Override
        public String toHttpNegotiateAuth(String hostName, String challenge) {
            try {
                if (this.loginContext == null) {
                    this.buildSubjectCredentials();
                }
                String authLine = new String("Negotiate " + this.getAuthorizationHeader("HTTP/" + hostName));
                return authLine;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "user=" + this.user;
        }

        private static class CreateAuthorizationHeaderAction
        implements PrivilegedAction {
            String clientPrincipalName;
            String serverPrincipalName;
            private StringBuffer outputToken = new StringBuffer();

            private CreateAuthorizationHeaderAction(String clientPrincipalName, String serverPrincipalName) {
                this.clientPrincipalName = clientPrincipalName;
                this.serverPrincipalName = serverPrincipalName;
            }

            private String getNegotiateToken() {
                return this.outputToken.toString();
            }

            public Object run() {
                try {
                    Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
                    Oid krb5PrincipalNameType = new Oid("1.2.840.113554.1.2.2.1");
                    GSSManager manager = GSSManager.getInstance();
                    GSSName clientName = manager.createName(this.clientPrincipalName, krb5PrincipalNameType);
                    GSSCredential clientCred = manager.createCredential(clientName, 28800, krb5Mechanism, 1);
                    GSSName serverName = manager.createName(this.serverPrincipalName, krb5PrincipalNameType);
                    GSSContext context = manager.createContext(serverName, krb5Mechanism, clientCred, 0);
                    byte[] inToken = new byte[]{};
                    byte[] outToken = context.initSecContext(inToken, 0, inToken.length);
                    this.outputToken.append(new String(Base64.encodeBytes(outToken, 8)));
                    context.dispose();
                }
                catch (GSSException exception) {
                    throw new RuntimeException(exception.getMessage());
                }
                return null;
            }
        }

        private class KerberosLoginConfiguration
        extends Configuration {
            private KerberosLoginConfiguration() {
            }

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("refreshKrb5Config", "true");
                options.put("useTicketCache", "true");
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        }
    }

    public static enum AuthType {
        NONE,
        BASIC,
        DIGEST,
        NEGOTIATE;

    }
}

