/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.datamovement.job;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.QueryBatchListener;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.datamovement.QueryFailureListener;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.ext.datamovement.BatcherConfig;
import com.marklogic.client.ext.datamovement.CollectionsQueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.DocumentUrisQueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.QueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.QueryBatcherJobTicket;
import com.marklogic.client.ext.datamovement.UriPatternQueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.UrisQueryQueryBatcherBuilder;
import com.marklogic.client.ext.datamovement.job.ConfigurableJob;
import com.marklogic.client.ext.datamovement.job.JobProperty;
import com.marklogic.client.ext.datamovement.job.QueryBatcherJob;
import com.marklogic.client.ext.datamovement.job.SimpleJobProperty;
import com.marklogic.client.ext.datamovement.listener.SimpleBatchLoggingListener;
import com.marklogic.client.ext.datamovement.util.TransformPropertyValueParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class AbstractQueryBatcherJob
extends BatcherConfig
implements QueryBatcherJob,
ConfigurableJob {
    private List<JobProperty> jobProperties = new ArrayList<JobProperty>();
    private List<QueryBatchListener> urisReadyListeners;
    private List<QueryFailureListener> queryFailureListeners;
    private boolean consistentSnapshot = true;
    private boolean awaitCompletion = true;
    private boolean stopJobAfterCompletion = true;
    private DataMovementManager dataMovementManager;
    private QueryBatcherBuilder queryBatcherBuilder;
    private String[] whereUris;
    private String[] whereCollections;
    private String whereUriPattern;
    private String whereUrisQuery;
    private boolean requireWhereProperty = true;

    protected abstract String getJobDescription();

    protected AbstractQueryBatcherJob() {
        this.addQueryBatcherJobProperties();
    }

    @Override
    public QueryBatcherJobTicket run(DatabaseClient databaseClient) {
        DataMovementManager dmm = this.dataMovementManager != null ? this.dataMovementManager : databaseClient.newDataMovementManager();
        String jobDescription = this.getJobDescription();
        if (jobDescription != null && this.logger.isInfoEnabled()) {
            this.logger.info(jobDescription);
        }
        QueryBatcherBuilder builder = this.newQueryBatcherBuilder();
        QueryBatcher queryBatcher = builder.buildQueryBatcher(databaseClient, dmm);
        this.prepareQueryBatcher(queryBatcher);
        JobTicket jobTicket = dmm.startJob(queryBatcher);
        if (this.awaitCompletion) {
            queryBatcher.awaitCompletion();
            if (this.stopJobAfterCompletion) {
                dmm.stopJob((Batcher)queryBatcher);
            }
            if (jobDescription != null && this.logger.isInfoEnabled()) {
                this.logger.info("Completed: " + jobDescription);
            }
        }
        return new QueryBatcherJobTicket(dmm, queryBatcher, jobTicket);
    }

    @Override
    public List<String> configureJob(Properties props) {
        ArrayList<String> messages = new ArrayList<String>();
        for (JobProperty jobProperty : this.jobProperties) {
            String name = jobProperty.getPropertyName();
            String value = props.getProperty(name);
            if (value != null && value.trim().length() > 0) {
                jobProperty.getPropertyValueConsumer().accept(value);
                continue;
            }
            if (!jobProperty.isRequired()) continue;
            messages.add("The property '" + name + "' is required");
        }
        if (this.requireWhereProperty && !this.isWherePropertySet() && this.queryBatcherBuilder == null) {
            messages.add("At least one 'where' property must be set for selecting records to process");
        }
        return messages;
    }

    @Override
    public List<JobProperty> getJobProperties() {
        return this.jobProperties;
    }

    protected void addQueryBatcherJobProperties() {
        this.addJobProperty("batchSize", "Number of records to process at once; defaults to " + DEFAULT_BATCH_SIZE, value -> this.setBatchSize(Integer.parseInt(value)));
        this.addJobProperty("consistentSnapshot", "Whether or not to apply a consistent snapshot to the query for records; defaults to true", value -> this.setConsistentSnapshot(Boolean.parseBoolean(value)));
        this.addJobProperty("jobId", "Optional ID for the Data Movement job", value -> this.setJobId((String)value));
        this.addJobProperty("jobName", "Optional name for the Data Movement job", value -> this.setJobName((String)value));
        this.addJobProperty("logBatches", "Log each batch to stdout as it's processed", value -> this.addUrisReadyListener(new SimpleBatchLoggingListener()));
        this.addJobProperty("logBatchesWithLogger", "Log each batch as it's processed at the info-level using SLF4J", value -> this.addUrisReadyListener(new SimpleBatchLoggingListener(true)));
        this.addJobProperty("threadCount", "Number of threads to process records with; default to " + DEFAULT_THREAD_COUNT, value -> this.setThreadCount(Integer.parseInt(value)));
        this.addWhereJobProperties();
    }

    protected void addWhereJobProperties() {
        this.addJobProperty("whereCollections", "Comma-delimited list of collections for selecting records to process", value -> this.setWhereCollections(value.split(",")));
        this.addJobProperty("whereUriPattern", "URI pattern for selecting records to process", value -> this.setWhereUriPattern((String)value));
        this.addJobProperty("whereUris", "Comma-delimited list of URIs for selecting records to process", value -> this.setWhereUris(value.split(",")));
        this.addJobProperty("whereUrisQuery", "CTS URIs query for selecting records to process", value -> this.setWhereUrisQuery((String)value));
    }

    protected void addJobProperty(String name, String description, Consumer<String> propertyValueConsumer) {
        this.jobProperties.add(new SimpleJobProperty(name, description, propertyValueConsumer));
    }

    protected void addRequiredJobProperty(String name, String description, Consumer<String> propertyValueConsumer) {
        SimpleJobProperty prop = new SimpleJobProperty(name, description, propertyValueConsumer);
        prop.setRequired(true);
        this.jobProperties.add(prop);
    }

    protected void addTransformJobProperty(BiConsumer<String, ServerTransform> consumer) {
        this.addJobProperty("transform", "The name of a REST transform to apply to each record. Parameters can be passed to the transform by appending them to the value of this property, delimited by commas - e.g. myTransform,param1,value1,param2,value2", value -> consumer.accept((String)value, TransformPropertyValueParser.parsePropertyValue(value)));
    }

    protected void prepareQueryBatcher(QueryBatcher queryBatcher) {
        super.prepareBatcher((Batcher)queryBatcher);
        if (this.consistentSnapshot) {
            queryBatcher.withConsistentSnapshot();
        }
        if (this.urisReadyListeners != null) {
            for (QueryBatchListener queryBatchListener : this.urisReadyListeners) {
                queryBatcher.onUrisReady(queryBatchListener);
            }
        }
        if (this.queryFailureListeners != null) {
            for (QueryFailureListener queryFailureListener : this.queryFailureListeners) {
                queryBatcher.onQueryFailure(queryFailureListener);
            }
        }
    }

    protected QueryBatcherBuilder newQueryBatcherBuilder() {
        if (this.queryBatcherBuilder != null) {
            return this.queryBatcherBuilder;
        }
        if (this.whereUris != null && this.whereUris.length > 0) {
            return new DocumentUrisQueryBatcherBuilder(this.whereUris);
        }
        if (this.whereCollections != null) {
            return new CollectionsQueryBatcherBuilder(this.whereCollections);
        }
        if (this.whereUriPattern != null) {
            return new UriPatternQueryBatcherBuilder(this.whereUriPattern);
        }
        if (this.whereUrisQuery != null) {
            return new UrisQueryQueryBatcherBuilder(this.whereUrisQuery);
        }
        return null;
    }

    protected String getQueryDescription() {
        if (this.queryBatcherBuilder != null) {
            return "with custom query";
        }
        if (this.whereUris != null && this.whereUris.length > 0) {
            return "with URIs " + Arrays.asList(this.whereUris);
        }
        if (this.whereCollections != null && this.whereCollections.length > 0) {
            return "in collections " + Arrays.asList(this.whereCollections);
        }
        if (this.whereUriPattern != null) {
            return "matching URI pattern [" + this.whereUriPattern + "]";
        }
        if (this.whereUrisQuery != null) {
            return "matching URIs query [" + this.whereUrisQuery + "]";
        }
        return null;
    }

    protected boolean isWherePropertySet() {
        return this.whereUris != null && this.whereUris.length > 0 || this.whereCollections != null && this.whereCollections.length > 0 || this.whereUriPattern != null || this.whereUrisQuery != null;
    }

    public void addUrisReadyListener(QueryBatchListener listener) {
        if (this.urisReadyListeners == null) {
            this.urisReadyListeners = new ArrayList<QueryBatchListener>();
        }
        this.urisReadyListeners.add(listener);
    }

    public void addQueryFailureListener(QueryFailureListener listener) {
        if (this.queryFailureListeners == null) {
            this.queryFailureListeners = new ArrayList<QueryFailureListener>();
        }
        this.queryFailureListeners.add(listener);
    }

    public String[] getWhereCollections() {
        return this.whereCollections;
    }

    public AbstractQueryBatcherJob setWhereCollections(String ... whereCollections) {
        this.whereCollections = whereCollections;
        return this;
    }

    public String getWhereUriPattern() {
        return this.whereUriPattern;
    }

    public AbstractQueryBatcherJob setWhereUriPattern(String whereUriPattern) {
        this.whereUriPattern = whereUriPattern;
        return this;
    }

    public String getWhereUrisQuery() {
        return this.whereUrisQuery;
    }

    public AbstractQueryBatcherJob setWhereUrisQuery(String whereUrisQuery) {
        this.whereUrisQuery = whereUrisQuery;
        return this;
    }

    public String[] getWhereUris() {
        return this.whereUris;
    }

    public AbstractQueryBatcherJob setWhereUris(String ... whereUris) {
        this.whereUris = whereUris;
        return this;
    }

    public List<QueryBatchListener> getUrisReadyListeners() {
        return this.urisReadyListeners;
    }

    public AbstractQueryBatcherJob setUrisReadyListeners(List<QueryBatchListener> urisReadyListeners) {
        this.urisReadyListeners = urisReadyListeners;
        return this;
    }

    public List<QueryFailureListener> getQueryFailureListeners() {
        return this.queryFailureListeners;
    }

    public AbstractQueryBatcherJob setQueryFailureListeners(List<QueryFailureListener> queryFailureListeners) {
        this.queryFailureListeners = queryFailureListeners;
        return this;
    }

    public boolean isConsistentSnapshot() {
        return this.consistentSnapshot;
    }

    public AbstractQueryBatcherJob setConsistentSnapshot(boolean consistentSnapshot) {
        this.consistentSnapshot = consistentSnapshot;
        return this;
    }

    public boolean isAwaitCompletion() {
        return this.awaitCompletion;
    }

    public AbstractQueryBatcherJob setAwaitCompletion(boolean awaitCompletion) {
        this.awaitCompletion = awaitCompletion;
        return this;
    }

    public boolean isStopJobAfterCompletion() {
        return this.stopJobAfterCompletion;
    }

    public AbstractQueryBatcherJob setStopJobAfterCompletion(boolean stopJobAfterCompletion) {
        this.stopJobAfterCompletion = stopJobAfterCompletion;
        return this;
    }

    public AbstractQueryBatcherJob setDataMovementManager(DataMovementManager dataMovementManager) {
        this.dataMovementManager = dataMovementManager;
        return this;
    }

    public AbstractQueryBatcherJob setQueryBatcherBuilder(QueryBatcherBuilder queryBatcherBuilder) {
        this.queryBatcherBuilder = queryBatcherBuilder;
        return this;
    }

    public void setRequireWhereProperty(boolean requireWhereProperty) {
        this.requireWhereProperty = requireWhereProperty;
    }
}

