/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.dataservices.ExecEndpoint;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.BufferableHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubClient;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.tuple.Pair;

public class CreatedByStepFixer
extends LoggingObject {
    private HubClient hubClient;
    private int batchSize = 50;
    private int threadCount = 0;

    public CreatedByStepFixer(HubClient hubClient) {
        this.hubClient = hubClient;
    }

    public void fixInDatabase(String databaseName) {
        this.runFixScript(this.determineClient(databaseName));
    }

    public Pair<Long, String> previewFixingDocuments(String databaseName) {
        DatabaseClient client = this.determineClient(databaseName);
        String script = "const stepDefinitionNames = fn.collection('http://marklogic.com/data-hub/step-definition')\n  .toArray().map(stepDef => stepDef.toObject().name);\ncts.estimate(cts.fieldValueQuery('datahubCreatedByStep', stepDefinitionNames))";
        long count = Long.parseLong((String)client.newServerEval().javascript(script).evalAs(String.class));
        if (count == 0L) {
            return Pair.of((Object)0L, null);
        }
        script = "const stepDefinitionNames = fn.collection('http://marklogic.com/data-hub/step-definition')\n  .toArray().map(stepDef => stepDef.toObject().name);\nfn.head(cts.uris(null, ['limit=1'], cts.fieldValueQuery('datahubCreatedByStep', stepDefinitionNames)))";
        String uri = (String)client.newServerEval().javascript(script).evalAs(String.class);
        return Pair.of((Object)count, (Object)uri);
    }

    private DatabaseClient determineClient(String databaseName) {
        if (this.hubClient.getDbName(DatabaseKind.FINAL).equalsIgnoreCase(databaseName)) {
            return this.hubClient.getFinalClient();
        }
        if (this.hubClient.getDbName(DatabaseKind.STAGING).equalsIgnoreCase(databaseName)) {
            return this.hubClient.getStagingClient();
        }
        throw new IllegalArgumentException("Database name does not correspond to staging or final database: " + databaseName);
    }

    private void runFixScript(DatabaseClient contentClient) {
        DataMovementManager dmm = contentClient.newDataMovementManager();
        ArrayList forestIds = new ArrayList();
        Arrays.stream(dmm.readForestConfig().listForests()).iterator().forEachRemaining(forest -> forestIds.add(forest.getForestId()));
        JSONWriteHandle bulkApi = (JSONWriteHandle)this.hubClient.getModulesClient().newJSONDocumentManager().read("/data-hub/5/data-services/bulk/fixCreatedByStep.api", (AbstractReadHandle)new JacksonHandle());
        ObjectMapper mapper = new ObjectMapper();
        int queryBatcherThreadCount = this.threadCount > 0 ? this.threadCount : forestIds.size();
        QueryBatcher queryBatcher = dmm.newQueryBatcher(forestIds.iterator()).withBatchSize(1).withThreadCount(queryBatcherThreadCount).onUrisReady(batch -> {
            if (batch.getItems() != null && ((String[])batch.getItems()).length > 0) {
                ExecEndpoint.BulkExecCaller bulkCaller = ExecEndpoint.on((DatabaseClient)contentClient, (JSONWriteHandle)bulkApi).bulkCaller();
                ObjectNode workUnit = mapper.createObjectNode();
                workUnit.put("forestId", ((String[])batch.getItems())[0]);
                workUnit.put("batchSize", this.batchSize);
                bulkCaller.setWorkUnit((BufferableHandle)new JacksonHandle((JsonNode)workUnit));
                bulkCaller.setEndpointState((BufferableHandle)new JacksonHandle((JsonNode)mapper.createObjectNode()));
                bulkCaller.awaitCompletion();
            }
        }).onQueryFailure(failure -> this.logger.error("Error occurred while processing documents for a forest: " + failure.getMessage(), (Throwable)failure));
        dmm.startJob(queryBatcher);
        queryBatcher.awaitCompletion();
        dmm.stopJob((Batcher)queryBatcher);
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }
}

